/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.mufgb.chn.utils;

import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Packer.class);

    public static Element createRootWithHead(String transCode) {
        Element root = JDomUtils.createRoot((String)"h2h");
        Element Head = JDomUtils.addChild((Element)root, (String)"reqInfo");
        JDomUtils.addChild((Element)Head, (String)"transCode", (String)transCode);
        JDomUtils.addChild((Element)Head, (String)"pkgNo", (String)Packer.pkgNo());
        String clientCode = RequestContextUtils.getBankParameterValue((String)"check_code");
        JDomUtils.addChild((Element)Head, (String)"clientCode", (String)clientCode);
        JDomUtils.addChild((Element)Head, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        return root;
    }

    private static String pkgNo() {
        String autoincrementNumber = Sequence.getAutoincrementNumber((int)6);
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyMMdd")) + autoincrementNumber;
    }

    public static String transferRequestToWsdl(String requestMessage) {
        StringBuilder reqMsg = new StringBuilder();
        try {
            String postBaseString = Base64.getEncoder().encodeToString(requestMessage.getBytes(RequestContextUtils.getCharset()));
            reqMsg.append("<soapenv:Envelope \r\nxmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" \r\nxmlns:ser=\"http://ws.erp.bps.product.mind.com/\">");
            reqMsg.append(" <soapenv:Body>\n");
            reqMsg.append(" <ser:invoke>\n");
            reqMsg.append(" <requestXML>\n");
            reqMsg.append(postBaseString).append("\n");
            reqMsg.append("</requestXML>\n");
            reqMsg.append(" </ser:invoke>\n");
            reqMsg.append(" </soapenv:Body>\n");
            reqMsg.append("</soapenv:Envelope>");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return reqMsg.toString();
    }

    public static String packBalanceRequest(BankBalanceRequest bankBalanceRequest) {
        Element root = Packer.createRootWithHead("h2h.001.001");
        Element body = JDomUtils.createRoot((String)"req");
        JDomUtils.addChild((Element)body, (String)"accNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)root, (Element)body);
        String requestMessage = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        logger.info("\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\u539f\u6587\uff1a" + requestMessage);
        return Packer.transferRequestToWsdl(requestMessage);
    }
}

