/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.mufgb.chn.utils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Paser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Paser.class);

    public static List<BalanceInfo> paserBalance(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = Paser.parseH2H(rspStr);
        Element head = root.getChild("respInfo");
        String respCode = head.getChildTextTrim("respCode");
        String respMsg = head.getChildTextTrim("respMsg");
        String acceptFlag = head.getChildTextTrim("acceptFlag");
        if (!"1".equalsIgnoreCase(acceptFlag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s", (String)"Paser_0", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), respCode, respMsg));
        }
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        Element resp = root.getChild("resp");
        String statusFlag = resp.getChild("statusFlag").getTextTrim();
        if ("-1".equalsIgnoreCase(statusFlag)) {
            BalanceInfo balanceInfo = new BalanceInfo();
            balances.add(balanceInfo);
            return balances;
        }
        String acctNo = resp.getChildText("accNo");
        if (!bankBalanceRequest.getAcnt().getAccNo().equalsIgnoreCase(acctNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7%1$s\u4e0e\u8bf7\u6c42\u8d26\u53f7%2$s\u4e0d\u4e00\u81f4", (String)"Paser_1", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), acctNo, bankBalanceRequest.getAcnt().getAccNo()));
        }
        List rows = resp.getChildren("row");
        for (Element row : rows) {
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            String currCode = row.getChildTextTrim("currCode");
            if (!bankBalanceRequest.getBankCurrency().equalsIgnoreCase(currCode)) {
                balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4f59\u989d\u5e01\u79cd%1$s\u4e0e\u67e5\u8be2\u5e01\u79cd%2$s\u4e0d\u4e00\u81f4\uff0c\u5ffd\u7565\u8be5\u6761\u8bb0\u5f55\u3002", (String)"Paser_2", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), currCode, bankBalanceRequest.getBankCurrency()));
            } else {
                String availablBalance;
                balanceInfo.setBankCurrency(currCode);
                String balance = row.getChildTextTrim("balance");
                if (StringUtils.isNotEmpty((String)balance)) {
                    balanceInfo.setCurrentBalance(new BigDecimal(balance));
                } else {
                    balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"Paser_3", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), currCode, bankBalanceRequest.getBankCurrency()));
                }
                String initBalance = row.getChildTextTrim("initBalance");
                if (StringUtils.isNotEmpty((String)initBalance)) {
                    balanceInfo.setLastDayAvlBalance(new BigDecimal(initBalance));
                }
                if (StringUtils.isNotEmpty((String)(availablBalance = row.getChildTextTrim("availablBalance")))) {
                    balanceInfo.setAvailableBalance(new BigDecimal(availablBalance));
                }
                balanceInfo.setBalanceDateTime(LocalDateTime.parse(row.getChildTextTrim("balanceTime")));
            }
            balances.add(balanceInfo);
        }
        return balances;
    }

    public static Element parseH2H(String response) {
        Element xmlroot = JDomUtils.string2Root((String)response, (String)RequestContextUtils.getCharset());
        Element Body = (Element)xmlroot.getChildren().get(0);
        Element invokeResponse = (Element)Body.getChildren().get(0);
        String responseXML = invokeResponse.getChildText("responseXML");
        String postBaseString = new String(Base64.getDecoder().decode(responseXML));
        logger.info("base64\u89e3\u7801\u540e\u54cd\u5e94\u62a5\u6587:" + postBaseString);
        return JDomUtils.string2Root((String)postBaseString, (String)RequestContextUtils.getCharset());
    }
}

