/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.dc.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.dc.services.utils.PgpHelper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String rspStr = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"todayDetailUri"), acnt.getAccNo(), this.pack(request));
        return this.parse(request, rspStr);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        JSONObject header = DBS_DC_Packer.createHeader(acnt.getAccNo(), acnt.getCountry());
        JSONObject txnInfo = new JSONObject();
        txnInfo.put("accountNo", (Object)acnt.getAccNo());
        txnInfo.put("accountCcy", (Object)bankDetailRequest.getBankCurrency());
        txnInfo.put("messageType", (Object)"CAMT052JSON");
        JSONObject total = new JSONObject();
        total.put("header", (Object)header);
        total.put("txnInfo", (Object)txnInfo);
        try {
            return PgpHelper.encry(total.toJSONString());
        }
        catch (Throwable e) {
            logger.error("\u660e\u7ec6\u67e5\u8be2pgp\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        String origin;
        try {
            origin = PgpHelper.decry(rspStr);
        }
        catch (Throwable e) {
            logger.error("\u660e\u7ec6\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\u9a8c\u7b7e\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"TodayDetailImpl_1", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return this.parseInfo(origin, bankDetailRequest);
    }

    public EBBankDetailResponse parseInfo(String origin, BankDetailRequest bankDetailRequest) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        JSONObject total = JSONObject.parseObject((String)origin);
        DBS_DC_Parser.checkError(total);
        JSONObject txnEnqResponse = total.getJSONObject("txnEnqResponse");
        String enqStatus = txnEnqResponse.getString("enqStatus");
        if (!"ACSP".equals(enqStatus)) {
            String enqStatusDescription = txnEnqResponse.getString("enqStatusDescription");
            if ("RJCT".equals(enqStatus) && "No statement available".equals(enqStatusDescription)) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c%1$s %2$s\u3002", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), enqStatus, enqStatusDescription));
        }
        JSONArray statements = txnEnqResponse.getJSONArray("statements");
        for (int j = 0; j < statements.size(); ++j) {
            JSONObject bkToCstmrAcctRpt = statements.getJSONObject(j).getJSONObject("bkToCstmrAcctRpt");
            JSONArray rptList = bkToCstmrAcctRpt.getJSONArray("rpt");
            for (int k = 0; k < rptList.size(); ++k) {
                JSONObject rpt = rptList.getJSONObject(k);
                BankAcnt acnt = bankDetailRequest.getAcnt();
                JSONArray ntryList = rpt.getJSONArray("ntry");
                if (ntryList == null || ntryList.size() == 0) {
                    return new EBBankDetailResponse(detailList);
                }
                for (int i = 0; i < ntryList.size(); ++i) {
                    JSONObject ntry = ntryList.getJSONObject(i);
                    DetailInfo info = new DetailInfo();
                    info.setAccNo(acnt.getAccNo());
                    info.setAccName(acnt.getAccName());
                    info.setBankName(acnt.getBankName());
                    JSONArray ntryDtlsArray = ntry.getJSONArray("ntryDtls");
                    JSONArray txDtlsArray = ntryDtlsArray.getJSONObject(0).getJSONArray("txDtls");
                    JSONObject rltdPties = txDtlsArray.getJSONObject(0).getJSONObject("rltdPties");
                    JSONObject amt = ntry.getJSONObject("amt");
                    info.setCurrency(amt.getString("ccy"));
                    String amount = amt.getString("value");
                    String cdFlag = ntry.getString("cdtDbtInd");
                    if ("DBIT".equals(cdFlag)) {
                        info.setDebitAmount(new BigDecimal(amount));
                        info.setCreditAmount(BigDecimal.ZERO);
                        if (rltdPties != null) {
                            JSONObject cdtrAcct;
                            JSONObject cdtr = rltdPties.getJSONObject("cdtr");
                            if (cdtr != null) {
                                info.setOppAccName(cdtr.getString("nm"));
                            }
                            if ((cdtrAcct = rltdPties.getJSONObject("cdtrAcct")) != null) {
                                info.setOppAccNo(cdtrAcct.getJSONObject("id").getJSONObject("othr").getString("id"));
                            }
                        }
                    } else if ("CRDT".equals(cdFlag)) {
                        JSONObject dbtr;
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(new BigDecimal(amount));
                        if (rltdPties != null && (dbtr = rltdPties.getJSONObject("dbtr")) != null) {
                            info.setOppAccName(dbtr.getString("nm"));
                            JSONObject id = dbtr.getJSONObject("id");
                            if (id != null) {
                                info.setOppAccNo(id.getJSONObject("orgId").getJSONObject("othr").getString("id"));
                            }
                        }
                    }
                    String vt = ntry.getJSONObject("bookgDt").getString("dtTm");
                    try {
                        vt = vt.replaceAll(":", "");
                        LocalDateTime transTime = LocalDateTime.parse(vt, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssZ"));
                        info.setTransTime(transTime);
                        info.setTransDate(transTime.toLocalDate());
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u89e3\u6790\u7684\u5b57\u6bb5\u4e3a\uff1a%s\u3002", (String)"TodayDetailImpl_5", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), vt), (Throwable)e);
                    }
                    String addtlNtryInf = ntry.getString("addtlNtryInf");
                    if (BankBusinessConfig.isNeedSubExplanation()) {
                        try {
                            String[] split;
                            if (addtlNtryInf.indexOf("TXCD?") != -1) {
                                addtlNtryInf = addtlNtryInf.substring(addtlNtryInf.indexOf("TXCD?") + 5);
                            } else if (addtlNtryInf.startsWith("TD?") && (split = addtlNtryInf.split("\\?")).length > 1) {
                                addtlNtryInf = split[1];
                            }
                        }
                        catch (Throwable e) {
                            logger.error("\u6458\u8981\u622a\u53d6\u5f02\u5e38", e);
                        }
                    }
                    info.setExplanation(addtlNtryInf);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("dt", (Object)ntry.getJSONObject("valDt").getString("dt"));
                    String ntryRef = ntry.getString("ntryRef");
                    jsonObject.put("ntryRef", (Object)ntryRef);
                    info.setJsonMap(jsonObject.toJSONString());
                    info.setBankDetailNo(ntryRef);
                    detailList.add(info);
                }
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CAMT052JSON";
    }

    public String getBizDesc() {
        return null;
    }
}

