/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ksrcb.dc.services.payment.batch;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ksrcb.dc.services.payment.batch.BatchQueryHelper;
import kd.ebg.aqap.banks.ksrcb.dc.utils.QueryPayDownLoadFrontProxy;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TCommon;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBatchPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryBatchPayImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200112";
    }

    public String getBizDesc() {
        return null;
    }

    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest request) {
        String tr_code = "200112";
        Element ap = TPacker.createCommonHead(tr_code, Sequence.genSequence());
        Element body = ap.getChild("body");
        List paymentInfos = request.getPaymentInfos();
        String date = ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"start_date", (String)date);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)date);
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element head = ap.getChild("head");
        BankResponse bankResponse = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"QueryBatchPayImpl_0", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]));
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String serial_record = "";
        if ("1".equals(file_flag)) {
            log.info("\u672c\u6b21\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                serial_record = new QueryPayDownLoadFrontProxy().doBiz(file_name);
            }
            catch (Exception e) {
                log.error("\u4ece\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"QueryBatchPayImpl_1", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            serial_record = body.getChildTextTrim("serial_record");
        }
        String[][] mfs = this.parseMFS(serial_record, recordNum, fieldNum);
        String serial_no = "";
        for (int i = 0; i < mfs.length; ++i) {
            String[] r = mfs[i];
            String batchNo = r[1];
            if (!((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId().equals(batchNo)) continue;
            serial_no = r[0];
            break;
        }
        if (StringUtils.isEmpty((String)serial_no)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u6839\u636e\u6279\u6b21\u53f7:%s\u5728\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u7684\u94f6\u884c\u6d41\u6c34\u53f7", (String)"QueryBatchPayImpl_9", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        if (EBContext.getContext().isUnitTest()) {
            return new EBBankPayResponse();
        }
        String requestStr = this.pack200202(paymentInfos, serial_no);
        String response = BatchQueryHelper.sendAndReceive(requestStr);
        return this.parse200202(paymentInfos, response);
    }

    public EBBankPayResponse parse200202(List<PaymentInfo> paymentInfos, String response) {
        Element ap = JDomUtils.string2Root((String)response, (String)RequestContextUtils.getCharset());
        Element head = ap.getChild("head");
        BankResponse bankResponse = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"QueryBatchPayImpl_0", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]));
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String serial_record = "";
        if ("1".equals(file_flag)) {
            log.info("\u672c\u6b21\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                serial_record = new QueryPayDownLoadFrontProxy().doBiz(file_name);
            }
            catch (Exception e) {
                log.error("\u4ece\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"QueryBatchPayImpl_4", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            serial_record = body.getChildTextTrim("serial_record");
        }
        String[][] mfs = this.parseMFS(serial_record, recordNum, fieldNum);
        for (int i = 0; i < mfs.length; ++i) {
            String[] r = mfs[i];
            String cert_no = r[4];
            String stat = r[25];
            String error_info = r[26];
            PaymentInfo paymentInfo = this.findPaymentInfo(paymentInfos, cert_no);
            if (paymentInfo == null) continue;
            if ("9".equals(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryBatchPayImpl_5", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryBatchPayImpl_5", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("1".equals(stat) || "6".equals(stat) || "7".equals(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryBatchPayImpl_6", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
                continue;
            }
            if ("0".equals(stat) || "2".equals(stat) || "3".equals(stat) || "4".equals(stat) || "5".equals(stat) || "A".equals(stat) || "C".equals(stat) || "D".equals(stat) || "E".equals(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryBatchPayImpl_7", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryBatchPayImpl_8", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private PaymentInfo findPaymentInfo(List<PaymentInfo> paymentInfos, String cert_no) {
        if (CollectionUtil.isEmpty(paymentInfos)) {
            return null;
        }
        for (PaymentInfo paymentInfo : paymentInfos) {
            if (!StringUtils.equals((String)paymentInfo.getBankDetailSeqId(), (String)cert_no)) continue;
            return paymentInfo;
        }
        return null;
    }

    public String pack200202(List<PaymentInfo> paymentInfos, String serial_no) {
        String tr_code = "200202";
        Element ap = TPacker.createCommonHead(tr_code, Sequence.genSequence());
        Element body = ap.getChild("body");
        String date = paymentInfos.get(0).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)date);
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfos.get(0).getBankBatchSeqId());
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(xmlMsg);
    }

    private String[][] parseMFS(String content, int recordNum, int fieldNum) {
        String[] allRecord = StringUtils.split((String)content, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allRecord[i * fieldNum + j];
            }
        }
        return r2;
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

