/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nhb.dc.services.payment.company.inner;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nhb.dc.services.payment.company.CompanyQueryImpl;
import kd.ebg.aqap.banks.nhb.dc.utils.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InnerBankPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2EBankInnerTransfer", paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"SubmitNo", (String)paymentInfos[0].getBankBatchSeqId());
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            JDomUtils.addChild((Element)map, (String)"ListNo", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"Amount", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)map, (String)"ReMark", (String)paymentInfos[i].getExplanation());
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element error = root.getChild("error");
        if (null != error) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error.getTextTrim());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)iBSReturnCode, (String)iBSReturnMsg);
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        if (null == list) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de<List>\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"InnerBankPaymentImpl_0", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        List maps = list.getChildren();
        if (null == maps || maps.isEmpty()) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de<Map>\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"InnerBankPaymentImpl_1", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = map.getChildTextTrim("ReturnCode");
            String returnMsg = map.getChildTextTrim("ReturnMsg");
            String listNo = map.getChildTextTrim("ListNo");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)listNo);
            if (null == paymentInfo) continue;
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"InnerBankPaymentImpl_2", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("777777".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EBankInnerTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.3.4 \u884c\u5185\u8f6c\u4ed6\u4eba\uff08\u652f\u6301\u591a\u7b14\uff09\uff08\u4ea4\u6613\u7801B2EBankInnerTransfer\uff09", (String)"InnerBankPaymentImpl_3", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }
}

