/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dlb.dc.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dlb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.dlb.dc.service.proxy.ProxyDownload;
import kd.ebg.aqap.banks.dlb.dc.utils.DLBUtils;
import kd.ebg.aqap.banks.dlb.dc.utils.DLB_DC_Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        String req_no = Sequence.gen18Sequence();
        Element ap = DLB_DC_Packer.builedHead("416B200110A", req_no);
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"acno", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CMS_CORP_NO"));
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        String xmlInfo = DLBUtils.forStringLengthByte(xmlStr);
        return xmlInfo;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        String data;
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        rspStr = rspStr.substring(12);
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        BankResponse rsp = new BankResponse();
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        rsp.setResponseCode(succ_flag + "_" + ret_code);
        rsp.setResponseMessage(ret_info);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0:%1$s,%2$s", (String)"DetailImpl_7", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            return new EBBankDetailResponse(detailList);
        }
        if ("1".equalsIgnoreCase(file_flag)) {
            ProxyDownload proxyDownload = new ProxyDownload();
            String file_name = body.getChildTextTrim("file_name");
            data = proxyDownload.doBiz(file_name);
        } else if ("0".equalsIgnoreCase(file_flag)) {
            data = body.getChildTextTrim("serial_record");
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\u3002\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684file_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u5bfc\u81f4\u94f6\u4f01\u4e91\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
        }
        String[] splits = StringUtils.split((String)data, (String)"|");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        DetailFieldConf detailField = DetailFieldUtil.getInstance().getDetailField(EBContext.getContext().getBankVersionID(), "416B200110A");
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            this.logger.info("\u7b2c{}\u6761\u4ea4\u6613\u660e\u7ec6\u7684\u5185\u5bb9\uff1a{}", new Object[]{i, buffer.toString()});
            String acno = splits[fieldNum * i + 1];
            String cur_code = splits[fieldNum * i + 2];
            String tr_acdt = splits[fieldNum * i + 3];
            String tr_time = splits[fieldNum * i + 4];
            String host_serial_no = splits[fieldNum * i + 6];
            String oppAcntNumber = splits[fieldNum * i + 9];
            String oppName = splits[fieldNum * i + 11];
            String oppBank = splits[fieldNum * i + 12];
            String crdr_flag = splits[fieldNum * i + 24];
            String amt = splits[fieldNum * i + 25];
            String balance = splits[fieldNum * i + 26];
            String purpose = splits[fieldNum * i + 35];
            String postscript = splits[fieldNum * i + 36];
            String bank = splits[fieldNum * i + 42];
            if (!request.getAcnt().getAccNo().equals(acno)) {
                this.logger.info("===\u8bf7\u6c42\u8d26\u53f7[" + request.getAcnt().getAccNo() + "]\u548c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[" + acno + "]\u4e0d\u4e00\u81f4\uff0c\u88ab\u8fc7\u6ee4\u7684\u660e\u7ec6===");
                continue;
            }
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(request.getAcnt().getAccName());
            detail.setBankName(bank);
            detail.setOppAccNo(oppAcntNumber);
            detail.setOppAccName(oppName);
            detail.setOppBankName(oppBank);
            detail.setCurrency(cur_code);
            if (!StringUtils.isEmpty((String)host_serial_no)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)host_serial_no);
            }
            try {
                if (StringUtils.isEmpty((String)tr_acdt)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
                }
                String transTime = StringUtils.isEmpty((String)tr_time) ? tr_acdt + "000000" : tr_acdt + tr_time;
                detail.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detail.setTransTime(LocalDateTime.parse(transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38.%s", (String)"DetailImpl_8", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            String zero = "0.00";
            if ("D".equals(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal(amt));
                detail.setCreditAmount(new BigDecimal(zero));
            } else if ("C".equals(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal(zero));
                detail.setCreditAmount(new BigDecimal(amt));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u5fd7crdr_flag\u4e3a%s\uff0c\u671f\u5f85\u8fd4\u56deC\u6216\u8005D\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), crdr_flag));
            }
            this.logger.info("\u4ea4\u6613\u660e\u7ec6:\u7b2c" + i + "\u6761\uff0cpurpose=" + purpose);
            this.logger.info("\u4ea4\u6613\u660e\u7ec6:\u7b2c" + i + "\u6761\uff0cpostscript=" + postscript);
            StringBuilder sb = new StringBuilder();
            sb.append(acno).append('_').append(tr_acdt).append('_').append(host_serial_no).append('_').append(amt).append('_').append(crdr_flag);
            JSONObject jsonObject = new JSONObject();
            String json = null;
            if (detailField != null) {
                json = MatchRule.getInstance().getDetailJsonWithNonStructuredData(detailField.getDetailFields(), buffer.toString(), detailField.getSplit());
            }
            if (StringUtils.isNotEmpty(json)) {
                jsonObject = JSON.parseObject(json);
            }
            jsonObject.put("accno", (Object)acno);
            jsonObject.put("transDate", (Object)tr_acdt);
            jsonObject.put("host_serial_no", (Object)host_serial_no);
            jsonObject.put("amt", (Object)amt);
            jsonObject.put("crdr_flag", (Object)crdr_flag);
            detail.setJsonMap(jsonObject.toJSONString());
            String accNo = acno;
            String transDate = tr_acdt;
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            if (!StringUtils.isEmpty((String)postscript) && postscript.indexOf("@KD") != -1) {
                String[] postscripts = postscript.split("@KD");
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)postscripts[0]);
                this.logger.info("\u4ea4\u6613\u660e\u7ec6:KDRetFlag=" + postscripts[0]);
                if (postscripts.length > 1) {
                    postscript = postscripts[1];
                }
            }
            String explan = purpose;
            if (BankBusinessConfig.detailExpChoose().equals("postscript")) {
                explan = postscript;
            } else if (BankBusinessConfig.detailExpChoose().equals("postsAndPurpose") && ((explan = purpose + ";" + postscript).startsWith(";") || explan.endsWith(";"))) {
                explan = explan.replace(";", "");
            }
            detail.setExplanation(explan);
            detail.setBankDetailNo(host_serial_no);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "416B200110A";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_6", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]);
    }
}

