/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dlb.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dlb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.dlb.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.dlb.dc.service.proxy.ProxyUpload;
import kd.ebg.aqap.banks.dlb.dc.utils.DLBUtils;
import kd.ebg.aqap.banks.dlb.dc.utils.DLB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String size = String.valueOf(paymentInfos.size());
        Element ap = DLB_DC_Packer.builedHead("416B300002", paymentInfo.getBankBatchSeqId(), true);
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno");
        JDomUtils.addChild((Element)body, (String)"as_acname");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr");
        JDomUtils.addChild((Element)body, (String)"field_num", (String)"6");
        JDomUtils.addChild((Element)body, (String)"record_num", (String)size);
        JDomUtils.addChild((Element)body, (String)"amt");
        String purpose = paymentInfo.getExplanation();
        if (ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]).equals(purpose)) {
            JDomUtils.addChild((Element)body, (String)"reserved3", (String)"1");
        } else {
            JDomUtils.addChild((Element)body, (String)"reserved3", (String)"");
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)body, (String)"purpose", (String)(paymentInfo.getBankDetailSeqId() + "@KD" + paymentInfo.getExplanation()));
        }
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"1001");
        String fileName = paymentInfo.getBankBatchSeqId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"count", (String)size);
        BigDecimal amount = BigDecimalHelper.ZERO;
        StringBuilder ftb = new StringBuilder();
        ftb.append("ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|");
        ftb.append("\r\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            ftb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo()).append("|");
            ftb.append(((PaymentInfo)paymentInfos.get(i)).getCurrency()).append("|");
            ftb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append("|");
            ftb.append("0").append("|");
            ftb.append(((PaymentInfo)paymentInfos.get(i)).getAmount().setScale(2, 1).toString()).append("|");
            ftb.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append("|");
            if (i < paymentInfos.size() - 1) {
                ftb.append("\r\n");
            }
            amount = BigDecimalHelper.add((BigDecimal)amount, (BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount());
        }
        JDomUtils.getChildElement((Element)body, (String)"amt").addContent(amount.setScale(2, 1).toString());
        ProxyUpload proxyUpload = new ProxyUpload(ftb.toString());
        proxyUpload.doBiz(fileName);
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return DLBUtils.forStringLengthByte(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s.substring(12), (String)encoding);
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String serial_no = head.getChildTextTrim("serial_no");
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"serial_no", (String)serial_no);
        if ("0".equalsIgnoreCase(succ_flag) && "0000".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)(succ_flag + "_" + ret_code), (String)ret_info);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)(succ_flag + "_" + ret_code), (String)ret_info);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "416B300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5de5\u8d44\u4ee3\u53d1", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

