/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc;

import java.io.UnsupportedEncodingException;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;

public class HSBUtils {
    public static final String SERIAL_NO = "serial_no";

    public static int getStringAbusolteLength(String str) throws EBServiceException {
        int length = 0;
        try {
            length = str.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return length;
    }

    public static String getHSBFileContent(String content, boolean isEncy) throws EBServiceException {
        String temp = null;
        temp = isEncy ? "10" + content : "00" + content;
        String headerLengthString = HSBUtils.getStringAbusolteLength(temp) + "";
        int headerLength = headerLengthString.length();
        if (headerLength < 10) {
            for (int i = 0; i < 10 - headerLength; ++i) {
                headerLengthString = '0' + headerLengthString;
            }
        }
        return headerLengthString + temp;
    }

    public static boolean getCTReturnState(String respStr) {
        boolean flag = false;
        String temp = respStr.substring(12, 14);
        if (null != respStr && "ok".equalsIgnoreCase(temp)) {
            flag = true;
        }
        return flag;
    }

    public static String getCTReturnContent(String respStr) {
        return respStr.substring(14);
    }

    public static String getHsbUseCode(String useCn) {
        String useCode = null;
        if (null == useCode) {
            useCode = "11020172";
        }
        String customId = EBContext.getContext().getCustomID();
        String interfaceName = "300002";
        String bankVersion = "HSB_DC";
        useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)useCode, (String)bankVersion);
        return useCode;
    }

    public static void main(String[] str) throws EBServiceException {
        String temp = "000000000400ok";
        String out = HSBUtils.getHSBFileContent(temp, false);
        System.out.println(HSBUtils.getCTReturnState(temp));
    }
}

