/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationCommonUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationUtil;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliation;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliationRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliationResponse;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliationResponseBody;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceReconciliationMethod
implements EBServiceMethod<BalanceReconciliationRequest, BalanceReconciliationResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceReconciliationMethod.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository = (BalanceReconciliationDetailRepository)SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);

    public BalanceReconciliationRequest mappingCurrency(BalanceReconciliationRequest request) {
        String currency = request.getBody().getCurrency();
        currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency);
        request.getBody().setCurrency(currency);
        return request;
    }

    public BalanceReconciliationResponse mappingCurrency(BalanceReconciliationResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getBalanceReconciliations();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public BalanceReconciliationResponse executeClientRequest(BalanceReconciliationRequest request, EBContext context) {
        String error;
        String currency;
        AccessUtils.checkQueryAllowed(context);
        String monthStr = request.getBody().getMonth();
        LocalDate month = ReconciliationCommonUtil.checkMonth(monthStr);
        ArrayList<BalanceReconciliation> balanceReconciliations = new ArrayList<BalanceReconciliation>(16);
        String checkStatus = request.getBody().getCheckStatus();
        if (StringUtils.isEmpty((String)checkStatus)) {
            checkStatus = "Y";
        }
        if (StringUtils.isEmpty((String)(currency = request.getBody().getCurrency()))) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        List accNos = request.getBody().getAccNos();
        if (CollectionUtils.isEmpty((Collection)accNos)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (accNos.size() > 1000) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u7b14\u6570\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"BalanceReconciliationMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        ReconciliationCommonUtil.checkBankAcnts(accNos, balanceReconciliations, currency, monthStr);
        List details = this.balanceDetailRepository.findByCurrencyAndMonthAndAccNos(currency, month, accNos);
        if (CollectionUtils.isEmpty((Collection)details)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u5728%s\u65e0\u53ef\u53cd\u9988\u7684\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"BalanceReconciliationMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), monthStr));
        }
        ArrayList<BalanceReconciliationDetail> handleDetails = new ArrayList<BalanceReconciliationDetail>(1);
        for (BalanceReconciliationDetail detail : details) {
            error = "";
            String accNo = detail.getAccNo();
            if (BalanceReconciliationState.PACKAGED.getId() == detail.getStatusId().intValue() || BalanceReconciliationState.SUBMITED.getId() == detail.getStatusId().intValue()) {
                String statusName = BalanceReconciliationState.getEnumById(detail.getStatusId()).getCnName();
                error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u5df2\u53cd\u9988\uff0c\u5f53\u524d\u72b6\u6001\u4e3a%3$s\uff0c\u8bf7\u52ff\u91cd\u590d\u53cd\u9988\u3002", (String)"BalanceReconciliationMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr, statusName);
                this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u5df2\u53cd\u9988\uff0c\u5f53\u524d\u72b6\u6001\u4e3a{}\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr, statusName});
            } else if (BalanceReconciliationState.SUCCESS.getId() == detail.getStatusId().intValue()) {
                error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u5df2\u53cd\u9988\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u53cd\u9988\u3002", (String)"BalanceReconciliationMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u5df2\u53cd\u9988\u53cd\u9988\u5b8c\u6210\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
            } else if (BalanceReconciliationState.OTHER.getId() == detail.getStatusId().intValue()) {
                error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u5df2\u901a\u8fc7\u5176\u4ed6\u9014\u5f84\u53cd\u9988\uff0c\u8bf7\u52ff\u91cd\u590d\u53cd\u9988\u3002", (String)"BalanceReconciliationMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u5df2\u901a\u8fc7\u5176\u4ed6\u9014\u5f84\u53cd\u9988\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
            } else {
                String key = ReconciliationUtil.getCacheKey(accNo, currency, monthStr);
                if (StringUtils.isNotEmpty((String)CosmicCache.get((String)key))) {
                    error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c\u3002", (String)"BalanceReconciliationMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                    this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u6b63\u5728\u5904\u7406\u4e2d\uff08\u4e0a\u6b21\u5904\u7406\u65f6\u95f4\u4e3a\uff1a{}\uff09\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u6267\u884c\uff0c\u8df3\u8fc7\u672c\u6b21\u64cd\u4f5c\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr, CosmicCache.get((String)key)});
                } else {
                    String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
                    CosmicCache.putIfAbsentWithExpire((String)key, (String)timeStr, (int)10, (TimeUnit)TimeUnit.MINUTES);
                    detail.setHandleStatus("1");
                    detail.setCheckStatus(checkStatus);
                    handleDetails.add(detail);
                    accNos.remove(accNo);
                    BalanceReconciliation balanceReconciliation = this.buildBalanceReconciliationPackaged(accNo, currency, monthStr, detail.getBalance(), checkStatus);
                    balanceReconciliations.add(balanceReconciliation);
                    if (StringUtils.isEmpty((String)detail.getStatus())) {
                        detail.setHandleNum(Integer.valueOf(1));
                        this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u6682\u672a\u53cd\u9988\u8fc7\uff0c\u672c\u6b21\u65b0\u589e\u53cd\u9988", new Object[]{accNo, monthStr});
                    } else {
                        detail.setHandleNum(Integer.valueOf(detail.getHandleNum() + 1));
                        detail.setQueryNum(Integer.valueOf(0));
                        detail.setBankStatusMsg("");
                        String statusName = BalanceReconciliationState.getEnumById(detail.getStatusId()).getCnName();
                        this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5728{}\u7684\u72b6\u6001\u4e3a{}\uff0c\u672c\u6b21\u91cd\u65b0\u53cd\u9988", new Object[]{accNo, monthStr, statusName});
                    }
                    ReconciliationBusinessUtil.updateBalanceReconciliationState(detail, BalanceReconciliationState.PACKAGED);
                }
            }
            if (!StringUtils.isNotEmpty((String)error)) continue;
            balanceReconciliations.add(ReconciliationCommonUtil.getBalanceReconciliation(accNo, currency, monthStr, error));
            accNos.remove(accNo);
        }
        if (CollectionUtils.isNotEmpty((Collection)accNos)) {
            for (String accNo : accNos) {
                error = String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728%2$s\u65e0\u53ef\u53cd\u9988\u7684\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"BalanceReconciliationMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo, monthStr);
                balanceReconciliations.add(ReconciliationCommonUtil.getBalanceReconciliation(accNo, currency, monthStr, error));
                this.logger.info("\u68c0\u6d4b\u5230\u8d26\u53f7{}\u5728{}\u65e0\u53ef\u53cd\u9988\u7684\u4f59\u989d\u5bf9\u8d26\u5355\u8bb0\u5f55\uff0c\u8fd4\u56deerror", new Object[]{accNo, monthStr});
            }
        }
        this.saveBalanceReconciliationDetails(handleDetails);
        Map<String, List<BalanceReconciliationDetail>> groupMap = ReconciliationCommonUtil.groupByBankLoginId(handleDetails);
        new ReconciliationUtil().async(groupMap);
        BalanceReconciliationResponseBody body = new BalanceReconciliationResponseBody();
        body.setBalanceReconciliations(balanceReconciliations);
        return new BalanceReconciliationResponse(body);
    }

    private void saveBalanceReconciliationDetails(List<BalanceReconciliationDetail> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            TXHandle h = TX.requiresNew();
            try {
                this.balanceDetailRepository.updateAll(details);
            }
            catch (Exception ex) {
                h.markRollback();
                this.removeLockKey(details);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53cd\u9988\u8bb0\u5f55\u5199\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BalanceReconciliationMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)ex);
            }
            finally {
                try {
                    h.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void removeLockKey(List<BalanceReconciliationDetail> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            String monthStr = LocalDateUtil.formatDate((LocalDate)details.get(0).getSyncDate(), (String)"yyyyMM");
            for (BalanceReconciliationDetail detail : details) {
                CosmicCache.delete((String)ReconciliationUtil.getCacheKey(detail.getAccNo(), detail.getCurrency(), monthStr));
            }
        }
    }

    private BalanceReconciliation buildBalanceReconciliationPackaged(String accNo, String currency, String monthStr, String balance, String checkStatus) {
        BalanceReconciliation balanceReconciliation = ReconciliationCommonUtil.getBalanceReconciliation(accNo, currency, monthStr, "");
        balanceReconciliation.setBalance(balance);
        balanceReconciliation.setBankStatus("");
        balanceReconciliation.setBankStatusMsg("");
        balanceReconciliation.setCheckStatus(checkStatus);
        balanceReconciliation.setHandleStatus(Integer.valueOf(Integer.parseInt("1")));
        balanceReconciliation.setStatus(BalanceReconciliationState.PACKAGED.getEnName());
        balanceReconciliation.setStatusName(BalanceReconciliationState.PACKAGED.getCnName());
        return balanceReconciliation;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "balanceReconciliation";
    }
}

