/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation.utils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balancereconciliation.utils.MonthUtil;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliation;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ReconciliationCommonUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReconciliationCommonUtil.class);

    public static List<BankAcnt> checkBankAcnts(List<String> accNos, List<BalanceReconciliation> balanceReconciliations, String currency, String month) {
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        Iterator<String> iterator = accNos.iterator();
        while (iterator.hasNext()) {
            String accNo = iterator.next();
            BankAcnt acnt = BankAcntService.getInstance().selectEnableByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
            if (null == acnt) {
                balanceReconciliations.add(ReconciliationCommonUtil.getBalanceReconciliation(accNo, currency, month, ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u672a\u5728\u94f6\u4f01\u4e91\u7ef4\u62a4\u6216\u5df2\u5220\u9664\u3002", (String)"ReconciliationCommonUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0])));
                logger.info("\u68c0\u67e5\u5230\u672a\u7ef4\u62a4\u7684\u94f6\u884c\u8d26\u53f7{}\uff0c\u8fd4\u56deerror", (Object)accNo);
                iterator.remove();
                continue;
            }
            bankAcnts.add(acnt);
        }
        if (bankAcnts.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8d26\u53f7\u5217\u8868\u5728\u94f6\u4f01\u4e91\u91cc\u5747\u4e0d\u5b58\u5728\u3002", (String)"ReconciliationCommonUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        return bankAcnts;
    }

    public static Map<String, List<BalanceReconciliationDetail>> groupByBankLoginId(List<BalanceReconciliationDetail> details) {
        HashMap<String, List<BalanceReconciliationDetail>> result = new HashMap<String, List<BalanceReconciliationDetail>>();
        for (BalanceReconciliationDetail detail : details) {
            String bankLoginId = detail.getBankLoginID();
            if (result.get(bankLoginId) != null) {
                ((List)result.get(bankLoginId)).add(detail);
                continue;
            }
            ArrayList<BalanceReconciliationDetail> details1 = new ArrayList<BalanceReconciliationDetail>(1);
            details1.add(detail);
            result.put(bankLoginId, details1);
        }
        return result;
    }

    public static BalanceReconciliation getBalanceReconciliation(String accNo, String currency, String monthStr, String error) {
        BalanceReconciliation balanceReconciliation = new BalanceReconciliation();
        balanceReconciliation.setError(error);
        balanceReconciliation.setAccNo(accNo);
        balanceReconciliation.setCurrency(currency);
        balanceReconciliation.setMonth(monthStr);
        return balanceReconciliation;
    }

    public static LocalDate checkMonth(String month) {
        if (StringUtils.isEmpty((String)month)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u53cd\u9988\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReconciliationCommonUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        try {
            return MonthUtil.parserMonth(month);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u53cd\u9988\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ReconciliationCommonUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }
}

