/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit.openCredit.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.credit.openCredit.atomic.IOpenCredit;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditRequestBody;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditRequestDetail;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditResponse;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditResponseBody;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditResponseDetail;
import kd.ebg.aqap.common.entity.biz.credit.queryOpenCredit.QueryOpenCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.queryOpenCredit.QueryOpenCreditResponse;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.OpenCreditService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.codeless.CodeLessRoute;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OpenCreditConvert {
    public static List<OpenCreditDetail> convertPay(OpenCreditRequest request) {
        OpenCreditRequestBody body = request.getBody();
        String bizType = request.getHeader().getBizType();
        String subBizType = request.getHeader().getSubBizType();
        int totalCount = body.getTotalCount();
        String batchSeqID = body.getBatchSeqId();
        List requestDetails = body.getDetails();
        EBContext context = EBContext.getContext();
        BankAcnt acnt = EBContext.getContext().getBankAcnt();
        long requestTimeStamp = request.getHeader().getRequestTime();
        LocalDateTime requestTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(requestTimeStamp), ZoneId.systemDefault());
        Preconditions.checkArgument((totalCount == requestDetails.size() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u4ed8\u6b3e\u5355\u603b\u6570(%1$s)\u548c\u8be5\u6279\u6b21\u6307\u793a\u7684\u603b\u7b14\u6570(%2$s)\u4e0d\u7b26", (String)"OpenCreditConvert_15", (String)"ebg-aqap-business", (Object[])new Object[0]), requestDetails.size(), totalCount));
        ArrayList<OpenCreditDetail> openCreditDetails = new ArrayList<OpenCreditDetail>(requestDetails.size());
        int bankSerialNo = 1;
        for (OpenCreditRequestDetail detail : requestDetails) {
            CheckUtil.checkLength("FAPPLICANTCREDITNUM", detail.getApplicantCreditNum(), 50);
            CheckUtil.checkLength("FDUEADDRESS", detail.getDueAddress(), 200);
            CheckUtil.checkLength("FAPPLICANTADDRESSEN", detail.getApplicantAddressEN(), 250);
            CheckUtil.checkLength("FCOUNTERADDRESS", detail.getCounterAddress(), 200);
            CheckUtil.checkLength("FADVIADDRESS", detail.getAdviAddress(), 140);
            CheckUtil.checkLength("FFORWARDADDRESS", detail.getForwardAddress(), 200);
            CheckUtil.checkLength("FAVWTBANKNMADD", detail.getAvWtBankNmAdd(), 200);
            CheckUtil.checkLength("FACCEPTORADDRESS", detail.getAcceptorAddress(), 200);
            CheckUtil.checkLength("FEXPLAIN", detail.getExplain(), 250);
            CheckUtil.checkLength("FDRAWEEADDRESS", detail.getDraweeAddress(), 200);
            CheckUtil.checkLength("FDELIVERYPORT", detail.getDeliveryPort(), 250);
            CheckUtil.checkLength("FSTARTAIR", detail.getStartAir(), 250);
            CheckUtil.checkLength("FTERMINIAIR", detail.getTerminiAir(), 250);
            CheckUtil.checkLength("FTERMINI", detail.getTermini(), 250);
            CheckUtil.checkLength("FGASDESCRIPTION", detail.getGasDescription(), 250);
            CheckUtil.checkLength("FREMARK", detail.getRemark(), 250);
            CheckUtil.checkLength("FDETAILBIZNO", detail.getDetailBizNo(), 30);
            Preconditions.checkState((!OpenCreditService.getInstance().detailBizExist(detail.getDetailBizNo()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"detailbizno \u5df2\u7ecf\u5b58\u5728\u3002", (String)"OpenCreditConvert_16", (String)"ebg-aqap-business", (Object[])new Object[0]));
            OpenCreditDetail info = new OpenCreditDetail();
            openCreditDetails.add(info);
            FieldUtils.fieldsCopy((Object)detail, (Object)info);
            info.setRequestTime(requestTime);
            String bankCurrency = CurrencyUtils.convert2Bank((String)detail.getCurrency());
            info.setCurrency(bankCurrency);
            info.setBizType(bizType);
            info.setSubBizType(subBizType);
            info.setBankVersionID(context.getBankVersionID());
            info.setBankLoginID(context.getBankLoginID());
            info.setBatchSeqId(batchSeqID);
            info.setAccno(acnt.getAccNo());
            info.setBankSerialNo(String.valueOf(bankSerialNo++));
            if (StringUtils.isNotEmpty((String)detail.getCharCurrency())) {
                bankCurrency = CurrencyUtils.convert2Bank((String)detail.getCurrency());
                info.setCharCurrency(bankCurrency);
            } else {
                info.setCharCurrency("");
            }
            if (StringUtils.isNotEmpty((String)detail.getMrgnCurrency())) {
                bankCurrency = CurrencyUtils.convert2Bank((String)detail.getMrgnCurrency());
                info.setMrgnCurrency(bankCurrency);
            } else {
                info.setMrgnCurrency("");
            }
            if (StringUtils.isNotEmpty((String)detail.getMixDraftInvAmt())) {
                info.setMixDraftInvAmt(new BigDecimal(detail.getMixDraftInvAmt()));
            } else {
                info.setMixDraftInvAmt(new BigDecimal("0"));
            }
            if (StringUtils.isNotEmpty((String)detail.getAmount())) {
                info.setAmount(new BigDecimal(detail.getAmount()));
            } else {
                info.setAmount(new BigDecimal("0"));
            }
            if (StringUtils.isNotEmpty((String)detail.getContractAmount())) {
                info.setContractAmount(new BigDecimal(detail.getContractAmount()));
            } else {
                info.setContractAmount(new BigDecimal("0"));
            }
            if (StringUtils.isNotEmpty((String)detail.getDraftAmt())) {
                info.setDraftAmt(new BigDecimal(detail.getDraftAmt()));
            } else {
                info.setDraftAmt(new BigDecimal("0"));
            }
            if (StringUtils.isNotEmpty((String)detail.getBusCurrency())) {
                bankCurrency = CurrencyUtils.convert2Bank((String)detail.getBusCurrency());
                info.setBusCurrency(bankCurrency);
            } else {
                info.setBusCurrency("");
            }
            if (StringUtils.isNotEmpty((String)detail.getPayAccCurrency())) {
                bankCurrency = CurrencyUtils.convert2Bank((String)detail.getPayAccCurrency());
                info.setPayAccCurrency(bankCurrency);
            } else {
                info.setPayAccCurrency("");
            }
            if (StringUtils.isNotEmpty((String)detail.getPayAccCurrency2())) {
                bankCurrency = CurrencyUtils.convert2Bank((String)detail.getPayAccCurrency2());
                info.setPayAccCurrency2(bankCurrency);
                continue;
            }
            info.setPayAccCurrency2("");
        }
        return openCreditDetails;
    }

    public static Set<List<OpenCreditDetail>> reloadData(Set<List<OpenCreditDetail>> set) {
        for (List<OpenCreditDetail> infos : set) {
            for (int i = 0; i < infos.size(); ++i) {
                OpenCreditDetail info = infos.get(i);
                info.setBankSerialNo(i + 1 + "");
            }
        }
        return set;
    }

    public static Set<List<OpenCreditDetail>> packagePay(List<OpenCreditDetail> openCreditDetails, CodeLessRoute codeLessRoute) {
        List infos;
        String bankVersionID = openCreditDetails.get(0).getBankVersionID();
        HashSet<List<OpenCreditDetail>> result = new HashSet<List<OpenCreditDetail>>();
        HashMap maps = Maps.newHashMap();
        for (OpenCreditDetail openCreditDetail : openCreditDetails) {
            String implClassName = openCreditDetail.getImplClassName();
            if (maps.containsKey(implClassName)) {
                infos = (List)maps.get(implClassName);
                infos.add(openCreditDetail);
                continue;
            }
            infos = Lists.newArrayList((Object[])new OpenCreditDetail[]{openCreditDetail});
            maps.put(implClassName, infos);
        }
        for (Map.Entry entry : maps.entrySet()) {
            String implClass = (String)entry.getKey();
            infos = (List)entry.getValue();
            int batchSize = 1;
            if (codeLessRoute != null) {
                batchSize = codeLessRoute.getBatchSize();
            } else {
                IOpenCredit pay = (IOpenCredit)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IOpenCredit.class, implClass);
                batchSize = pay.getBatchSize();
            }
            if (batchSize < 1) {
                batchSize = 1;
            }
            if (infos.size() <= batchSize) {
                OpenCreditConvert.addBankSeqID(bankVersionID, infos);
                result.add(infos);
                continue;
            }
            for (int startIndex = 0; startIndex < infos.size(); startIndex += batchSize) {
                int endIndex = startIndex + batchSize;
                if (endIndex > infos.size()) {
                    endIndex = infos.size();
                }
                List<OpenCreditDetail> temp = infos.subList(startIndex, endIndex);
                result.add(temp);
                OpenCreditConvert.addBankSeqID(bankVersionID, temp);
            }
        }
        return result;
    }

    private static void addBankSeqID(String bankVersionID, List<OpenCreditDetail> infos) {
        String bankBatchSeqID = "";
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(bankVersionID);
        if (StringUtils.isEmpty((String)bankBatchSeqID)) {
            bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
            EBContext.getContext().setBizSeqID(bankBatchSeqID);
        }
        for (OpenCreditDetail info : infos) {
            info.setBankBatchSeqId(bankBatchSeqID);
            info.setBankBatchCount(infos.size());
            info.setStatus(Integer.valueOf(PaymentState.PACKAGED.getId()));
            info.setStatusName(PaymentState.PACKAGED.getEnName());
            info.setStatusMsg(PaymentState.PACKAGED.getCnName());
            IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(bankVersionID);
            String bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankDetailSeqId(bankDetailSeqID);
        }
    }

    public static OpenCreditResponse convertToResponse(List<OpenCreditDetail> paymentInfos, OpenCreditRequest payRequest) {
        OpenCreditResponse response = new OpenCreditResponse();
        response.setHeader(payRequest.getHeader());
        OpenCreditResponseBody body = OpenCreditConvert.convert2Body(paymentInfos);
        body.setBatchSeqID(payRequest.getBody().getBatchSeqId());
        body.setBatchBizNo(payRequest.getBody().getBatchBizNo());
        response.setBody(body);
        return response;
    }

    public static QueryOpenCreditResponse convertToQueryResponse(List<OpenCreditDetail> paymentInfos, QueryOpenCreditRequest payRequest) {
        QueryOpenCreditResponse response = new QueryOpenCreditResponse();
        response.setHeader(payRequest.getHeader());
        OpenCreditResponseBody body = OpenCreditConvert.convert2Body(paymentInfos);
        body.setBatchSeqID(payRequest.getBody().getBatchSeqId());
        response.setBody(body);
        return response;
    }

    public static OpenCreditResponseBody convert2Body(List<OpenCreditDetail> openCreditDetails) {
        OpenCreditResponseBody body = new OpenCreditResponseBody();
        ArrayList<OpenCreditResponseDetail> details = new ArrayList<OpenCreditResponseDetail>(openCreditDetails.size());
        for (OpenCreditDetail info : openCreditDetails) {
            OpenCreditResponseDetail detail = new OpenCreditResponseDetail();
            FieldUtils.fieldsCopy((Object)info, (Object)detail);
            details.add(detail);
            detail.setBankMsg(info.getBankMsg());
            detail.setEbSeqID(info.getId() + "");
            detail.setBankMsg(info.bankMsgDetails());
            detail.setEbStatus(EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)info.getStatus())).getName());
            if (StringUtils.isNotEmpty((String)info.getErrorMsg())) {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\uff1a%1$s,\u94f6\u4f01\u5f02\u5e38\uff1a%2$s", (String)"OpenCreditConvert_17", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getStatusMsg(), info.getErrorMsg()));
            } else {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\uff1a%s", (String)"OpenCreditConvert_18", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getStatusMsg()));
            }
            if (StringUtils.isNotEmpty((String)info.getBusCurrency())) {
                String bankCurrency = CurrencyUtils.convert2Iso((String)info.getCurrency());
                detail.setBusCurrency(bankCurrency);
            }
            detail.setEbStatusMsg(info.getStatusMsg());
        }
        body.setDetails(details);
        return body;
    }
}

