/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed.schedule;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.cache.CacheCafStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankCurAndFixedTask;
import kd.ebg.aqap.business.util.ScheduleJobPrepareCheck;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class CurAndFixedScheduleJob
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6 tenantid=" + requestContext.getTenantId());
        this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6 accountid=" + requestContext.getAccountId());
        CurAndFixedService service = CurAndFixedService.getInstance();
        LocalDateTime time = LocalDateTime.now().minus(8L, ChronoUnit.HOURS);
        List curAndFixedInfos = service.findByTimeAndStatus(time, CurAndFixedState.PACKAGED.getId());
        if (!curAndFixedInfos.isEmpty()) {
            Map<String, List<CurAndFixedInfo>> collect = curAndFixedInfos.stream().collect(Collectors.groupingBy(CurAndFixedInfo::getBatchSeqId));
            this.logger.info(String.format("\u83b7\u53d6\u5230\u672a\u63d0\u4ea4\u7684\u5b9a\u6d3b\u4e1a\u52a1\u8bf7\u6c42\uff1a%d\u6761", curAndFixedInfos.size()));
            for (Map.Entry<String, List<CurAndFixedInfo>> item : collect.entrySet()) {
                this.submitCaf(item.getValue());
            }
        }
    }

    private void submitCaf(List<CurAndFixedInfo> curAndFixedInfos) {
        CurAndFixedInfo curAndFixedInfo = curAndFixedInfos.get(0);
        String bankVersion = curAndFixedInfo.getBankVersion();
        String bizType = "currentAndFixed";
        String subBizType = curAndFixedInfo.getSubBizType();
        String customId = curAndFixedInfo.getCustomId();
        String batchSeqId = curAndFixedInfo.getBatchSeqId();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(curAndFixedInfo.getAccNo());
        bankAcnt.setBankLoginId(curAndFixedInfo.getBankLoginId());
        bankAcnt.setBankVersionId(bankVersion);
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        this.logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u63d0\u4ea4\u4ed8\u6b3etraceId\u4e3a" + traceId);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID("").bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bankLoginID(curAndFixedInfo.getBankLoginId()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).loggerBatchNo(batchSeqId).loggerDetailNo(curAndFixedInfo.getBatchSeqId()).loggerBankNo(curAndFixedInfo.getBatchSeqId()).build();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u5b9a\u6d3b\u4e92\u8f6c\u8c03\u5ea6\u2014>{}", (Object)batchSeqId);
        if (!ScheduleJobPrepareCheck.checkAcntEnable(curAndFixedInfo.getAccNo(), curAndFixedInfo.getCustomId())) {
            this.logger.info("\u5b9a\u6d3b\u4e92\u8f6c\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u8d26\u53f7{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u5b9a\u6d3b\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{curAndFixedInfo.getBatchSeqId(), curAndFixedInfo.getAccNo()});
            return;
        }
        if (!ScheduleJobPrepareCheck.checkBankLoginEnable(curAndFixedInfo.getBankLoginId(), curAndFixedInfo.getCustomId())) {
            this.logger.info("\u5b9a\u6d3b\u4e92\u8f6c\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u524d\u7f6e\u673a{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u5b9a\u6d3b\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{curAndFixedInfo.getBatchSeqId(), curAndFixedInfo.getBankLoginId()});
            return;
        }
        BankCurAndFixedRequest request = this.prepareBankCurAndFixedRequest(curAndFixedInfos);
        String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
        if (CacheCafStorage.checkRepeat(batchSeqId)) {
            this.logger.info("\u5f53\u524d\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u6d41\u6c34\u53f7{}", (Object)batchSeqId);
        } else {
            this.logger.info("\u51c6\u5907\u63d0\u4ea4\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1\u8c03\u5ea6\u8bb0\u5f55\u6570{}", (Object)curAndFixedInfos.size());
            this.logger.info(String.format("\u4ed8\u6b3e\u63d0\u4ea4\u5b9a\u6d3b\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customId, bankLoginId));
            EBThreadPools.getCurAndFixedThreadPool(customId, bankLoginId).submit((Callable)((Object)new BankCurAndFixedTask(request, context)));
            this.logger.info("\u8c03\u5ea6\u63d0\u4ea4CAF\u7ebf\u7a0b\u6c60\u6210\u529f");
        }
    }

    private BankCurAndFixedRequest prepareBankCurAndFixedRequest(List<CurAndFixedInfo> curAndFixedInfos) {
        BankCurAndFixedRequest bankCurAndFixedRequest = new BankCurAndFixedRequest();
        if (!curAndFixedInfos.isEmpty()) {
            CurAndFixedInfo curAndFixedInfo = curAndFixedInfos.get(0);
            bankCurAndFixedRequest.setCafInfos(curAndFixedInfos);
            bankCurAndFixedRequest.setBatchSeqId(curAndFixedInfo.getBatchSeqId());
            bankCurAndFixedRequest.setHeader(this.getHeader(curAndFixedInfo));
        }
        return bankCurAndFixedRequest;
    }

    private BankHeader getHeader(CurAndFixedInfo curAndFixedInfo) {
        BankHeader header = new BankHeader();
        String accNo = curAndFixedInfo.getAccNo();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, curAndFixedInfo.getCustomId());
        String bankVersion = curAndFixedInfo.getBankVersion();
        String currency = curAndFixedInfo.getCurrency();
        String subBizType = curAndFixedInfo.getSubBizType();
        header.setBankVersionID(bankVersion);
        header.setBankCurrency(currency);
        header.setSubBizType(subBizType);
        header.setBizType("currentAndFixed");
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setClientName("ebc_bankCurAndFixedTask");
        header.setClientVersion("1.0");
        header.setAcnt(acnt);
        this.logger.info("\u7ec4\u88c5\u5b9a\u6d3b\u94f6\u884c\u8bf7\u6c42\u5934\u5b8c\u6210");
        return header;
    }
}

