/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.storage.DetailSyncService;
import kd.ebg.aqap.business.detail.utils.DetailSyncKit;
import kd.ebg.aqap.business.detail.utils.SyncPeriod;
import kd.ebg.aqap.common.framework.async.IProcess;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class DetailProcess
implements IProcess<BankDetailRequest, EBBankDetailResponse> {
    private static final String EB_DETAIL = "eb_detail_";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailProcess.class);
    private DetailSyncService syncService;
    private static final int PAGE_SIZE = 1000;
    private static final Integer isKeyRepeat = 0;

    public EBBankDetailResponse execute(BankDetailRequest request, EBContext context, Map<String, Object> params) {
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5f00\u59cb\u5904\u7406\u660e\u7ec6\u67e5\u8be2\uff0ccustomID={}", (Object)context.getCustomID());
        this.syncService = (DetailSyncService)SpringContextUtil.getBean(DetailSyncService.class);
        String bankVersionID = context.getBankVersionID();
        String customID = context.getCustomID();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        BankAcnt bankAcnt = EBContext.getContext().getBankAcnt();
        String currency = request.getHeader().getBankCurrency();
        boolean isFromEbgPage = "COSMIC-EBG".equalsIgnoreCase(request.getHeader().getClientName());
        int pageNum = request.getPageNum();
        int pageSize = request.getPageSize();
        if (pageNum <= 0) {
            pageNum = 1;
            request.setPageNum(1);
        }
        if (pageSize <= 0) {
            pageSize = 1000;
            request.setPageSize(1000);
        }
        if (StrUtil.isBlank((CharSequence)currency)) {
            currency = bankAcnt.getCurrency();
            this.logger.info("\u5f02\u6b65\u7ebf\u7a0b,\u672a\u4f20\u5e01\u79cd\uff0c\u8bbe\u7f6e\u4e3a\u8d26\u53f7\u9ed8\u8ba4\u5e01\u79cd\uff1a{}", (Object)currency);
        } else {
            String oldCurr = currency + "";
            currency = CurrencyUtils.convert2Iso((String)currency);
            bankAcnt.setCurrency(currency);
            this.logger.info("\u5f02\u6b65\u7ebf\u7a0b,\u4f20\u4e86\u94f6\u884c\u5e01\u79cd{}\uff0c\u8f6c\u6362\u4e3aiso\u5e01\u79cd\uff1a{}", new Object[]{oldCurr, currency});
        }
        String key = "eb_detailFlag__" + customID + "_" + bankVersionID + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString() + "_" + currency;
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.plusDays(-1L);
        boolean isToday = false;
        if (startDate.isEqual(today) && endDate.isEqual(today)) {
            isToday = true;
        }
        this.logger.info("\u67e5\u8be2\u5e10\u53f7 : {}, \u5e01\u79cd:{} \u4ece {} \u5230 {} \u7684\u660e\u7ec6", new Object[]{bankAcnt.getAccNo(), currency, startDate, endDate});
        try {
            if (isToday) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"0", (int)10, (TimeUnit)TimeUnit.MINUTES);
            } else {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"0", (int)1, (TimeUnit)TimeUnit.DAYS);
            }
            this.logger.info("\u8bbe\u7f6e\u5904\u7406\u6807\u8bb0\u4e3a\u5904\u7406\u4e2d\uff0ckey={}\uff0cvalue={}", new Object[]{key, "0"});
            boolean forceQuery = false;
            Page prePage = null;
            if (isToday && !this.syncService.isHavingPagingDetail(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat, pageNum, pageSize)) {
                prePage = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, isKeyRepeat);
                forceQuery = prePage.getTotalElements() == 0L;
            }
            this.queryFromBank(bankAcnt, startDate, endDate, request, customID, forceQuery);
            if (isToday) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)10, (TimeUnit)TimeUnit.MINUTES);
            } else {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)1, (TimeUnit)TimeUnit.DAYS);
            }
            this.logger.info("\u4ece {} \u5230 {} \u7684\u660e\u7ec6\u5904\u7406\u5b8c\u6210\uff0c\u8bbe\u7f6e\u5904\u7406\u6807\u8bb0\u4e3a\u5df2\u5b8c\u6210\uff0ckey={}\uff0cvalue={}", new Object[]{startDate, endDate, key, "1"});
        }
        catch (Exception e) {
            this.logger.error("\u4ea4\u6613\u660e\u7ec6\u5f02\u6b65\u5904\u7406\u5f02\u5e38", (Throwable)e);
            if (isToday) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"2", (int)10, (TimeUnit)TimeUnit.MINUTES);
            }
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"2", (int)1, (TimeUnit)TimeUnit.DAYS);
        }
        return new EBBankDetailResponse();
    }

    private void queryFromBank(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, BankDetailRequest detailRequest, String customID, boolean forceQuery) {
        block8: {
            boolean isDetailSupportMultiCurrency;
            DetailSyncKit syncKit;
            LocalDate today;
            block7: {
                today = LocalDate.now();
                String date = today.format(DateTimeFormatter.BASIC_ISO_DATE);
                syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
                if (forceQuery) {
                    EBContext.getContext().setForceQueryDetail(true);
                    this.logger.info("\u5f3a\u5236\u67e5\u8be2\uff0c\u8df3\u8fc73\u5206\u949f\u9650\u5236");
                }
                isDetailSupportMultiCurrency = BankBundleManager.getInstance().getBankVersionInfo(bankAcnt.getBankVersionId()).isDetailSupportMultiCurrency();
                if (!today.isEqual(startDate) || !syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, bankAcnt.getCurrency(), customID)) break block7;
                int minute = BusinessPropertyConfig.getTodayDetailLimitTime();
                if (!forceQuery && !this.syncService.isExpire(bankAcnt.getAccNo(), date, customID, minute)) break block8;
                this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest));
                this.syncService.recordTodayDetailTimestamp(bankAcnt.getAccNo(), date, customID);
                break block8;
            }
            if (today.isEqual(endDate)) {
                LocalDate yesterday = today.plusDays(-1L);
                if (syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, bankAcnt.getCurrency(), customID)) {
                    this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest));
                } else {
                    this.logger.info("\u5e10\u53f7 : {} \u8fd13\u5206\u949f\u5185\u67e5\u8be2\u8fc7\u4eca\u65e5\u660e\u7ec6\uff0c\u4e0d\u5728\u67e5\u8be2", (Object)bankAcnt.getAccNo());
                }
                List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, yesterday, isDetailSupportMultiCurrency, bankAcnt.getCurrency(), customID);
                for (SyncPeriod period : syncPeriods) {
                    this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest));
                }
            } else {
                List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, endDate, isDetailSupportMultiCurrency, bankAcnt.getCurrency(), customID);
                for (SyncPeriod period : syncPeriods) {
                    this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest));
                }
            }
        }
    }

    private BankDetailRequest buildRequest(BankAcnt acnt, LocalDate startDate, LocalDate endDate, BankDetailRequest detailRequest) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomerID());
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency());
        header.setBankCurrency(bankCurrency);
        request.setPageSize(detailRequest.getPageSize());
        request.setPageNum(1);
        request.setBankCurrency(bankCurrency);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setExtData(detailRequest.getExtData());
        request.setSerialNo(detailRequest.getSerialNo());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToday(BankAcnt bankAcnt, LocalDate today, BankDetailRequest request) {
        String key = EB_DETAIL + request.getHeader().getCustomerID() + "_" + bankAcnt.getAccNo() + "_" + today.toString() + "_" + bankAcnt.getCurrency() + "_" + isKeyRepeat;
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)30, (TimeUnit)TimeUnit.SECONDS);
        if (kd.bos.util.StringUtils.isNotEmpty((String)result)) {
            this.logger.error("\u5f53\u524d\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2");
            return;
        }
        this.logger.info("\u67e5\u8be2\u4eca\u65e5\u7684\u660e\u7ec6\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} ", new Object[]{today.toString(), today.toString()});
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"todayDetail");
        IDetail detail = (IDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IDetail.class, (Object)request);
        BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IDetail.class, (Object)request);
        EBBankDetailResponse response = null;
        FEPAccess access = null;
        long takeUpTime = 0L;
        try {
            long startTime = System.currentTimeMillis();
            access = FEPAccessUtil.access((String)EBContext.getContext().getBankVersionID(), (String)EBContext.getContext().getBankLoginID());
            response = detail.detail(request);
            takeUpTime = System.currentTimeMillis() - startTime;
        }
        catch (Throwable throwable) {
            FEPAccessUtil.release(access);
            throw throwable;
        }
        FEPAccessUtil.release((FEPAccess)access);
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        String customID = EBContext.getContext().getCustomID();
        syncKit.insert_sync_detail(bankAcnt.getAccNo(), customID, today, today, takeUpTime);
        List<Object> detailInfoList = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().compareTo(LocalDate.now()) == 0).collect(Collectors.toList());
        response.setDetails(detailInfoList);
        this.dealResponse(bankAcnt, response, today, today);
        this.syncService.removePagingTotalNum(bankAcnt.getAccNo(), today.toString(), bankAcnt.getCurrency(), isKeyRepeat);
        if (isKeyRepeat != null) {
            detailInfoList = detailInfoList.stream().filter(d -> isKeyRepeat.equals(d.getIsKeyRepeat())).collect(Collectors.toList());
            this.logger.info("\u5f53\u65e5\u660e\u7ec6\uff0c\u7f13\u5b58\u4e2d\u8fc7\u6ee4\u6389isKeyRepeat!={}\u7684\u503c\uff0c\u5269\u4e0b\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e3a{}", new Object[]{isKeyRepeat, detailInfoList.size()});
        }
        detailInfoList = detailInfoList.stream().filter(detailInfo -> request.getHeader().getBankCurrency().equalsIgnoreCase(detailInfo.getCurrency())).collect(Collectors.toList());
        this.syncService.savePagingDetail(detailInfoList, bankAcnt.getAccNo(), today.toString(), bankAcnt.getCurrency(), request.getPageSize(), isKeyRepeat);
        this.syncService.savePagingTotalNum(bankAcnt.getAccNo(), today.toString(), bankAcnt.getCurrency(), detailInfoList.size(), isKeyRepeat);
        CosmicCache.delete((String)key);
    }

    private void syncHistory(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, BankDetailRequest request) {
        EBBankDetailResponse response;
        String key = EB_DETAIL + request.getHeader().getCustomerID() + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString() + "_" + bankAcnt.getCurrency() + "_" + isKeyRepeat;
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)30, (TimeUnit)TimeUnit.SECONDS);
        if (kd.bos.util.StringUtils.isNotEmpty((String)result)) {
            this.logger.error("\u5f53\u524d\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2");
            return;
        }
        this.logger.info("\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u7684\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} ", new Object[]{startDate.toString(), endDate.toString()});
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"hisDetail");
        IHisDetail detail = (IHisDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IHisDetail.class, (Object)request);
        FEPAccess access = null;
        long takeUpTime = 0L;
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        String customID = EBContext.getContext().getCustomID();
        try {
            long startTime = System.currentTimeMillis();
            access = FEPAccessUtil.access((String)EBContext.getContext().getBankVersionID(), (String)EBContext.getContext().getBankLoginID());
            response = detail.hisDetail(request);
            takeUpTime = System.currentTimeMillis() - startTime;
        }
        catch (Exception ex) {
            try {
                syncKit.insertSyncDetailRecord(null, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, bankAcnt.getCurrency(), false);
                throw EBExceiptionUtil.serviceException((Throwable)ex);
            }
            catch (Throwable throwable) {
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        syncKit.insert_sync_detail(bankAcnt.getAccNo(), customID, startDate, endDate, takeUpTime);
        List<DetailInfo> detailInfos = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().isBefore(endDate.plusDays(1L)) && detailInfo.getTransDate().isAfter(startDate.minusDays(1L))).collect(Collectors.toList());
        response.setDetails(detailInfos);
        try {
            this.dealResponse(bankAcnt, response, startDate, endDate);
            syncKit.insertSyncDetailRecord(detailInfos, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, bankAcnt.getCurrency(), true);
        }
        catch (Exception ex) {
            this.logger.info("\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38");
            syncKit.insertSyncDetailRecord(null, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, bankAcnt.getCurrency(), false);
            throw EBExceiptionUtil.serviceException((Throwable)ex);
        }
        CosmicCache.delete((String)key);
    }

    private void dealResponse(BankAcnt bankAcnt, EBBankDetailResponse response, LocalDate startDate, LocalDate endDate) {
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        List<DetailInfo> detailInfos = response.getDetails();
        this.logger.info("\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", (Object)detailInfos.size());
        String accType = BankAcntPropertyConfig.getAccType((String)bankAcnt.getAccNo());
        for (DetailInfo detail : detailInfos) {
            String currency;
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getDebitAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u501f\u6b3e\u91d1\u989d(DebitAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u6536\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6", (String)"DetailProcess_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCreditAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u8d37\u6b3e\u91d1\u989d(CreditAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u4ed8\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6", (String)"DetailProcess_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a", (String)"DetailProcess_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getTransTime()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u4ea4\u6613\u65f6\u95f4(TransTime)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailProcess_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setBankLoginID(bankAcnt.getBankLoginId());
            detail.setBankVersionID(bankAcnt.getBankVersionId());
            String bankCurrency = detail.getCurrency();
            if (!currencyMap.containsKey(bankCurrency)) {
                currencyMap.put(bankCurrency, CurrencyUtils.convert2Iso((String)bankCurrency));
            }
            if (!StringUtils.isEmpty((String)(currency = (String)currencyMap.get(bankCurrency)))) {
                detail.setCurrency(currency);
            }
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u5e01\u79cd\u8f6c\u6362\u9519\u8bef\uff0c\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailProcess_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setCustomID(EBContext.getContext().getCustomID());
            detail.setAccType(accType);
            LocalDateTime transTime = detail.getTransTime();
            if (Objects.isNull(transTime)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailProcess_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            LocalDate transDate = detail.getTransDate();
            if (Objects.isNull(transDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u8bb0\u8d26\u65e5\u671f\uff08transDate\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailProcess_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)detail.getAccNo())) {
                detail.setAccNo(bankAcnt.getAccNo());
            }
            if (StringUtils.isEmpty((String)detail.getAccName())) {
                detail.setAccName(bankAcnt.getAccName());
            }
            if (StringUtils.isEmpty((String)detail.getBankName())) {
                detail.setBankName(bankAcnt.getBankName());
            }
            detail.setCreditAmount(detail.getCreditAmount().setScale(2, 4));
            detail.setDebitAmount(detail.getDebitAmount().setScale(2, 4));
        }
        DetailInfoService.getInstance().insertOrUpdate(detailInfos, bankAcnt, EBContext.getContext().getCustomID(), startDate, endDate);
    }

    public boolean match(BankDetailRequest request) {
        return true;
    }
}

