/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.entity.biz.detail.Detail;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequest;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequestBody;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailConvert {
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static BankDetailRequest convert(DetailRequest detailRequest) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        DetailRequestBody body = detailRequest.getBody();
        String startDateStr = body.getStartDate();
        String endDateStr = body.getEndDate();
        int pageNum = body.getPageNum();
        String extData = body.getExtData();
        EBHeader ebHeader = detailRequest.getHeader();
        String accNo = ebHeader.getAccNo();
        LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setPageNum(pageNum);
        BankAcnt bankAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        header.setBizType(ebHeader.getBizType());
        header.setSubBizType(ebHeader.getSubBizType());
        header.setBankVersionID(bankAcnt.getBankVersionId());
        header.setBankLoginID(bankAcnt.getBankLoginId());
        header.setAcnt(bankAcnt);
        String bankCurrency = CurrencyUtils.convert2Bank((String)bankAcnt.getCurrency());
        header.setBankCurrency(bankCurrency);
        header.setExtData(ebHeader.getExtData());
        request.setBankCurrency(bankCurrency);
        request.setExtData(extData);
        return request;
    }

    public static Detail convert(DetailInfo info) {
        Map extDataMap;
        Map detailExtMap;
        String extData;
        Detail detail = new Detail();
        FieldUtils.fieldsCopy((Object)info, (Object)detail);
        MappingAcctService service = MappingAcctService.getInstance();
        String s = CurrencyUtils.convert2Iso((String)info.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        if (StringUtils.isEmpty((String)s)) {
            s = info.getCurrency();
        }
        String extraAcc = service.mapping(detail.getAccNo(), s);
        detail.setExtraAccNo(extraAcc);
        if (Objects.nonNull(info.getTransTime())) {
            detail.setDetailDateTime(info.getTransTime().format(dateTimeFormatter));
        }
        if (Objects.nonNull(info.getInsertTime())) {
            detail.setInsertTime(info.getInsertTime().format(dateTimeFormatter2));
        }
        if (Objects.nonNull(info.getUpdateTime())) {
            detail.setUpdateTime(info.getUpdateTime().format(dateTimeFormatter2));
        }
        if (!StringUtils.isEmpty((String)info.getReversed1())) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("associatedAccount", info.getReversed1());
            detail.setExtData(JsonUtil.toJsonLine(map));
        }
        if (!StringUtils.isEmpty((String)info.getReversedBizField())) {
            extData = detail.getExtData();
            if (StringUtils.isNotEmpty((String)extData)) {
                detailExtMap = (Map)JsonUtil.fromJson((String)info.getReversedBizField(), Map.class);
                extDataMap = (Map)JsonUtil.fromJson((String)extData, Map.class);
                extDataMap.putAll(detailExtMap);
                extData = JsonUtil.toJson((Object)extDataMap);
                detail.setExtData(extData);
            } else {
                detail.setExtData(info.getReversedBizField());
            }
        }
        if (!StringUtils.isEmpty((String)info.getReversed4())) {
            extData = detail.getExtData();
            if (StringUtils.isNotEmpty((String)extData)) {
                detailExtMap = (Map)JsonUtil.fromJson((String)info.getReversed4(), Map.class);
                extDataMap = (Map)JsonUtil.fromJson((String)extData, Map.class);
                extDataMap.putAll(detailExtMap);
                extData = JsonUtil.toJson((Object)extDataMap);
                detail.setExtData(extData);
            } else {
                detail.setExtData(info.getReversed4());
            }
        }
        detail.setKDRetFlag(info.getPayBankDetailSeqID());
        if (StringUtils.isEmpty((String)detail.getTransferCharge())) {
            detail.setTransferCharge("0");
        }
        detail.setBizRefNo(StringUtils.trim((String)detail.getBizRefNo()));
        detail.setExplanation(StringUtils.trim((String)detail.getExplanation()));
        return detail;
    }
}

