/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing.schedule;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankFinancingTask;
import kd.ebg.aqap.business.util.ScheduleJobPrepareCheck;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.EBGNodeService;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class FinancingScheduleJob
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(FinancingScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        FinancingService service = FinancingService.getInstance();
        this.logger.info("\u7406\u8d22\u8c03\u5ea6\u2014>\u4fee\u6539\u5931\u6548\u8282\u70b9\u7684\u7406\u8d22\u63d0\u4ea4\u4e2d\u4e3a\u672a\u786e\u8ba4");
        List nonExistences = ((EBGNodeService)SpringContextUtil.getBean(EBGNodeService.class)).getInValidNodes();
        service.updateInvalidNodesFromSubmittingToUnknown(nonExistences);
        this.logger.info("\u7406\u8d22\u8c03\u5ea6\u2014>\u67e5\u8be28\u5c0f\u65f6\u5185\u5df2\u6253\u5305\u72b6\u6001\u7684\u7406\u8d22\u4fe1\u606f\uff0c\u53d1\u8d77\u7406\u8d22\u8bf7\u6c42");
        LocalDateTime updateTime = LocalDateTime.now().minus(8L, ChronoUnit.HOURS);
        List financingInfos = service.selectByCreateTimeBeforeAndStatus(updateTime, FinancingState.PACKAGED.getId());
        if (!financingInfos.isEmpty()) {
            this.logger.info(String.format("\u83b7\u53d6\u5230\u672a\u63d0\u4ea4\u7684\u7406\u8d22\u4e1a\u52a1\u8bf7\u6c42\uff1a%d\u6761", financingInfos.size()));
            this.submit(financingInfos);
        } else {
            this.logger.info("\u7406\u8d22\u8c03\u5ea6\u2014>\u67e5\u8be2\u975e\u672c\u8282\u70b9\u7684\uff0c\u4f46\u662f\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4\u8d85\u8fc730\u5206\u949f\u7684\u7406\u8d22");
            updateTime = LocalDateTime.now().minus(30L, ChronoUnit.MINUTES);
            financingInfos = service.findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIdNot(PaymentState.PACKAGED.getId(), updateTime);
            if (!financingInfos.isEmpty()) {
                this.logger.info(String.format("\u83b7\u53d6\u5230\u5176\u4ed6\u8282\u70b9\u672a\u63d0\u4ea4\u7684\u7406\u8d22:%d\u6761", financingInfos.size()));
                this.process(financingInfos, true);
            }
        }
    }

    private void process(List<FinancingInfo> infos, boolean isModifyOwnToMe) {
        block6: {
            FinancingService financingInfoService = FinancingService.getInstance();
            if (infos.isEmpty()) break block6;
            this.logger.info("\u7406\u8d22\u8c03\u5ea6\u5904\u7406->\u6309\u7167\u7406\u8d22\u6279\u6b21\u53f7\u5206\u7ec4");
            Map<String, List<FinancingInfo>> collect = infos.stream().collect(Collectors.groupingBy(FinancingInfo::getBankBatchSeqId));
            if (isModifyOwnToMe) {
                for (Map.Entry<String, List<FinancingInfo>> next : collect.entrySet()) {
                    String bankBatchSeqId = next.getKey();
                    List<FinancingInfo> infoList = next.getValue();
                    try {
                        this.logger.info("\u5c1d\u8bd5\u4fee\u6539\u5176\u4ed6\u8282\u70b9\u7684\u7406\u8d22\u6240\u6709\u8005\u4e3a\u672c\u8282\u70b9. bankBatchSeqId:{}", (Object)bankBatchSeqId);
                        List save = financingInfoService.modifyOwnToMe(infoList);
                        if (save.isEmpty()) continue;
                        this.submit(save);
                    }
                    catch (Exception e) {
                        this.logger.info("\u5c1d\u8bd5\u5904\u7406\u5176\u4ed6\u8282\u70b9\u7684\u7406\u8d22\u5931\u8d25, bankBatchSeqId:{}", (Object)bankBatchSeqId);
                    }
                }
            } else {
                for (Map.Entry<String, List<FinancingInfo>> entry : collect.entrySet()) {
                    this.logger.info(String.format("\u7406\u8d22\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff0c\u6279\u6b21\u53f7\u4e3a%s", entry.getKey()));
                    this.submit(entry.getValue());
                }
            }
        }
    }

    private void submit(List<FinancingInfo> financingInfos) {
        FinancingInfo financingInfo = financingInfos.get(0);
        String bankVersion = financingInfo.getBankVersionID();
        String bizType = "B".equalsIgnoreCase(financingInfo.getFinancingType()) ? "buyFinancing" : "redeemFinancing";
        String customId = financingInfo.getCustomId();
        String batchSeqId = financingInfo.getBatchSeqId();
        String accNo = financingInfo.getAccNo();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(financingInfo.getAccNo());
        bankAcnt.setBankLoginId(financingInfo.getBankLoginID());
        bankAcnt.setBankVersionId(bankVersion);
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        this.logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u63d0\u4ea4\u7406\u8d22traceId\u4e3a" + traceId);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID("").bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bankLoginID(financingInfo.getBankLoginID()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).loggerBatchNo(batchSeqId).loggerDetailNo(financingInfos.get(0).getBankBatchSeqId()).loggerBankNo(financingInfos.get(0).getBankBatchSeqId()).build();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u7406\u8d22\u8c03\u5ea6\u2014>{}", (Object)batchSeqId);
        if (!ScheduleJobPrepareCheck.checkAcntEnable(accNo, customId)) {
            this.logger.info("\u7406\u8d22\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u8d26\u53f7{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u7406\u8d22\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{financingInfo.getBankBatchSeqId(), accNo});
            return;
        }
        if (!ScheduleJobPrepareCheck.checkBankLoginEnable(financingInfo.getBankLoginID(), customId)) {
            this.logger.info("\u7406\u8d22\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u524d\u7f6e\u673a{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u7406\u8d22\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{financingInfo.getBankBatchSeqId(), financingInfo.getBankLoginID()});
            return;
        }
        BankFinancingRequest request = this.prepareBankFinancingRequest(financingInfos, bizType);
        String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
        this.logger.info("\u51c6\u5907\u63d0\u4ea4\u7406\u8d22\u8c03\u5ea6\u8bb0\u5f55\u6570{}", (Object)financingInfos.size());
        this.logger.info(String.format("\u7406\u8d22\u63d0\u4ea4\u7406\u8d22\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customId, bankLoginId));
        EBThreadPools.getFinancingThreadPool(customId, bankLoginId).submit((Callable)((Object)new BankFinancingTask(request, context)));
        this.logger.info("\u63d0\u4ea4\u7406\u8d22\u7ebf\u7a0b\u6c60\u6210\u529f");
    }

    private BankFinancingRequest prepareBankFinancingRequest(List<FinancingInfo> financingInfos, String bizType) {
        BankFinancingRequest bankFinancingRequest = new BankFinancingRequest();
        if (!financingInfos.isEmpty()) {
            FinancingInfo financingInfo = financingInfos.get(0);
            bankFinancingRequest.setInfos(financingInfos);
            bankFinancingRequest.setBatchSeqId(financingInfo.getBatchSeqId());
            bankFinancingRequest.setHeader(this.getHeader(financingInfo, bizType));
        }
        return bankFinancingRequest;
    }

    private BankHeader getHeader(FinancingInfo financingInfo, String bizType) {
        BankHeader header = new BankHeader();
        String accNo = financingInfo.getAccNo();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, financingInfo.getCustomId());
        String bankVersion = financingInfo.getBankVersionID();
        String currency = financingInfo.getCurrency();
        header.setBankVersionID(bankVersion);
        header.setBankCurrency(currency);
        header.setSubBizType(bizType);
        header.setBizType(bizType);
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setClientName("ebc_bankFinancingTask");
        header.setClientVersion("1.0");
        header.setAcnt(acnt);
        this.logger.info("\u7ec4\u88c5\u7406\u8d22\u94f6\u884c\u8bf7\u6c42\u5934\u5b8c\u6210");
        return header;
    }
}

