/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.login;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.IFetchToken;
import kd.ebg.egf.common.framework.biz.IToken;
import kd.ebg.egf.common.log.EBGLogger;

public class GetTokenImpl
implements IFetchToken {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetTokenImpl.class);
    private static Map<String, IToken> loginCacheMap = Maps.newHashMapWithExpectedSize((int)1);

    private IToken getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized IToken getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!loginCacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(IToken.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    IToken instance = (IToken)c.newInstance();
                    loginCacheMap.put(instance.getBankVersion(), instance);
                }
                catch (Throwable e) {
                    logger.error("GetTokenImpl-getImplFromCache-error:" + e.getMessage(), e);
                }
            }
        }
        IToken iToken = loginCacheMap.get(bankVersionID);
        return iToken;
    }

    public String getToken() {
        IToken iToken = this.getImplFromCache();
        return iToken.getToken();
    }

    public void clearToken() {
        IToken iToken = this.getImplFromCache();
        iToken.clearToken();
    }
}

