/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.entity.biz.bankloginconfig.BankLoginConfigRequest;
import kd.ebg.aqap.common.entity.biz.bankloginconfig.BankLoginConfigResponse;
import kd.ebg.aqap.common.entity.biz.bankloginconfig.BankLoginConfigResponseBody;
import kd.ebg.aqap.common.entity.biz.bankloginconfig.BankLoginConfigVo;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankLoginConfigMethod
implements EBServiceMethod<BankLoginConfigRequest, BankLoginConfigResponse> {
    public BankLoginConfigResponse executeClientRequest(BankLoginConfigRequest request, EBContext context) {
        String bankVersionID = request.getBody().getBankVersionID();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankVersionID), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u94f6\u884c\u7248\u672c\u3002", (String)"BankLoginConfigMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        BankLoginConfigResponse response = new BankLoginConfigResponse();
        BankLoginConfigResponseBody responseBody = new BankLoginConfigResponseBody();
        response.setBody(responseBody);
        List bankLoginConfigs = BankBundleManager.getInstance().getBankLoginConfig(bankVersionID);
        ArrayList bankLoginConfigVos = new ArrayList(1);
        if (CollectionUtil.isNotEmpty((Collection)bankLoginConfigs)) {
            bankLoginConfigs.stream().filter(b -> StringUtils.isEmpty((String)b.getBankConfigValue())).forEach(b -> {
                BankLoginConfigVo bankLoginConfigVo = new BankLoginConfigVo();
                FieldUtils.fieldsCopy((Object)b, (Object)bankLoginConfigVo);
                bankLoginConfigVo.setMustInput(b.getNullable() == false);
                bankLoginConfigVo.setBankConfigID(b.getKey().getBankConfigId());
                bankLoginConfigVos.add(bankLoginConfigVo);
            });
        }
        responseBody.setConfigs(bankLoginConfigVos);
        responseBody.setBankVersionID(bankVersionID);
        responseBody.setBankVersionName(BankBundleManager.getInstance().getBankVersionName(bankVersionID));
        return response;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "bankLoginConfig";
    }
}

