/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.other.info.BankLoginInfo;
import kd.ebg.aqap.business.other.info.PropertyConfigInfo;
import kd.ebg.aqap.business.other.info.PropertyConfigItemInfo;
import kd.ebg.aqap.business.other.service.InfoService;
import kd.ebg.aqap.common.entity.biz.param.EbgParam;
import kd.ebg.aqap.common.entity.biz.param.ParamRequest;
import kd.ebg.aqap.common.entity.biz.param.ParamResponse;
import kd.ebg.aqap.common.entity.biz.param.ParamResponseBody;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class EbgParamMethod
implements EBServiceMethod<ParamRequest, ParamResponse> {
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);

    public ParamResponse executeClientRequest(ParamRequest request, EBContext ebContext) {
        String bankVersion = request.getBody().getBankVersionName();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankVersion), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        ParamResponse response = new ParamResponse();
        ParamResponseBody body = new ParamResponseBody();
        ArrayList<EbgParam> acntParms = new ArrayList<EbgParam>(16);
        ArrayList<EbgParam> loginParms = new ArrayList<EbgParam>(16);
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(bankVersion);
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(bankVersion);
        for (PropertyConfigItemInfo item : propertyConfigItemInfos) {
            EbgParam acnt = new EbgParam(item.getKey(), item.getName());
            acntParms.add(acnt);
        }
        for (BankLoginInfo info : bankLoginInfos) {
            EbgParam login = new EbgParam(info.getBankConfigId(), info.getBankConfigName());
            loginParms.add(login);
        }
        body.setAcntConfigs(acntParms);
        body.setLoginConfigs(loginParms);
        response.setBody(body);
        return response;
    }

    List<BankLoginInfo> getBankLoginInfoList(String bankVersion) {
        List<BankLoginInfo> bankLoginInfos = this.infoService.getBankLoginInfoList(bankVersion);
        if (CollectionUtil.isEmpty(bankLoginInfos)) {
            return null;
        }
        return bankLoginInfos.stream().filter(c -> !"receipt".equalsIgnoreCase(MetaDataConfigType.getTypeByName((String)c.getType()))).collect(Collectors.toList());
    }

    public List<PropertyConfigItemInfo> getPropertyConfigItemInfoList(String bankVersion) {
        PropertyConfigInfo propertyConfigInfo = this.getBankAcntConfig(bankVersion);
        if (propertyConfigInfo != null) {
            return propertyConfigInfo.getConfigItems();
        }
        return null;
    }

    public PropertyConfigInfo getBankAcntConfig(String bankVersion) {
        return this.infoService.getBankAcntConfig(bankVersion);
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "ebgParam";
    }
}

