/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.business.account.atomic.ISyncAccount;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.syncaccount.Account;
import kd.ebg.aqap.common.entity.biz.syncaccount.SyncAccountBody;
import kd.ebg.aqap.common.entity.biz.syncaccount.SyncAccountRequest;
import kd.ebg.aqap.common.entity.biz.syncaccount.SyncAccountResponse;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.BankAcntOpService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.utils.BankConfigUtils;
import kd.ebg.aqap.common.utils.ReUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.currency.IsoCurrency;
import kd.ebg.egf.common.repository.currency.IsoCurrencyRepository;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SyncAccountMethod
implements EBServiceMethod<SyncAccountRequest, SyncAccountResponse> {
    @Autowired
    private IsoCurrencyRepository isoCurrencyRepository;
    private BankAcntService bankAcntService;
    private static final List<String> EB_CURRENCIES = Lists.newArrayList((Object[])new String[]{"CNY", "USD", "HKD", "JPY", "EUR", "GBP", "CHF", "MOP", "TWD", "CAD", "AUD", "KRW", "NZD", "SGD"});

    public SyncAccountRequest mappingCurrency(SyncAccountRequest request) {
        List list = request.getBody().getAccounts();
        HashMap currencyMap = new HashMap(16);
        list.stream().forEach(item -> {
            String currency = item.getCurrency();
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency, currencyMap);
            item.setCurrency(currency);
        });
        return request;
    }

    public SyncAccountResponse mappingCurrency(SyncAccountResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getAccounts();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public SyncAccountResponse executeClientRequest(SyncAccountRequest request, EBContext context) {
        SyncAccountBody body;
        int operationCode;
        this.isoCurrencyRepository = (IsoCurrencyRepository)SpringContextUtil.getBean(IsoCurrencyRepository.class);
        this.bankAcntService = (BankAcntService)SpringContextUtil.getBean(BankAcntService.class);
        List isoCurrencies = this.isoCurrencyRepository.findAllWithoutCache();
        if (isoCurrencies != null && isoCurrencies.size() > 0) {
            EB_CURRENCIES.clear();
            for (IsoCurrency currency : isoCurrencies) {
                EB_CURRENCIES.add(currency.getIsoCode().toUpperCase(Locale.ENGLISH));
            }
        }
        if ((operationCode = (body = request.getBody()).getOperationCode()) != 1 && operationCode != 2) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7801:%s\u3002", (String)"SyncAccountMethod_26", (String)"ebg-aqap-business", (Object[])new Object[0]), operationCode));
        }
        int totalCount = body.getTotalCount();
        List accounts = body.getAccounts();
        if (Objects.isNull(accounts) || accounts.size() != totalCount) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u4f20\u5e10\u53f7\uff0c\u6216\u8005\u5e10\u53f7\u5217\u8868\u6570\u91cf\u4e0e\u603b\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"SyncAccountMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        HashSet<String> accNos = new HashSet<String>(16);
        for (Account account : accounts) {
            if (StrUtil.isBlank((CharSequence)account.getCustomID())) {
                account.setCustomID(context.getCustomID());
            }
            if (!StringUtils.isEmpty((String)account.getCnaps())) {
                Preconditions.checkArgument((boolean)ReUtil.isMatch((String)"^\\d{1,12}$", (String)account.getCnaps()), (Object)ResManager.loadKDString((String)"\u8054\u884c\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u4e3a\u4e0d\u5927\u4e8e12\u4f4d\u7684\u7eaf\u6570\u5b57\u3002", (String)"SyncAccountMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            Preconditions.checkArgument((boolean)Objects.nonNull(account.getAccNo()), (Object)ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SyncAccountMethod_33", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(account.getAccName()), (Object)String.format(ResManager.loadKDString((String)"\u8d26\u53f7:%s\u7684\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SyncAccountMethod_34", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getAccName()));
            Preconditions.checkArgument((boolean)Objects.nonNull(account.getBankLoginId()), (Object)String.format(ResManager.loadKDString((String)"\u8d26\u53f7:%s\u7684\u524d\u7f6e\u673a\u767b\u5f55id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SyncAccountMethod_35", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getAccNo()));
            Preconditions.checkArgument((boolean)EB_CURRENCIES.contains(account.getCurrency()), (Object)String.format(ResManager.loadKDString((String)"\u5e01\u79cd%s\u4e0d\u5728\u94f6\u4f01\u652f\u6301\u7684\u5e01\u79cd\u5217\u8868\u4e2d\u3002", (String)"SyncAccountMethod_36", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getCurrency()));
            Preconditions.checkArgument((boolean)this.checkLogin(account.getBankLoginId(), account.getCustomID()), (Object)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5230\u94f6\u4f01\u4e91\u7ba1\u7406\u5e73\u53f0\u914d\u7f6e\u3002", (String)"SyncAccountMethod_37", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getBankLoginId()));
            Preconditions.checkArgument((boolean)this.bankAcntService.currencySupported(account.getCurrency(), account.getBankLoginId(), account.getCustomID()), (Object)(String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a%s", (String)"SyncAccountMethod_27", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getBankLoginId()) + String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7248\u672c\u672a\u914d\u7f6e\u8be5\u5e01\u79cd%s\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u5148\u5230\u94f6\u4f01\u4e91\u7ba1\u7406\u5e73\u53f0\u914d\u7f6e\u3002", (String)"SyncAccountMethod_28", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getCurrency())));
            if (StringUtils.isEmpty((String)account.getBankVersionId())) {
                String bankVersionID = account.getBankLoginId().split("-")[0];
                account.setBankVersionId(bankVersionID);
            }
            if (account.getHasEcny() == null) {
                account.setHasEcny(Boolean.valueOf(false));
            }
            if (operationCode == 1) {
                if (account.getHasEcny().booleanValue() && !account.getBankVersionId().endsWith("ECNY")) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u5931\u8d25\uff1a%s\u8fd8\u672a\u652f\u6301\u94b1\u5305\u529f\u80fd\uff0c\u65e0\u6cd5\u542f\u7528\u94b1\u5305\u8d26\u53f7", (String)"SyncAccountMethod_44", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getBankVersionId()));
                }
                if (!account.getHasEcny().booleanValue() && account.getBankVersionId().endsWith("ECNY")) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u662f\u5426\u662f\u94b1\u5305\u8d26\u6237\u53c2\u6570\u5f02\u5e38\uff1a%s", (String)"SyncAccountMethod_43", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getHasEcny()));
                }
                if (account.getHasEcny().booleanValue() && account.getBankVersionId().endsWith("ECNY") && StringUtils.isEmpty((String)account.getAccEcnyLevel())) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u5931\u8d25\uff1a%s\u94b1\u5305\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u542f\u7528\u94b1\u5305\u8d26\u53f7", (String)"SyncAccountMethod_41", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getAccEcnyLevel()));
                }
                if (account.getHasEcny().booleanValue() && account.getBankVersionId().endsWith("ECNY") && StringUtils.isEmpty((String)account.getAccEcnyType())) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u5931\u8d25\uff1a%s\u94b1\u5305\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u542f\u7528\u94b1\u5305\u8d26\u53f7", (String)"SyncAccountMethod_46", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getAccEcnyType()));
                }
            }
            account.setBankLoginDesc(this.getLoginDesc(account.getCustomID(), account.getBankLoginId()));
            if (StringUtils.isEmpty((String)account.getSwiftCode())) {
                ArrayList skipCheckBankVersions = Lists.newArrayList((Object[])new String[]{"BOCHK_DC", "ALIPAY_CMP", "WECHAT_DC", "ZJWS_OPA"});
                boolean isSkipCheck = skipCheckBankVersions.contains(account.getBankVersionId());
                if (!isSkipCheck) {
                    Preconditions.checkArgument((boolean)CheckUtil.checkNumber(account.getAccNo()), (Object)String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u8bf7\u68c0\u67e5", (String)"SyncAccountMethod_14", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getAccNo()));
                }
                account.setAccName(account.getAccName().trim());
            }
            accNos.add(account.getAccNo());
        }
        TXHandle h = TX.requiresNew();
        try {
            if (operationCode == 1) {
                this.doSaveOrUpdate(accounts);
            } else {
                this.doDelete(accounts);
            }
            SyncAccountResponse response = new SyncAccountResponse();
            SyncAccountBody responseBody = new SyncAccountBody();
            responseBody.setAccounts(this.getAccount(accNos));
            responseBody.setOperationCode(operationCode);
            responseBody.setTotalCount(accNos.size());
            response.setBody(body);
            SyncAccountResponse syncAccountResponse = response;
            return syncAccountResponse;
        }
        catch (Exception e) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u6b65\u8d26\u53f7\u51fa\u73b0\u5f02\u5e38\u3002", (String)"SyncAccountMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private List<Account> getAccount(Set<String> accNos) {
        ArrayList<Account> accounts = new ArrayList<Account>(accNos.size());
        BankAcntService acntService = BankAcntService.getInstance();
        for (String accNo : accNos) {
            BankAcnt bankAcnt = acntService.selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
            if (!Objects.nonNull(bankAcnt)) continue;
            Account account = new Account();
            FieldUtils.fieldsCopy((Object)bankAcnt, (Object)account);
            accounts.add(account);
        }
        return accounts;
    }

    private void doSaveOrUpdate(List<Account> accounts) {
        BankAcntOpService acntService = BankAcntOpService.getInstance();
        BankLoginService loginService = BankLoginService.getInstance();
        for (Account account : accounts) {
            BankLogin login = loginService.getByCustomIdAndLoginId(account.getCustomID(), account.getBankLoginId());
            if (login == null) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u8be2\u5230\u8d26\u53f7%s\u7684\u767b\u5f55\u4fe1\u606f\u3002", (String)"SyncAccountMethod_29", (String)"ebg-aqap-business", (Object[])new Object[0]), account.getAccNo()));
            }
            Preconditions.checkArgument((boolean)"0".equals(login.getConfigType()), (Object)ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u6240\u5c5e\u524d\u7f6e\u673a\u5df2\u88ab[\u67e5\u8be2\u4e0e\u652f\u4ed8-\u524d\u7f6e\u673a\u914d\u7f6e]\u8bbe\u7f6e\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u94f6\u4f01\u63a5\u53e3\u3002", (String)"SyncAccountMethod_16", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)"1".equals(login.getEnable()), (Object)ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u94f6\u4f01\u63a5\u53e3\u3002", (String)"SyncAccountMethod_17", (String)"ebg-aqap-business", (Object[])new Object[0]));
            BankAcnt bankAcnt = new BankAcnt();
            FieldUtils.fieldsCopy((Object)account, (Object)bankAcnt);
            if (account.getHasNote() == null) {
                bankAcnt.setHasNote(Boolean.valueOf(false));
            }
            if (account.getHasEcny() == null) {
                bankAcnt.setHasEcny(Boolean.valueOf(false));
            } else if (account.getHasEcny().booleanValue()) {
                bankAcnt.setAccEcnyLevel(account.getAccEcnyLevel());
                bankAcnt.setAccEcnyType(account.getAccEcnyType());
            }
            bankAcnt.setBranchNo(account.getBranchNo());
            bankAcnt.setBankName(account.getBankName());
            bankAcnt.setCnapname(account.getBankName());
            String city = account.getCity();
            String bankVersionID = account.getBankLoginId().split("-")[0];
            ISyncAccount syncAccount = (ISyncAccount)BankBundleManager.getInstance().getSyncAccountImpl(bankVersionID, ISyncAccount.class);
            if (Objects.nonNull(syncAccount)) {
                Map<String, String> saMap = syncAccount.getAreaCodeAndCnap(city);
                bankAcnt.setAreaCode(saMap.get("AREACODE"));
                bankAcnt.setCnaps(account.getCnaps());
            }
            bankAcnt.setBankVersionId(login.getBankVersionId());
            bankAcnt.setBankName(login.getBankName());
            bankAcnt.setBankShortName(BankBundleManager.getInstance().getBankShortName(login.getBankVersionId()));
            bankAcnt.setBankAddress(account.getProvince() + "," + account.getCity());
            String country = account.getCountry();
            QFilter filter = QFilter.of((String)"number=? or simplespell=? or name=?", (Object[])new Object[]{country, country, country});
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_country", (String)"name", (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                country = dynamicObject.getString("name");
            }
            bankAcnt.setCountry(country);
            if (bankAcnt.getHasReceipt().booleanValue() && !BankConfigUtils.isHasReceipt((String)bankVersionID)) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u5931\u8d25\uff1a%s\u8fd8\u672a\u652f\u6301\u5bf9\u63a5\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u529f\u80fd\uff0c\u65e0\u6cd5\u542f\u7528\u56de\u5355\u8d26\u53f7\u3002", (String)"SyncAccountMethod_25", (String)"ebg-aqap-business", (Object[])new Object[0]), login.getBankName()));
            }
            if (bankAcnt.getHasNote().booleanValue() && !BankConfigUtils.isHasNote((String)bankVersionID)) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u5931\u8d25\uff1a%s\u8fd8\u672a\u652f\u6301\u5bf9\u63a5\u7535\u7968\u529f\u80fd\uff0c\u65e0\u6cd5\u542f\u7528\u7535\u7968\u8d26\u53f7\u3002", (String)"SyncAccountMethod_47", (String)"ebg-aqap-business", (Object[])new Object[0]), login.getBankName()));
            }
            account.setSyncStatus("SUCCESS");
            account.setSyncStatusMsg(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u6210\u529f", (String)"SyncAccountMethod_20", (String)"ebg-aqap-business", (Object[])new Object[0]));
            try {
                acntService.save(bankAcnt, true);
                account.setSyncStatus("SUCCESS");
                account.setSyncStatusMsg(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u6210\u529f", (String)"SyncAccountMethod_20", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                String msg = String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"SyncAccountMethod_30", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage());
                throw EBExceiptionUtil.preCheckException((String)msg, (Throwable)e);
            }
        }
    }

    private void doDelete(List<Account> accounts) {
        BankAcntService acntService = BankAcntService.getInstance();
        for (Account account : accounts) {
            long size = PaymentInfoService.getInstance().countByAccNoAndCustomID(PaymentState.SUBMITTING.getId(), PaymentState.UNKNOWN.getId(), account.getAccNo(), account.getCustomID());
            if (size == 0L) {
                try {
                    acntService.deleteByAccNo(account.getAccNo());
                    account.setSyncStatus("SUCCESS");
                    account.setSyncStatusMsg(ResManager.loadKDString((String)"\u8d26\u53f7\u5220\u9664\u6210\u529f", (String)"SyncAccountMethod_22", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
                catch (Throwable e) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u5220\u9664\u5931\u8d25\uff1a%s\u3002", (String)"SyncAccountMethod_31", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage());
                    throw EBExceiptionUtil.preCheckException((String)msg, (Throwable)e);
                }
            } else {
                String msg = ResManager.loadKDString((String)"\u8d26\u53f7\u5220\u9664\u5931\u8d25\uff1a\u5f53\u524d\u8d26\u53f7\u5b58\u5728\u201c\u4ea4\u6613\u672a\u786e\u8ba4\u201d\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u8bf7\u624b\u5de5\u4fee\u6539\u540e\u518d\u6b21\u5c1d\u8bd5\u5220\u9664\u8d26\u53f7\u64cd\u4f5c\u3002", (String)"SyncAccountMethod_24", (String)"ebg-aqap-business", (Object[])new Object[0]);
                throw EBExceiptionUtil.preCheckException((String)msg);
            }
            account.setBankLoginDesc("");
        }
    }

    private boolean checkLogin(String bankLoginId, String customerNo) {
        BankLogin login = BankLoginService.getInstance().getByCustomIdAndLoginId(customerNo, bankLoginId);
        return login != null;
    }

    private String getLoginDesc(String customId, String loginId) {
        String loginDesc = "";
        BankLoginService bankLoginService = BankLoginService.getInstance();
        BankLogin login = bankLoginService.getByCustomIdAndLoginId(customId, loginId);
        if (login != null) {
            String bankLoginName = login.getBankLoginName() == null ? "" : login.getBankLoginName();
            loginDesc = String.format(ResManager.loadKDString((String)"%1$s-\u767b\u5f55\u7528\u6237-%2$s%3$s\u3002", (String)"SyncAccountMethod_32", (String)"ebg-aqap-business", (Object[])new Object[0]), login.getBankVersionName(), login.getKey().getBankLoginId(), bankLoginName);
        }
        return loginDesc;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "syncAccount";
    }
}

