/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.schedule;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.schedule.PayCheckCache;
import kd.ebg.aqap.business.payment.task.BankQueryPayTask;
import kd.ebg.aqap.business.payment.utils.PaymentAmountUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class QueryPayScheduleJob
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        RequestContext.set((RequestContext)requestContext);
        this.logger.monitorInfo("queryPay Schedule");
        boolean isPaymentAllowed = SystemPropertyConfig.PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            this.logger.monitorInfo("Global param PAYMENT_ALLOW is not open");
            return;
        }
        LocalDateTime updateTime = LocalDateTime.now().minus(5L, ChronoUnit.MINUTES);
        int limitNum = BusinessPropertyConfig.getQueryPayLimitNum();
        List need2QueryPaymentInfos = PaymentInfoService.getInstance().selectByStatusAndOwnIsMe(updateTime, limitNum);
        if (!need2QueryPaymentInfos.isEmpty()) {
            this.logger.monitorInfo("current mservice node exists paymentInfo, number=" + need2QueryPaymentInfos.size());
            this.process(need2QueryPaymentInfos, false);
        } else {
            updateTime = LocalDateTime.now().minus(20L, ChronoUnit.MINUTES);
            need2QueryPaymentInfos = PaymentInfoService.getInstance().selectByStatusAndOwnIsNotMe(updateTime, limitNum);
            this.logger.monitorInfo("other mservice node exists paymentInfo, number=" + need2QueryPaymentInfos.size());
            this.process(need2QueryPaymentInfos, true);
        }
    }

    private void process(List<PaymentInfo> paymentInfos, boolean isModifyOwnToMe) {
        PaymentInfoService paymentInfoService = PaymentInfoService.getInstance();
        if (!paymentInfos.isEmpty()) {
            PayCheckCache payCheckCache = new PayCheckCache();
            Map<String, List<PaymentInfo>> collect = paymentInfos.stream().collect(Collectors.groupingBy(PaymentInfo::getBankBatchSeqID));
            if (isModifyOwnToMe) {
                paymentInfoService.modifyOwnToMe(collect);
                for (Map.Entry<String, List<PaymentInfo>> next : collect.entrySet()) {
                    String bankBatchSeqId = next.getKey();
                    List<PaymentInfo> queryPayList = next.getValue();
                    try {
                        if (queryPayList.isEmpty()) continue;
                        this.submitQueryPay(queryPayList, payCheckCache);
                    }
                    catch (Throwable e) {
                        this.logger.monitorInfo("modifyOwnToMe error, bankBatchSeqId:" + bankBatchSeqId, new Object[]{e});
                    }
                }
            } else {
                for (Map.Entry<String, List<PaymentInfo>> entry : collect.entrySet()) {
                    this.logger.monitorInfo(String.format("submit to pay thread pool\uff0cbatchSeqID = %s", entry.getKey()));
                    try {
                        this.submitQueryPay(entry.getValue(), payCheckCache);
                    }
                    catch (Throwable e) {
                        this.logger.monitorInfo("submit to queryPay thread pool error, batchSeqID = {}", new Object[]{entry.getKey()});
                    }
                }
            }
            payCheckCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitQueryPay(List<PaymentInfo> paymentInfos, PayCheckCache payCheckCache) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String accNo = paymentInfo.getAccNo();
        String bankVersion = paymentInfo.getBankVersionID();
        String customerId = paymentInfo.getCustomID();
        String batchSeqId = paymentInfo.getBatchSeqId();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        bankAcnt.setBankLoginId(paymentInfo.getBankLoginID());
        bankAcnt.setBankVersionId(bankVersion);
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID("").bizName("queryPay").subBizName("").bankVersionID(bankVersion).bankLoginID(paymentInfo.getBankLoginID()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).loggerBatchNo(batchSeqId).loggerDetailNo(paymentInfo.getBankBatchSeqID()).loggerBankNo(Sequence.gen18Sequence()).schedule(true).build();
        context.setBankAcnt(bankAcnt);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u67e5\u8be2\u4ed8\u6b3e\u8c03\u5ea6\u2014>{}", (Object)batchSeqId);
        payCheckCache.clearLogMessage();
        try {
            if (!payCheckCache.isAccountEnable(accNo)) {
                String message = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21%1$s\u7684\u8d26\u53f7%2$s\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u540c\u6b65\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60\u3002", (String)"QueryPayScheduleJob_0", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getBankBatchSeqId(), paymentInfo.getAccNo());
                payCheckCache.setLogMessage(message);
                return;
            }
            if (!payCheckCache.isBankLoginEnable(paymentInfo.getBankLoginID())) {
                String message = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21%1$s\u7684\u524d\u7f6e\u673a%2$s\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u540c\u6b65\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60\u3002", (String)"QueryPayScheduleJob_1", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getBankBatchSeqId(), paymentInfo.getBankLoginID());
                payCheckCache.setLogMessage(message);
                return;
            }
            if (!payCheckCache.isBankPayEnable(bankVersion)) {
                String message = String.format(ResManager.loadKDString((String)"\u94f6\u884c[%s]\u652f\u4ed8\u901a\u9053\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u652f\u4ed8\u3002", (String)"QueryPayScheduleJob_2", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersion);
                payCheckCache.setLogMessage(message);
            } else {
                HashMap<String, String> runningParams = new HashMap<String, String>(16);
                runningParams.put("isUserHandled", String.valueOf(this.isUserHandled()));
                context.setRunningParams(runningParams);
                EBContext.setContext((EBContext)context);
                String message = String.format(ResManager.loadKDString((String)"\u51c6\u5907\u63d0\u4ea4\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u8c03\u5ea6\u8bb0\u5f55\u6570\uff1a%s\u3002", (String)"QueryPayScheduleJob_3", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfos.size());
                payCheckCache.setLogMessage(message);
                BankPayRequest request = this.prepareBankPayRequest(paymentInfos);
                String bankLoginId = paymentInfo.getBankLoginID();
                String bankBatchSeqID = paymentInfo.getBankBatchSeqID();
                if (CachePayStorage.checkSubmitLock(bankBatchSeqID)) {
                    message = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u67e5\u8be2\u4ed8\u6b3e\u4efb\u52a1\u4e0d\u63d0\u4ea4\u7ebf\u7a0b\u6c60\u3002", (String)"QueryPayScheduleJob_4", (String)"ebg-aqap-business", (Object[])new Object[0]), bankBatchSeqID);
                    payCheckCache.setLogMessage(message);
                } else {
                    message = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%1$s,%2$s\uff09\u3002", (String)"QueryPayScheduleJob_5", (String)"ebg-aqap-business", (Object[])new Object[0]), customerId, bankLoginId);
                    payCheckCache.setLogMessage(message);
                    String taskID = EBThreadPools.createScheduleBizTask(context);
                    BankQueryPayTask bankQueryPayTask = new BankQueryPayTask(request, context);
                    bankQueryPayTask.setTaskId(taskID);
                    EBThreadPools.getQueryPayThreadPool(customerId, bankLoginId).submit((Callable)((Object)bankQueryPayTask));
                    message = ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60:\u5b8c\u6210\u3002", (String)"QueryPayScheduleJob_6", (String)"ebg-aqap-business", (Object[])new Object[0]);
                    payCheckCache.setLogMessage(message);
                }
            }
        }
        finally {
            this.logger.info(payCheckCache.getLogMessage());
        }
    }

    private boolean isUserHandled() {
        LocalDateTime now = LocalDateTime.now();
        int minute = now.getMinute();
        return minute >= 1 && minute <= 9;
    }

    private BankPayRequest prepareBankPayRequest(List<PaymentInfo> paymentInfos) {
        BankPayRequest bankPayRequest = new BankPayRequest();
        if (paymentInfos.size() > 0) {
            PaymentInfo info = paymentInfos.get(0);
            bankPayRequest.setPaymentInfos(paymentInfos);
            bankPayRequest.setTotalCount(paymentInfos.size());
            bankPayRequest.setTotalAmount(PaymentAmountUtils.getTotalAmount(paymentInfos));
            bankPayRequest.setBankBatchSeqID(info.getBankBatchSeqID());
            bankPayRequest.setHeader(this.getHeader(info));
        }
        return bankPayRequest;
    }

    private BankHeader getHeader(PaymentInfo info) {
        BankHeader header = new BankHeader();
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        header.setCustomerID(info.getCustomID());
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqID());
        header.setLogBizSeqID(info.getBatchSeqID());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setClientName("ebc_bankQueryPayTask");
        header.setClientVersion("1.0");
        return header;
    }
}

