/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ebg.aqap.business.financing.atomic.IQueryBuyFinancing;
import kd.ebg.aqap.business.financing.atomic.IQueryRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import org.slf4j.MDC;

public class BankQueryFinancingTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankQueryFinancingTask.class);
    private static final int QUERY_FINANCING_INTERVAL_MINUTES = 3;
    private BankFinancingRequest request;
    private EBContext context;

    public BankQueryFinancingTask(BankFinancingRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankFinancingResponse ebBankCurAndFixedResponse = this.submit(this.request, this.context);
        return ebBankCurAndFixedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankFinancingResponse submit(BankFinancingRequest request, EBContext context) {
        boolean isException;
        FEPAccess access;
        List<FinancingInfo> result;
        FinancingService financingService;
        block15: {
            String bankVersion = request.getInfos().get(0).getBankVersionID();
            EBContext.setContext((EBContext)context);
            MDCUtil.clearBussinessMDC();
            MDCUtil.initMDC((EBContext)context);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u67e5\u8be2\u7406\u8d22\u4e1a\u52a1\u5904\u7406,{}", (Object)context.getBizSeqID());
            this.logger.info("\u5f00\u59cb\u67e5\u8be2\u7406\u8d22\u4e1a\u52a1,\u603b\u8bb0\u5f55\u6570\uff1a{}\u6761", (Object)request.getInfos().size());
            List<Object> infos = request.getInfos();
            if (infos.isEmpty()) {
                return null;
            }
            int limitNum = 200;
            if ((infos = infos.stream().filter(info -> info.getSyncCount() == null || info.getSyncCount() < limitNum).collect(Collectors.toList())).isEmpty()) {
                this.logger.info("\u94f6\u884c\u6279\u6b21\u53f7\uff1a{}, \u540c\u6b65\u6b21\u6570\uff1a{}, \u5141\u8bb8\u7684\u6700\u5927\u540c\u6b65\u6b21\u6570\uff1a{}", new Object[]{request.getInfos().get(0).getBankBatchSeqId(), request.getInfos().get(0).getSyncCount(), limitNum});
                return null;
            }
            FinancingState state = FinancingState.getEnumById((int)((FinancingInfo)infos.get(0)).getStatus());
            if (FinancingState.PACKAGED == state || FinancingState.INITIAL == state) {
                this.logger.info("\u5f53\u524d\u7406\u8d22\u4fe1\u606f\u8fd8\u672a\u63d0\u4ea4\u5230\u94f6\u884c\uff0c\u4e0d\u5141\u8bb8\u4ece\u94f6\u884c\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001");
                return null;
            }
            LocalDateTime lastQueryTime = ((FinancingInfo)infos.get(0)).getLastSyncTime();
            if (Objects.nonNull(lastQueryTime) && LocalDateTime.now().plusMinutes(-3L).isBefore(lastQueryTime)) {
                this.logger.info("3\u5206\u949f\u5185\u5df2\u7ecf\u4ece\u94f6\u884c\u540c\u6b65\u8fc7\u4e86,\u672c\u6b21\u4e0d\u518d\u4ece\u94f6\u884c\u67e5\u8be2");
                return null;
            }
            financingService = FinancingService.getInstance();
            result = null;
            access = null;
            isException = false;
            try {
                EBBankFinancingResponse response;
                Object queryFinancing;
                EBContext.initParameter();
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                if ("queryBuyFinancing".equalsIgnoreCase(request.getHeader().getBizType())) {
                    queryFinancing = (IQueryBuyFinancing)BankBundleManager.getInstance().getImpl(bankVersion, IQueryBuyFinancing.class, (Object)request);
                    response = queryFinancing.queryBuyFinancing(request);
                } else {
                    queryFinancing = (IQueryRedeemFinancing)BankBundleManager.getInstance().getImpl(bankVersion, IQueryRedeemFinancing.class, (Object)request);
                    response = queryFinancing.queryRedeemFinancing(request);
                }
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                    FinancingUtil.setState(infos, FinancingState.UNKNOWN, MultiLang.getUnknownStatusTip(), "", "");
                    break block15;
                }
                if (response == null) {
                    throw new IllegalStateException(MultiLang.getReturnNotEmptyTip());
                }
                if (response.getInfos() == null) {
                    throw new IllegalStateException(MultiLang.getReturnDataEmptyTip());
                }
                result = response.getInfos();
            }
            catch (Exception e) {
                try {
                    isException = true;
                    this.logger.error("\u67e5\u8be2\u7406\u8d22\u7ed3\u679c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    throw throwable;
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        LocalDateTime queryTime = LocalDateTime.now();
        if (result != null && !result.isEmpty()) {
            for (FinancingInfo info2 : result) {
                info2.setLastSyncTime(queryTime);
                info2.setUpdateTime(queryTime);
                if (!this.isWorkingTime() || isException) continue;
                info2.addSyncCount();
            }
            financingService.save((List)result);
        }
        EBBankFinancingResponse response = new EBBankFinancingResponse();
        response.setHeader(request.getHeader());
        response.setBatchSeqId(request.getBatchSeqId());
        response.setInfos(request.getInfos());
        return response;
    }

    private boolean isWorkingTime() {
        LocalDateTime now = LocalDateTime.now();
        int hour = now.getHour();
        int week = now.getDayOfWeek().getValue();
        return week >= 1 && week <= 5 && hour >= 6 && hour <= 17;
    }
}

