/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class EBGBusinessUtils {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(EBGBusinessUtils.class);

    public static void setPaymentUpdateTimeAndStatus(List<PaymentInfo> paymentInfos, LocalDateTime updateTime) {
        for (PaymentInfo info : paymentInfos) {
            info.setUpdateTime(updateTime);
            PaymentState state = PaymentState.getEnumById((int)info.getStatus());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
        }
    }

    public static void setPaymentUpdateTimeAndStatus(PaymentInfo paymentInfos, LocalDateTime updateTime) {
        paymentInfos.setUpdateTime(updateTime);
    }

    public static void setPaymentState(PaymentInfo[] paymentInfos, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        for (PaymentInfo info : paymentInfos) {
            EBGBusinessUtils.setPaymentState(info, state, errorMsg, bankStatus, bankMsg);
            EBGBusinessUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(List<PaymentInfo> paymentInfos, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        errorMsg = StringUtils.norm((String)errorMsg);
        for (PaymentInfo info : paymentInfos) {
            EBGBusinessUtils.setPaymentState(info, state, errorMsg, bankStatus, bankMsg);
            EBGBusinessUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentStateWithoutBatchSizeCheck(List<PaymentInfo> paymentInfos, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        for (PaymentInfo info : paymentInfos) {
            EBGBusinessUtils.setPaymentState(info, state, errorMsg, bankStatus, bankMsg);
            EBGBusinessUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentFailState(PaymentInfo[] paymentInfos, String errorMsg, String bankStatus, String bankMsg) {
        for (PaymentInfo info : paymentInfos) {
            errorMsg = StringUtils.norm((String)errorMsg);
            EBGBusinessUtils.setPaymentFailState(info, errorMsg, bankStatus, bankMsg);
            EBGBusinessUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentFailState(List<PaymentInfo> paymentInfos, String errorMsg, String bankStatus, String bankMsg) {
        for (PaymentInfo info : paymentInfos) {
            errorMsg = StringUtils.norm((String)errorMsg);
            EBGBusinessUtils.setPaymentFailState(info, errorMsg, bankStatus, bankMsg);
            EBGBusinessUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentFailState(PaymentInfo paymentInfo, String errorMsg, String bankStatus, String bankMsg) {
        paymentInfo.setBackStatus(paymentInfo.getStatus());
        paymentInfo.setBackStatusMsg(paymentInfo.getStatusMsg());
        paymentInfo.setUpdateOperation(UpdateOpState.SYSTEM.getId());
        PaymentState state = PaymentState.FAIL;
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isBlank((CharSequence)errorMsg)) {
            errorMsg = state.getCnName();
        }
        if ((errorMsg = StringUtils.norm((String)errorMsg)).length() > 250) {
            paymentInfo.setErrorMsg(errorMsg.substring(0, 246) + "...");
        } else {
            paymentInfo.setErrorMsg(errorMsg);
        }
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            paymentInfo.setBankMsg(bankMsg);
        }
    }

    public static void setPaymentState(PaymentInfo paymentInfo, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        paymentInfo.setBackStatus(paymentInfo.getStatus());
        paymentInfo.setBackStatusMsg(paymentInfo.getStatusMsg());
        paymentInfo.setUpdateOperation(UpdateOpState.SYSTEM.getId());
        if (state != null) {
            paymentInfo.setStatus(Integer.valueOf(state.getId()));
            paymentInfo.setStatusName(state.getEnName());
            paymentInfo.setStatusMsg(state.getCnName());
            if (StrUtil.isBlank((CharSequence)errorMsg)) {
                errorMsg = state.getCnName();
            }
            if ((errorMsg = StringUtils.norm((String)errorMsg)).length() > 250) {
                paymentInfo.setErrorMsg(errorMsg.substring(0, 246) + "...");
            } else {
                paymentInfo.setErrorMsg(errorMsg);
            }
            if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
                paymentInfo.setBankStatus(bankStatus);
            }
            if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
                paymentInfo.setBankMsg(bankMsg);
            }
        }
    }

    public static void setPaymentsWithoutStauts(List<PaymentInfo> paymentInfos, String statusMsg, String bankStatus, String bankMsg) {
        for (PaymentInfo info : paymentInfos) {
            info.setBackStatus(info.getStatus());
            info.setBackStatusMsg(info.getStatusMsg());
            info.setUpdateOperation(UpdateOpState.SYSTEM.getId());
            info.setStatusMsg(statusMsg);
            info.setBankStatus(bankStatus);
            info.setBankMsg(bankMsg);
        }
    }

    public static void setPaymentWithoutStauts(PaymentInfo info, String bankStatus, String bankMsg) {
        info.setBackStatus(info.getStatus());
        info.setBackStatusMsg(info.getStatusMsg());
        info.setUpdateOperation(UpdateOpState.SYSTEM.getId());
        info.setBankStatus(bankStatus);
        info.setBankMsg(bankMsg);
    }

    public static PaymentInfo selectPaymentInfo(PaymentInfo[] infos, String bankBatchSeq, String bankSerialNo) {
        for (PaymentInfo info : infos) {
            if (!info.getBankBatchSeqID().equalsIgnoreCase(bankBatchSeq) || !info.getBankSerialNo().equalsIgnoreCase(bankSerialNo)) continue;
            return info;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6279\u6b21\u53f7\u548c\u987a\u5e8f\u53f7:%1$s, %2$s", (String)"EBGBusinessUtils_4", (String)"ebg-aqap-business", (Object[])new Object[0]), bankBatchSeq, bankSerialNo);
        logger.info(errorMsg);
        return null;
    }

    public static PaymentInfo selectPaymentInfo(List<PaymentInfo> infos, String bankBatchSeq, String bankSerialNo) {
        for (PaymentInfo info : infos) {
            if (!info.getBankBatchSeqID().equalsIgnoreCase(bankBatchSeq) || !info.getBankSerialNo().equalsIgnoreCase(bankSerialNo)) continue;
            return info;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6279\u6b21\u53f7\u548c\u987a\u5e8f\u53f7:%1$s, %2$s", (String)"EBGBusinessUtils_4", (String)"ebg-aqap-business", (Object[])new Object[0]), bankBatchSeq, bankSerialNo);
        logger.info(errorMsg);
        return null;
    }

    public static PaymentInfo selectPaymentInfo(PaymentInfo[] infos, String bankDetailSeqID) {
        for (PaymentInfo info : infos) {
            if (!info.getBankDetailSeqID().equalsIgnoreCase(bankDetailSeqID)) continue;
            return info;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6d41\u6c34\u53f7:%s\u3002", (String)"EBGBusinessUtils_5", (String)"ebg-aqap-business", (Object[])new Object[0]), bankDetailSeqID);
        logger.info(errorMsg);
        return null;
    }

    public static PaymentInfo selectPaymentInfo(List<PaymentInfo> infos, String bankDetailSeqID) {
        for (PaymentInfo info : infos) {
            if (!info.getBankDetailSeqID().equalsIgnoreCase(bankDetailSeqID)) continue;
            return info;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6d41\u6c34\u53f7:%s\u3002", (String)"EBGBusinessUtils_5", (String)"ebg-aqap-business", (Object[])new Object[0]), bankDetailSeqID);
        logger.info(errorMsg);
        return null;
    }

    public static PaymentInfo selectPaymentInfo(PaymentInfo[] infos, String incomeAccNo, BigDecimal amount) {
        BigDecimal formatedAmount = amount.setScale(2, 1);
        for (PaymentInfo info : infos) {
            if (!info.getIncomeAccNo().equalsIgnoreCase(incomeAccNo) || !info.getAmount().equals(formatedAmount)) continue;
            return info;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u6536\u6b3e\u5e10\u53f7:%s\u3002", (String)"EBGBusinessUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]), incomeAccNo) + String.format(ResManager.loadKDString((String)"\u6216\u610f\u5916\u7684\u91d1\u989d:%s\u3002", (String)"EBGBusinessUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), amount);
        logger.error(errorMsg);
        return null;
    }

    public static PaymentInfo selectPaymentInfo(List<PaymentInfo> infos, String incomeAccNo, BigDecimal amount) {
        BigDecimal formatedAmount = amount.setScale(2, 1);
        for (PaymentInfo info : infos) {
            if (!info.getIncomeAccNo().equalsIgnoreCase(incomeAccNo) || !info.getAmount().equals(formatedAmount)) continue;
            return info;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u6536\u6b3e\u5e10\u53f7:%s\u3002", (String)"EBGBusinessUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]), incomeAccNo) + String.format(ResManager.loadKDString((String)"\u6216\u610f\u5916\u7684\u91d1\u989d:%s\u3002", (String)"EBGBusinessUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), amount);
        logger.error(errorMsg);
        return null;
    }

    public static EBBankPayResponse buildQueryPayResponse(List<PaymentInfo> paymentInfos) {
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(paymentInfos);
        return response;
    }

    public static void setBankRefId(List<PaymentInfo> paymentInfos, String bankRefId) {
        for (PaymentInfo info : paymentInfos) {
            info.setBankRefID(bankRefId);
        }
    }

    public static void setBankRefId(PaymentInfo[] infos, String bankRefId) {
        for (PaymentInfo info : infos) {
            info.setBankRefID(bankRefId);
        }
    }
}

