/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.exception.IllegalPaymentResult;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.business.payment.utils.PaymentConvert;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayBody;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayDetail;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayResponse;
import kd.ebg.aqap.common.entity.biz.pay.PayBody;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryOverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryOverseaPayRequestBody;
import kd.ebg.aqap.common.entity.biz.querypay.QueryOverseaPayResponse;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OverseaPaymentConvertUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaPaymentConvertUtil.class);
    public static final String PAYMENT_DETAIL = OverseaPaymentConvertUtil.getPaymentDetail();

    public static String getPaymentDetail() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u660e\u7ec6", (String)"OverseaPaymentConvertUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static PayRequest getPayRequest(OverseaPayRequest request) {
        PayRequest payRequest = new PayRequest();
        PayBody payBody = new PayBody();
        payRequest.setBody(payBody);
        payRequest.setHeader(request.getHeader());
        payRequest.setExtData(request.getExtData());
        OverseaPayBody overseaBody = request.getBody();
        payBody.setBatchBizNo(overseaBody.getBatchBizNo());
        payBody.setBatchSeqID(overseaBody.getBatchSeqID());
        payBody.setDetails(OverseaPaymentConvertUtil.overseaPayDetailConvertPayDetail(overseaBody.getDetails()));
        payBody.setFeeType(overseaBody.getFeeType());
        payBody.setThirdAccNo(overseaBody.getThirdAccNo());
        payBody.setTotalAmount(overseaBody.getTotalAmount());
        payBody.setTotalCount(overseaBody.getTotalCount());
        payBody.setVerifyField(overseaBody.getVerifyField());
        payBody.setExtData(overseaBody.getExtData());
        return payRequest;
    }

    public static void complementOverseaPayDetail(List<PaymentInfo> paymentInfoList, OverseaPayRequest request, InvalidPaymentResult paymentResult) {
        List details = request.getBody().getDetails();
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        for (int i = 0; i < details.size(); ++i) {
            OverseaPayDetail detail = (OverseaPayDetail)details.get(i);
            PaymentInfo info = paymentInfoList.get(i);
            try {
                info.setPayerFeeAccNo(detail.getPayerFeeAccNo());
                info.setPayerFeeCurrency(detail.getPayerFeeCurrency());
                info.setPayerFeeType(detail.getPayerFeeType());
                info.setActualAmount(CheckUtil.checkBigDecimal(detail.getActualAmount(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u7b14\u7684\u5b9e\u9645\u4ea4\u6613\u91d1\u989d", (String)"OverseaPaymentConvertUtil_12", (String)"ebg-aqap-business", (Object[])new Object[0]), i + 1)));
                info.setPayCurrency(CheckUtil.checkStringNotNull(detail.getPayCurrency(), ResManager.loadKDString((String)"\u652f\u4ed8\u5e01\u79cd\uff08\u6536\u6b3e\u5e01\u79cd\uff09", (String)"OverseaPaymentConvertUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0]), PAYMENT_DETAIL, i));
                info.setPayeeBankCode(detail.getIncomeBankCode());
                if ("overseaPay".equals(request.getHeader().getSubBizType())) {
                    info.setExchangeRate(CheckUtil.checkStringNotNull(detail.getExchangeRate(), ResManager.loadKDString((String)"\u534f\u5b9a\u6c47\u7387\u4e0d\u4e3a\u7a7a", (String)"OverseaPaymentConvertUtil_4", (String)"ebg-aqap-business", (Object[])new Object[0]), PAYMENT_DETAIL, i));
                    info.setIncomeCountry(CheckUtil.checkStringNotNull(detail.getIncomeCountry(), ResManager.loadKDString((String)"\u5883\u5916\u652f\u4ed8\u6536\u6b3e\u65b9\u56fd\u5bb6", (String)"OverseaPaymentConvertUtil_5", (String)"ebg-aqap-business", (Object[])new Object[0]), PAYMENT_DETAIL, i));
                    CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(detail.getIncomeCountry());
                    if (null == code) {
                        throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"OverseaPaymentConvertUtil_13", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getIncomeCountry()));
                    }
                    if (!StringUtils.isEmpty((String)detail.getProxyBankCountry()) && null == (code = ISOCountryUtils.getInstance().getCountryInfo(detail.getProxyBankCountry()))) {
                        throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u4ee3\u7406\u884c\u56fd\u5bb6\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"OverseaPaymentConvertUtil_14", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getProxyBankCountry()));
                    }
                }
                info.setExchangeRate(detail.getExchangeRate());
                info.setTransactionRemarks(detail.getTransactionRemarks());
                info.setProxyAccNo(detail.getProxyAccNo());
                info.setProxyAccName(detail.getProxyAccName());
                info.setProxyBankCountry(detail.getProxyBankCountry());
                info.setProxyBankArea(detail.getProxyBankArea());
                info.setProxyBankSwiftCode(detail.getProxyBankSwiftCode());
                info.setProxyBankName(detail.getProxyBankName());
                info.setProxyBankAddress(detail.getProxyBankAddress());
                info.setProxyFeeType(detail.getProxyFeeType());
                info.setProxyFeeCurrency(detail.getProxyFeeCurrency());
                info.setIncomeBankAddress(detail.getIncomeBankAddress());
                if (StringUtils.isNotEmpty((String)detail.getIncomeAddress())) {
                    info.setIncomeAddress(detail.getIncomeAddress());
                }
                info.setIncomeBankLocalClearingCode(detail.getIncomeBankLocalClearingCode());
                info.setIncomeBankLocalClearingBranchCode(detail.getIncomeBankLocalClearingBranchCode());
                info.setIncomeBankLocalClearingBranchSubCode(detail.getIncomeBankLocalClearingBranchsubCode());
                info.setChequeType(detail.getChequeType());
                info.setDeliveryMethod(detail.getDeliveryMethod());
                info.setThirdBankAddress(detail.getReceiverAddress());
                info.setThirdAccName(detail.getReceiverName());
                PaymentInfoSysFiled.set(info, "chequeUsage", detail.getChequeUsage());
                info.setPaymentMethod(detail.getPaymentMethod());
                info.setServiceLevel(detail.getServiceLevel());
                if (!StringUtils.isEmpty((String)detail.getExContract())) {
                    info.setExContract(detail.getExContract());
                }
                if (!StringUtils.isEmpty((String)detail.getSettlementMethod())) {
                    info.setSettlementMethod(detail.getSettlementMethod());
                }
                if (StringUtils.isNotEmpty((String)detail.getBeneCountryCode())) {
                    info.setBeneCountryCode(detail.getBeneCountryCode());
                }
                if (StringUtils.isNotEmpty((String)detail.getBeneFPSId())) {
                    info.setBeneFPSId(detail.getBeneFPSId());
                }
                if (StringUtils.isNotEmpty((String)detail.getIsNotify())) {
                    info.setNotify(Boolean.parseBoolean(detail.getIsNotify()));
                }
                if (StringUtils.isNotEmpty((String)detail.getBeneEmail())) {
                    info.setBeneEmail(detail.getBeneEmail());
                }
                if (StringUtils.isNotEmpty((String)detail.getApplyName())) {
                    info.setApplyName(detail.getApplyName());
                }
                if (StringUtils.isNotEmpty((String)detail.getApplyPhone())) {
                    info.setApplyPhone(detail.getApplyPhone());
                }
                if (detail.isDiffCurrency()) {
                    info.setDiffCurrency(detail.isDiffCurrency());
                }
                if (StringUtils.isNotEmpty((String)detail.getExchangeCurrency())) {
                    info.setExchangeCurrency(detail.getExchangeCurrency());
                }
                if (StringUtils.isNotEmpty((String)detail.getPayProperty())) {
                    info.setPayProperty(detail.getPayProperty());
                }
                if (detail.isBondGoodsFlag()) {
                    info.setBondGoodsFlag(detail.isBondGoodsFlag());
                }
                if (StringUtils.isNotEmpty((String)detail.getContractNo())) {
                    info.setContractNo(detail.getContractNo());
                }
                if (StringUtils.isNotEmpty((String)detail.getInvoiceNo())) {
                    info.setInvoiceNo(detail.getInvoiceNo());
                }
                if (StringUtils.isNotEmpty((String)detail.getPayAttribute())) {
                    info.setPayAttribute(detail.getPayAttribute());
                }
                if (StringUtils.isNotEmpty((String)detail.getBusinessTypeCode())) {
                    info.setBusinessTypeCode(detail.getBusinessTypeCode());
                }
                if (StringUtils.isNotEmpty((String)detail.getTxCode())) {
                    info.setTxCode(detail.getTxCode());
                }
                if (StringUtils.isNotEmpty((String)detail.getSocialCode())) {
                    info.setSocialCode(detail.getSocialCode());
                }
                if (StringUtils.isNotEmpty((String)detail.getFileList())) {
                    info.setFileList(detail.getFileList());
                }
                if (StringUtils.isNotEmpty((String)detail.getPayerAddress())) {
                    info.setPayerAddress(detail.getPayerAddress());
                }
                if (StringUtils.isNotEmpty((String)detail.getTxPostscript())) {
                    info.setTxPostscript(detail.getTxPostscript());
                }
                if (StringUtils.isNotEmpty((String)detail.getContractAmount())) {
                    info.setContractAmount(detail.getContractAmount());
                }
                if (StringUtils.isNotEmpty((String)detail.getTxAmount())) {
                    info.setTxAmount(detail.getTxAmount());
                }
                if (!StringUtils.isNotEmpty((String)detail.getDeclareFlag())) continue;
                info.setDeclareFlag(detail.getDeclareFlag());
                continue;
            }
            catch (EBPreCheckException | EBServiceException e) {
                illegalPaymentResult.addIllegalPayment(detail.getDetailSeqID(), e.getMessage());
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
    }

    private static List<PayDetail> overseaPayDetailConvertPayDetail(List<OverseaPayDetail> overseaPayDetails) {
        ArrayList<PayDetail> payDetails = new ArrayList<PayDetail>(16);
        for (OverseaPayDetail overseaPayDetail : overseaPayDetails) {
            PayDetail payDetail = new PayDetail();
            FieldUtils.copyFields((Object)overseaPayDetail, (Object)payDetail, null);
            payDetails.add(payDetail);
        }
        return payDetails;
    }

    public static OverseaPayResponse convert2OverseaPaymentResponse(List<PaymentInfo> paymentInfos, OverseaPayRequest request) {
        OverseaPayResponse rsp = new OverseaPayResponse();
        rsp.setHeader(request.getHeader());
        OverseaPayBody body = OverseaPaymentConvertUtil.convertInfos2OverseaPaymentBody(paymentInfos);
        body.setBatchSeqID(request.getBody().getBatchSeqID());
        body.setTotalAmount(request.getBody().getTotalAmount());
        body.setTotalCount(request.getBody().getTotalCount());
        body.setFeeType(request.getBody().getFeeType());
        body.setBatchRollBack(request.getBody().getBatchRollBack());
        rsp.setBody(body);
        return rsp;
    }

    public static OverseaPayDetail paymentInfo2OverseaPaymentDetail(PaymentInfo paymentInfo, Map<String, String> currencyMap) {
        OverseaPayDetail detail = new OverseaPayDetail();
        detail.setBatchSeqID(paymentInfo.getBatchSeqID());
        detail.setDetailSeqID(paymentInfo.getDetailSeqId());
        detail.setDetailBizNo(paymentInfo.getDetailBizNo());
        detail.setIncomeAccNo(paymentInfo.getIncomeAccNo());
        detail.setIncomeAccName(paymentInfo.getIncomeAccName());
        detail.setIncomeType(paymentInfo.is2Individual() ? "individual" : "company");
        detail.setIncomeBankName(paymentInfo.getIncomeBankName());
        detail.setIncomeBankAddress(paymentInfo.getIncomeBankAddress());
        detail.setIncomeCountry(paymentInfo.getIncomeCountry());
        detail.setIncomeProvince(paymentInfo.getIncomeProvince());
        detail.setIncomeCity(paymentInfo.getIncomeCity());
        detail.setIncomeAreaCode(paymentInfo.getIncomeAreaCode());
        detail.setIncomeCnapsCode(paymentInfo.getIncomeCnaps());
        detail.setIncomeSwiftCode(paymentInfo.getIncomeSwiftCode());
        detail.setAmount(paymentInfo.getAmount().toString());
        detail.setUrgent(paymentInfo.getUrgent().booleanValue());
        detail.setForce(paymentInfo.getForce().booleanValue());
        detail.setUseCN(paymentInfo.getUseCn());
        detail.setExplanation(paymentInfo.getExplanation());
        detail.setPayerFeeAccNo(paymentInfo.getPayerFeeAccNo());
        detail.setPayerFeeCurrency(paymentInfo.getPayerFeeCurrency());
        detail.setPayerFeeType(paymentInfo.getFeeType());
        detail.setExchangeRate(paymentInfo.getExchangeRate());
        if (null != paymentInfo.getActualAmount() && !paymentInfo.isDiffCurrency()) {
            detail.setActualAmount(paymentInfo.getActualAmount().setScale(2).toString());
        }
        detail.setIncomeBankCode(paymentInfo.getPayeeBankCode());
        detail.setTransactionRemarks(paymentInfo.getTransactionRemarks());
        detail.setProxyAccNo(paymentInfo.getProxyAccNo());
        detail.setProxyAccName(paymentInfo.getProxyAccName());
        detail.setProxyBankCountry(paymentInfo.getProxyBankCountry());
        detail.setProxyBankArea(paymentInfo.getProxyBankArea());
        detail.setProxyBankSwiftCode(paymentInfo.getProxyBankSwiftCode());
        detail.setProxyBankName(paymentInfo.getProxyBankName());
        detail.setProxyBankAddress(paymentInfo.getProxyBankAddress());
        detail.setProxyFeeType(paymentInfo.getProxyFeeType());
        detail.setProxyFeeCurrency(paymentInfo.getProxyFeeCurrency());
        String currency = "";
        if (!currencyMap.containsKey(paymentInfo.getPayCurrency())) {
            currency = CurrencyUtils.convert2Iso((String)paymentInfo.getPayCurrency());
            currencyMap.putIfAbsent(paymentInfo.getPayCurrency(), currency);
        } else {
            currency = currencyMap.get(paymentInfo.getPayCurrency());
        }
        detail.setPayCurrency(currency);
        detail.setExContract(paymentInfo.getExContract());
        detail.setVerifyField("");
        detail.setEbSeqId(paymentInfo.getId());
        String state = EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)paymentInfo.getStatus())).getName();
        detail.setEbStatus(state);
        String ebStatusMsg = PaymentConvert.getEbStatusMsg(paymentInfo);
        detail.setEbStatusMsg(ebStatusMsg);
        detail.setBankBatchSeqId(paymentInfo.getBankBatchSeqId());
        detail.setBankDetailSeqId(paymentInfo.getBankDetailSeqId());
        detail.setKdFlagID(paymentInfo.getKdFlagID());
        detail.setBankStatus(paymentInfo.getBankStatus());
        detail.setBankMsg(OverseaPaymentConvertUtil.addTitle(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de", (String)"OverseaPaymentConvertUtil_10", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getBankMsg()));
        detail.setAmount(paymentInfo.getAmount().toString());
        detail.setExtData(paymentInfo.getReversedSysField());
        detail.setAbstractMsg(paymentInfo.getAbstractMsg());
        return detail;
    }

    private static String addTitle(String title, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        return title + ":" + content;
    }

    public static List<PaymentInfo> convertQueryOverseaPayment2Info(QueryOverseaPayRequest requset) {
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(16);
        PaymentInfo paymentInfo = new PaymentInfo();
        QueryOverseaPayRequestBody body = (QueryOverseaPayRequestBody)CheckUtil.checkObjectNotNull(requset.getBody(), "QueryPayRequestBody");
        String batchSeqID = CheckUtil.checkStringNotNull(body.getBatchSeqId(), ResManager.loadKDString((String)"\u6279\u6b21\u6d41\u6c34\u53f7(batchSeqID)\u3002", (String)"OverseaPaymentConvertUtil_11", (String)"ebg-aqap-business", (Object[])new Object[0]), "QueryPayRequestBody", -1);
        paymentInfo.setBatchSeqID(batchSeqID);
        return paymentInfos;
    }

    public static QueryOverseaPayResponse getQueryOverseaPayResponse(List<PaymentInfo> paymentInfoList, QueryOverseaPayRequest request) {
        QueryOverseaPayResponse response = new QueryOverseaPayResponse();
        response.setHeader(request.getHeader());
        response.setBody(OverseaPaymentConvertUtil.convertInfos2OverseaPaymentBody(paymentInfoList));
        response.getBody().setBatchSeqID(request.getBody().getBatchSeqId());
        return response;
    }

    private static OverseaPayBody convertInfos2OverseaPaymentBody(List<PaymentInfo> paymentInfos) {
        OverseaPayBody payBody = new OverseaPayBody();
        ArrayList<OverseaPayDetail> details = new ArrayList<OverseaPayDetail>(paymentInfos.size());
        payBody.setDetails(details);
        payBody.setBatchSeqID(paymentInfos.get(0).getBatchSeqId());
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        for (int i = 0; i < paymentInfos.size(); ++i) {
            OverseaPayDetail detail = OverseaPaymentConvertUtil.paymentInfo2OverseaPaymentDetail(paymentInfos.get(i), currencyMap);
            details.add(detail);
        }
        payBody.setVerifyField("");
        return payBody;
    }
}

