/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankQueryPayTask;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

public class QueryPaymentUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentUtil.class);
    public static final String IS_USER_HANDLED = "isUserHandled";

    public static Set<List<PaymentInfo>> setOfPay(List<PaymentInfo> infos) {
        HashMap map = Maps.newHashMap();
        List toQuery = infos.stream().filter(info -> info.getStatus().intValue() == PaymentState.SUBMITED.getId() || info.getStatus().intValue() == PaymentState.UNKNOWN.getId() || info.getStatus().intValue() == PaymentState.SUBMITTING.getId()).collect(Collectors.toList());
        for (PaymentInfo info2 : toQuery) {
            if (UpdateOpState.MANUAL.getId().equalsIgnoreCase(info2.getUpdateOperation()) || UpdateOpState.PAY_FAIL.getId().equalsIgnoreCase(info2.getUpdateOperation())) continue;
            String bankBatchSeqId = info2.getBankBatchSeqID();
            if (map.containsKey(bankBatchSeqId)) {
                ((List)map.get(bankBatchSeqId)).add(info2);
                continue;
            }
            map.put(bankBatchSeqId, Lists.newArrayList());
            ((List)map.get(bankBatchSeqId)).add(info2);
        }
        return Sets.newHashSet(map.values());
    }

    public static Set<List<PaymentInfo>> setOfForceQueryPay(List<PaymentInfo> infos) {
        HashMap map = Maps.newHashMap();
        List toQuery = infos.stream().filter(info -> info.getStatus().intValue() == PaymentState.FAIL.getId() || info.getStatus().intValue() == PaymentState.UNKNOWN.getId()).collect(Collectors.toList());
        for (PaymentInfo info2 : toQuery) {
            String bankBatchSeqId = info2.getBankBatchSeqID();
            if (map.containsKey(bankBatchSeqId)) {
                ((List)map.get(bankBatchSeqId)).add(info2);
                continue;
            }
            map.put(bankBatchSeqId, Lists.newArrayList());
            ((List)map.get(bankBatchSeqId)).add(info2);
        }
        return Sets.newHashSet(map.values());
    }

    public static void async(Set<List<PaymentInfo>> set, EBRequest queryPayRequest) {
        String extDate = queryPayRequest.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<PaymentInfo> infos : set) {
            String bankBatchSeqID;
            Map extMap;
            BankPayRequest request = QueryPaymentUtil.getQueryPayRequest(infos);
            PaymentInfo paymentInfo = infos.get(0);
            String bankVersion = paymentInfo.getBankVersionID();
            String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
            String bizType = queryPayRequest.getHeader().getBizType();
            String customerId = paymentInfo.getCustomID();
            String batchSeqId = paymentInfo.getBatchSeqId();
            String requestSeqId = "";
            requestSeqId = queryPayRequest.getHeader().getRequestSeqID() == null ? Sequence.genSequence() : String.valueOf(queryPayRequest.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(queryPayRequest.getHeader().getLogRequestSeqID());
            String logBizSeqId = String.valueOf(queryPayRequest.getHeader().getLogBizSeqID());
            String accNo = paymentInfo.getAccNo();
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            bankAcnt.setBankLoginId(bankLoginId);
            bankAcnt.setBankVersionId(bankVersion);
            String subBizType = bizType;
            if (StringUtils.isNotEmpty((String)paymentInfo.getLinkpayType())) {
                subBizType = "linkPay";
            }
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bankLoginID(bankLoginId).bizSeqID(batchSeqId).logBizSeqID(logBizSeqId).logRequestSeqID(logRequestSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(paymentInfo.getBankBatchSeqID()).loggerBankNo(loggerBankNo).build();
            context.setBankAcnt(bankAcnt);
            String extData = queryPayRequest.getExtData();
            if (StringUtils.isNotEmpty((String)extData) && (extMap = (Map)JsonUtil.fromJson((String)extData, Map.class)).containsKey(IS_USER_HANDLED)) {
                boolean isUserHandled = Boolean.parseBoolean((String)extMap.get(IS_USER_HANDLED));
                HashMap<String, String> runningParams = new HashMap<String, String>(16);
                runningParams.put(IS_USER_HANDLED, String.valueOf(isUserHandled));
                context.setRunningParams(runningParams);
            }
            if (CachePayStorage.checkSubmitLock(bankBatchSeqID = paymentInfo.getBankBatchSeqID())) {
                logger.info(String.format("\u67e5\u8be2\u4ed8\u6b3e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u67e5\u8be2\u4ed8\u6b3e\u4efb\u52a1\u4e0d\u63d0\u4ea4\u7ebf\u7a0b\u6c60", bankBatchSeqID));
                continue;
            }
            logger.info(String.format("\u67e5\u8be2\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customerId, bankLoginId));
            String taskID = EBThreadPools.createBizTask(context);
            BankQueryPayTask bankQueryPayTask = new BankQueryPayTask(request, context);
            bankQueryPayTask.setTaskId(taskID);
            EBThreadPools.getQueryPayThreadPool(customerId, bankLoginId).submit((Callable)((Object)bankQueryPayTask));
            logger.info("\u67e5\u8be2\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60:\u5b8c\u6210");
        }
    }

    public static BankPayRequest getQueryPayRequest(List<PaymentInfo> infos) {
        BankPayRequest request = new BankPayRequest();
        String bankBatchSeqID = infos.get(0).getBankBatchSeqID();
        BigDecimal totalAmount = infos.get(0).getTotalAmount();
        request.setBankBatchSeqID(bankBatchSeqID);
        request.setPaymentInfos(infos);
        request.setTotalAmount(totalAmount);
        request.setTotalCount(infos.size());
        request.setHeader(QueryPaymentUtil.getHeader(infos.get(0)));
        return request;
    }

    private static BankHeader getHeader(PaymentInfo info) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(info.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqID());
        header.setLogBizSeqID(info.getBatchSeqID());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankQueryPayTask");
        header.setClientVersion("1.0");
        return header;
    }

    public static void secondCheckPayStatus(List<PaymentInfo> lists) {
        if (CollectionUtil.isEmpty(lists)) {
            return;
        }
        boolean openQueryPayWithKdFlag = SystemPropertyConfig.isOpenQueryPayWithKdFlag();
        if (openQueryPayWithKdFlag) {
            logger.info("\u5f00\u542f\u4e86\u4ed8\u6b3e\u72b6\u6001\u4e8c\u6b21\u786e\u8ba4");
            HashMap<String, PaymentInfo> map = new HashMap<String, PaymentInfo>();
            ArrayList kdFlagIDs = Lists.newArrayList();
            for (PaymentInfo paymentInfo : lists) {
                String kdFlagID = paymentInfo.getKdFlagID();
                if (StringUtils.isEmpty((String)kdFlagID) || !StringUtils.equals((String)kdFlagID, (String)paymentInfo.getBankDetailSeqID()) || paymentInfo.getStatus().intValue() != PaymentState.UNKNOWN.getId() && paymentInfo.getStatus().intValue() != PaymentState.FAIL.getId()) continue;
                map.put(kdFlagID, paymentInfo);
                kdFlagIDs.add(kdFlagID);
            }
            logger.info("\u6ee1\u8db3\u4ed8\u6b3e\u72b6\u6001\u4e8c\u6b21\u786e\u8ba4\u6761\u4ef6\u7684\u4ed8\u6b3e\u7b14\u6570\uff1a" + map.size());
            if (CollectionUtil.isNotEmpty((Collection)kdFlagIDs)) {
                ArrayList results = Lists.newArrayList();
                List detailInfos = DetailInfoService.getInstance().findDetailInfoListByKDFlagIds((List)kdFlagIDs);
                logger.info("\u6839\u636e\u4ed8\u6b3e\u5bf9\u8d26\u7801\u53cd\u67e5\u5230\u7684\u660e\u7ec6\u7b14\u6570\uff1a" + detailInfos.size());
                for (DetailInfo detailInfo : detailInfos) {
                    PaymentInfo paymentInfo = (PaymentInfo)map.get(detailInfo.getPayBankDetailSeqID());
                    if (paymentInfo == null) continue;
                    EBGBusinessUtils.setPaymentState(paymentInfo, PaymentState.SUCCESS, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ea4\u6613\u660e\u7ec6\uff08\u94f6\u4f01\u6d41\u6c34\u53f7%1$s\uff09\uff0c\u94f6\u4f01\u81ea\u52a8/\u624b\u5de5\u66f4\u65b0\u4e3a\u4ea4\u6613\u6210\u529f\u3002", (String)"QueryPaymentUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]), detailInfo.getId()), "", "");
                    paymentInfo.setUpdateOperation(UpdateOpState.MANUAL.getId());
                    paymentInfo.setReason(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ea4\u6613\u660e\u7ec6\uff08\u94f6\u4f01\u6d41\u6c34\u53f7%1$s\uff09\uff0c\u94f6\u4f01\u81ea\u52a8/\u624b\u5de5\u66f4\u65b0\u4e3a\u4ea4\u6613\u6210\u529f\u3002", (String)"QueryPaymentUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]), detailInfo.getId()));
                    results.add(paymentInfo);
                }
                PaymentInfoService.getInstance().save((List)results);
                logger.info("\u4ed8\u6b3e\u72b6\u6001\u4e8c\u6b21\u786e\u8ba4\u4ea4\u6613\u6210\u529f\u7b14\u6570\uff1a" + results.size());
            }
        }
    }
}

