/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qlb.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qlb.dc.service.BankBusinessConfig;
import kd.ebg.aqap.banks.qlb.dc.service.QLB_Constants;
import kd.ebg.aqap.banks.qlb.dc.service.QLB_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class DetailParser
implements QLB_Constants {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    public static EBBankDetailResponse parseDetailMessage(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        BankResponse resp = QLB_Parser.parserCommonHead(rspStr);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        if (!"0000".equals(resp.getResponseCode())) {
            if ("000305".equals(resp.getResponseCode())) {
                return new EBBankDetailResponse(detailInfos);
            }
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%s", (String)"DetailParser_5", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]), resp.toString()));
        }
        Element root = QLB_Parser.parseRootElement(rspStr);
        Element opResult = root.getChild("opRep").getChild("opResult");
        if (null == opResult) {
            logger.info("\u8fd4\u56de\u7684<opResult>\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6");
            return new EBBankDetailResponse(detailInfos);
        }
        Element list = opResult.getChild("list");
        List rowList = list.getChildren("row");
        if (rowList == null || rowList.size() == 0) {
            return new EBBankDetailResponse(detailInfos);
        }
        for (int i = 0; i < rowList.size(); ++i) {
            Element row = (Element)rowList.get(i);
            DetailInfo detail = DetailParser.parseEachDetailInfo(rqst.getAcnt(), row);
            detailInfos.add(detail);
        }
        logger.info("---\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f---");
        return new EBBankDetailResponse(detailInfos);
    }

    private static DetailInfo parseEachDetailInfo(BankAcnt acnt, Element row) throws EBServiceException {
        String explan;
        String tran_date = row.getChildTextTrim("TRAN_DATE");
        String TRAN_DESC = row.getChildTextTrim("TRAN_DESC");
        String cur = row.getChildTextTrim("CCY");
        String tran_amount = row.getChildTextTrim("TRAN_AMT");
        String cd_flag = row.getChildTextTrim("CR_DR_MAINT_IND");
        String balance = row.getChildTextTrim("ACTUAL_BAL_AMT");
        String OppAcctNo = row.getChildTextTrim("OTH_ACCT_NO");
        String OppAccName = row.getChildTextTrim("OTH_ACCT_NAME");
        String remark = row.getChildTextTrim("REMARKS");
        String tran_time = row.getChildTextTrim("TRANSDATETIME");
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acnt.getAccNo());
        detailInfo.setAccName(acnt.getAccName());
        detailInfo.setOppAccNo(OppAcctNo);
        detailInfo.setOppAccName(OppAccName);
        if ("CBE008".equals(BankBusinessConfig.getDetailCode())) {
            detailInfo.setOppBankName(row.getChildTextTrim("OTH_ACCT_BANKNAME"));
        }
        detailInfo.setCurrency(cur);
        if (!StringUtils.isEmpty((String)tran_date)) {
            try {
                detailInfo.setTransDate(LocalDateUtil.parserDate((String)tran_date));
                if (StringUtils.isEmpty((String)tran_time)) {
                    detailInfo.setTransTime(LocalDateTime.parse(tran_date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
                detailInfo.setTransTime(LocalDateTime.parse(tran_date + tran_time, DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss")));
            }
            catch (EBServiceException e) {
                throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u4ea4\u6613\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38\uff1a%s\u3002", (String)"DetailParser_6", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]), e.getMessage()));
            }
        } else {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailParser_2", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]));
        }
        if ("C".equals(cd_flag)) {
            detailInfo.setCreditAmount(new BigDecimal(tran_amount));
            detailInfo.setDebitAmount(new BigDecimal("0.00"));
        } else if ("D".equals(cd_flag)) {
            detailInfo.setCreditAmount(new BigDecimal("0.00"));
            detailInfo.setDebitAmount(new BigDecimal(tran_amount));
        } else {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u65b9\u5411<CR_DR_MAINT_IND>\u4e3a%s,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u7684\u501f\u8d37\u65b9\u5411", (String)"DetailParser_7", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]), cd_flag));
        }
        detailInfo.setBalance(new BigDecimal(balance));
        String string = explan = "TRAN_DESC".equals(BankBusinessConfig.choosePS()) ? TRAN_DESC : remark;
        if (!StringUtils.isEmpty((String)explan) && explan.contains("@KD")) {
            String[] explans = explan.split("@KD");
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)explans[0]);
            explan = explans.length > 1 ? explans[1] : "";
        }
        detailInfo.setExplanation(explan);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("SEQ_NO", (Object)row.getChildTextTrim("SEQ_NO"));
        jsonObject.put("cdFlag", (Object)cd_flag);
        jsonObject.put("tranDate", (Object)tran_date);
        jsonObject.put("balance", (Object)balance);
        jsonObject.put("Amount", (Object)tran_amount);
        jsonObject.put("rAmount", (Object)new BigDecimal(tran_amount).toPlainString());
        detailInfo.setJsonMap(jsonObject.toJSONString());
        String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), tran_date, jsonObject.toJSONString());
        detailInfo.setReceiptNo(receiptNo);
        return detailInfo;
    }
}

