/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.utils.BankStatusCode;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "STCM1002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        String trCode = "STCM1002";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element Req = JDomUtils.addChild((Element)Data, (String)"Req");
        String req_no = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"req_no");
        String tr_acdt = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"tr_acdt");
        if (StringUtils.isEmpty((String)req_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u539f\u4ea4\u6613\u8bf7\u6c42\u53f7req_no\u4e3a\u7a7a\u3002", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)tr_acdt)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671ftr_acdt\u4e3a\u7a7a\u3002", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)Req, (String)"req_no", (String)req_no);
        JDomUtils.addChild((Element)Req, (String)"tr_acdt", (String)tr_acdt);
        JDomUtils.addChild((Element)Req, (String)"qry_acno", (String)info.getAccNo());
        return JDomUtils.root2String((Element)Packet, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element Packet = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element Data = Packet.getChild("Data");
        Element Pub = Data.getChild("Pub");
        Element Res = Data.getChild("Res");
        BankResponse response = TCommon.parseBankResponse(Pub);
        if ("0000".equals(response.getResponseCode()) || "000000".equals(response.getResponseCode())) {
            String stat = JDomUtils.getChildTextNotNull((Element)Res, (String)"stat");
            if ("9".equals(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
            } else if ("1".equals(stat) || "6".equals(stat) || "7".equals(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
            }
        } else {
            String errorMsg = BankStatusCode.bankStatusCodeMap.get(response.getResponseCode());
            if (StringUtils.isEmpty((String)errorMsg)) {
                errorMsg = response.getResponseMessage();
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)errorMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

