/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.balancereconciliation;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.balancereconciliation.QueryBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    public int getMonthSpan() {
        return 3;
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        QueryBalanceStatement queryBalanceStatement = new QueryBalanceStatement();
        BalanceReconciliationDetail detail = queryBalanceStatement.getStmtNo(bankBalanceStatementRequest.getAccNo(), bankBalanceStatementRequest.getStartMonth(), bankBalanceStatementRequest.getEndMonth());
        Element root = BOCOM_DC_Packer.packRoot("999007");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)bankBalanceStatementRequest.getAccNo());
        JDomUtils.addChild((Element)body, (String)"IssueDate", (String)detail.getMonth());
        JDomUtils.addChild((Element)body, (String)"StmtNo", (String)detail.getStatementNo());
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String response) {
        Element ap = JDomUtils.string2Root((String)response, (String)RequestContextUtils.getCharset());
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(1);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"BalanceStatementImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = ap.getChild("body");
        Element resultList = body.getChild("resultList");
        Element record = resultList.getChild("Record");
        String accountNo = JDomUtils.getChildText((Element)record, (String)"accountNo");
        String creationDate = JDomUtils.getChildText((Element)record, (String)"creationDate");
        String smNo = JDomUtils.getChildText((Element)record, (String)"smNo");
        String amt = JDomUtils.getChildText((Element)record, (String)"amt");
        String currency = JDomUtils.getChildText((Element)record, (String)"currency");
        BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
        detail.setAccNo(accountNo);
        detail.setStatementNo(smNo);
        detail.setMonth(creationDate.substring(0, 6));
        detail.setCurrency(currency);
        detail.setBalance(amt);
        detailList.add(detail);
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "999007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3", (String)"BalanceStatementImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }
}

