/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.SingleIndividualPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.FastPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.SingleFastPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.SingleSlowPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize.SlowPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank.BatchPayImpl;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank.SinglePayImpl;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BOCOMUseConvertor {
    public static void checkUse(PaymentInfo paymentInfo) {
        String useCn = paymentInfo.getUseCn();
        if ("-1".equalsIgnoreCase(paymentInfo.getUseCode())) {
            if (AllocationPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) && !ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"BOCOMUseConvertor_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn) && !ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"BOCOMUseConvertor_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5212\u62e8\u4f7f\u7528\u4e86\u9519\u8bef\u7684\u4ed8\u6b3e\u7528\u9014%1$s\u3002\u5728\u4ea4\u884c\u76f4\u8054\u7248\u4e2d\uff0c\u5212\u62e8\u7684\u7528\u9014\u5fc5\u987b\u662f'\u8d44\u91d1\u4e0a\u5212'\u6216'\u8d44\u91d1\u4e0b\u62e8'", (String)"BOCOMUseConvertor_9", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), useCn));
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%1$s\u3002", (String)"BOCOMUseConvertor_11", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
        }
    }

    public static String convert2BOCOMType(String transCode, PaymentInfo paymentInfo) {
        String useCode = paymentInfo.getUseCode();
        if (useCode == null) {
            paymentInfo.setUseCode("-1");
            useCode = "-1";
        }
        String useCn = paymentInfo.getUseCn();
        String busiType = "";
        if ("-1".equalsIgnoreCase(useCode)) {
            if (!BOCOMUseConvertor.isIndividualPay(paymentInfo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u4e0d\u662f\u4ee3\u53d1\u6307\u4ee4\uff0c\u4e0d\u9700\u8981\u8f6c\u6362\u4e3a'\u7c7b\u578b'", (String)"BOCOMUseConvertor_8", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%1$s\u3002", (String)"BOCOMUseConvertor_11", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
        }
        busiType = BOCOMUseConvertor.getBocomUse(transCode, paymentInfo.getExplanation(), useCn);
        if (StringUtils.isEmpty((String)BankBusinessConfig.getPayrollNo(paymentInfo.getAccNo(), busiType))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7\uff1a%1$s\u672a\u7ef4\u62a4\u5bf9\u5e94\u7684\u4ee3\u53d1\u4e1a\u52a1\u534f\u8bae\u7f16\u53f7\uff0c\u8bf7\u5728\u8d26\u53f7\u914d\u7f6e\u91cc\u7ef4\u62a4\u3002", (String)"BOCOMUseConvertor_10", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), paymentInfo.getAccNo()));
        }
        return busiType;
    }

    private static String getBocomUse(String transCode, String explanation, String useCn) {
        String useCode = "";
        boolean individualSignTypeForOther = BankBusinessConfig.isIndividualSignTypeForOther();
        if (!individualSignTypeForOther) {
            String customId = EBContext.getContext().getCustomID();
            String interfaceName = transCode;
            String bankVersion = "BOCOM_DC";
            if (StringUtils.isNotEmpty((String)explanation)) {
                try {
                    useCode = UseKeyWordService.getUseByKey((String)customId, (String)explanation, (String)interfaceName, (String)useCode, (String)bankVersion);
                    if (StringUtils.isNotEmpty((String)useCode)) {
                        return useCode;
                    }
                    useCode = "S";
                }
                catch (Exception ex) {
                    useCode = "S";
                }
            }
            useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)useCode, (String)bankVersion);
            return useCode;
        }
        useCode = "S";
        return useCode;
    }

    public static boolean isIndividualPay(PaymentInfo paymentInfo) {
        return IndividualPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || FastPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || SlowPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || BatchPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || SinglePayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || SingleIndividualPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || SingleFastPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName()) || SingleSlowPayImpl.class.getName().equalsIgnoreCase(paymentInfo.getImplClassName());
    }
}

