/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.oversea;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.oversea.QueryOverSeaPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OverSeaPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryOverSeaPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"certNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)body, (String)"remitChnl", (String)"");
        JDomUtils.addChild((Element)body, (String)"chnSubId", (String)"");
        ISOCountryUtils isoCountryUtils = ISOCountryUtils.getInstance();
        CountryISOCode countryISOCode = isoCountryUtils.getCountryInfo(paymentInfo.getIncomeCountry());
        if (countryISOCode == null) {
            countryISOCode = isoCountryUtils.getCountryInfoByName(paymentInfo.getIncomeCountry());
        }
        JDomUtils.addChild((Element)body, (String)"targetCountryCode", (String)countryISOCode.geteChart3());
        JDomUtils.addChild((Element)body, (String)"remitKind", (String)("CHN".equalsIgnoreCase(countryISOCode.geteChart3()) ? "2" : "1"));
        JDomUtils.addChild((Element)body, (String)"realFundType", (String)paymentInfo.getBusinessTypeCode());
        JDomUtils.addChild((Element)body, (String)"outAcct", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payCcy", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)body, (String)"payAmt", (String)"");
        JDomUtils.addChild((Element)body, (String)"remitWay", (String)"1");
        JDomUtils.addChild((Element)body, (String)"pyrName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"pyrAddress", (String)paymentInfo.getPayerAddress());
        JDomUtils.addChild((Element)body, (String)"remitCcy", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)body, (String)"pyrInstructAmt", (String)paymentInfo.getActualAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"pyrPhone", (String)paymentInfo.getApplyPhone());
        JDomUtils.addChild((Element)body, (String)"pyeAcct", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"pyeName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"pyeAddress", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)body, (String)"fullAmtReceiveFlag", (String)"2");
        JDomUtils.addChild((Element)body, (String)"sameNameAcctTransferFlag", (String)"");
        JDomUtils.addChild((Element)body, (String)"isFixPayAmt", (String)"2");
        JDomUtils.addChild((Element)body, (String)"clearBkNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"pyeOpenAcctBkSwift", (String)paymentInfo.getIncomeSwiftCode());
        JDomUtils.addChild((Element)body, (String)"pyeOpenAcctBkName", (String)"");
        JDomUtils.addChild((Element)body, (String)"pyeOpenAcctBkAddress", (String)"");
        JDomUtils.addChild((Element)body, (String)"midBkBIC", (String)"");
        JDomUtils.addChild((Element)body, (String)"midBkName", (String)"");
        JDomUtils.addChild((Element)body, (String)"midBkAddress", (String)"");
        JDomUtils.addChild((Element)body, (String)"benbankagentAcct", (String)"");
        JDomUtils.addChild((Element)body, (String)"msgPyrAcct", (String)"");
        JDomUtils.addChild((Element)body, (String)"msgPyrName", (String)"");
        JDomUtils.addChild((Element)body, (String)"msgPyrAddress", (String)"");
        JDomUtils.addChild((Element)body, (String)"remitNote", (String)paymentInfo.getTxPostscript());
        JDomUtils.addChild((Element)body, (String)"sedtorecInf", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"bussnessTransNo", (String)"");
        String feeFlag = "1";
        if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeFlag = "3";
        } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeFlag = "2";
        }
        JDomUtils.addChild((Element)body, (String)"feeFlag", (String)feeFlag);
        JDomUtils.addChild((Element)body, (String)"feeCcy", (String)"");
        JDomUtils.addChild((Element)body, (String)"deductFeeAcct", (String)"");
        JDomUtils.addChild((Element)body, (String)"isReplaceRemitInfo", (String)"");
        String remitType = "";
        if ("1".equalsIgnoreCase(paymentInfo.getDeclareFlag())) {
            remitType = "2";
        } else if ("2".equalsIgnoreCase(paymentInfo.getDeclareFlag())) {
            remitType = "1";
        }
        JDomUtils.addChild((Element)body, (String)"remitType", (String)remitType);
        JDomUtils.addChild((Element)body, (String)"tranCode1", (String)paymentInfo.getTxCode());
        JDomUtils.addChild((Element)body, (String)"tranCode2", (String)"");
        JDomUtils.addChild((Element)body, (String)"correspondingAmt1", (String)paymentInfo.getTxAmount());
        JDomUtils.addChild((Element)body, (String)"correspondingAmt2", (String)"");
        JDomUtils.addChild((Element)body, (String)"note1", (String)paymentInfo.getTxPostscript());
        JDomUtils.addChild((Element)body, (String)"note2", (String)"");
        JDomUtils.addChild((Element)body, (String)"reqCountryCode", (String)countryISOCode.geteChart3());
        JDomUtils.addChild((Element)body, (String)"bondedGoodsType", (String)(paymentInfo.isBondGoodsFlag() ? "1" : "2"));
        String fundType = "O";
        if ("1".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            fundType = "P";
        } else if ("0".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            fundType = "A";
        } else if ("2".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            fundType = "R";
        }
        JDomUtils.addChild((Element)body, (String)"fundType", (String)fundType);
        JDomUtils.addChild((Element)body, (String)"safeApprovalNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"contractNo", (String)paymentInfo.getContractNo());
        JDomUtils.addChild((Element)body, (String)"invoiceNo", (String)paymentInfo.getInvoiceNo());
        JDomUtils.addChild((Element)body, (String)"contactName", (String)paymentInfo.getApplyName());
        JDomUtils.addChild((Element)body, (String)"payExchangeNature", (String)paymentInfo.getPayAttribute());
        JDomUtils.addChild((Element)body, (String)"rcvType", (String)("CHN".equalsIgnoreCase(countryISOCode.geteChart3()) ? "2" : "1"));
        JDomUtils.addChild((Element)body, (String)"unitCode", (String)paymentInfo.getSocialCode());
        JDomUtils.addChild((Element)body, (String)"applyCommitDate", (String)"");
        LocalDateTime now = LocalDateTime.now();
        if (null != paymentInfo.getBookingTime() && paymentInfo.getBookingTime().isAfter(now)) {
            JDomUtils.addChild((Element)body, (String)"OrderRemitDate", (String)paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
        } else {
            JDomUtils.addChild((Element)body, (String)"OrderRemitDate", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"payExchangeUseing", (String)"");
        JDomUtils.addChild((Element)body, (String)"exceptionFlag", (String)"");
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ap.getChild("body");
            if (body != null) {
                String bizId = body.getChildText("bizId");
                EBGBusinessUtils.setBankRefId((List)paymentInfos, (String)bizId);
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"BOCOM_DC_PayParser_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "210250";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56fd\u9645\u4e1a\u52a1\u6c47\u51fa\u6c47\u6b3e\u4ea4\u6613", (String)"OverSeaPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

