/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.services.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.WzbOpaBankBusinessConfig;
import kd.ebg.aqap.banks.wzb.opa.services.payment.single.QueryPaymentImpl;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.MsgParser;
import kd.ebg.aqap.banks.wzb.opa.util.PackerUtil;
import kd.ebg.aqap.banks.wzb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = PackerUtil.getBody();
        body.put("payAcctNo", (Object)info.getAccNo());
        body.put("transAmt", (Object)info.getAmount().toString());
        body.put("payAcctName", (Object)info.getAccName());
        body.put("rcvAcctNo", (Object)info.getIncomeAccNo());
        body.put("rcvAcctName", (Object)info.getIncomeAccName());
        body.put("inbankname", (Object)info.getIncomeBankName());
        body.put("inbankno", (Object)info.getIncomeCnaps());
        body.put("curCode", (Object)"1");
        body.put("curType", (Object)"0");
        String exp = info.getExplanation();
        if (WzbOpaBankBusinessConfig.isAddKDFlagToPay()) {
            exp = BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)exp);
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
        }
        body.put("remark", (Object)exp);
        body.put("orderNo", (Object)info.getBankBatchSeqID());
        body.put("reserve2", (Object)"");
        return JSONObject.toJSONString((Object)body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String result = MsgParser.getReceMsg(responseStr);
        JSONObject response = JSONObject.parseObject((String)result);
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d1\u9001 \u94f6\u884c\u5904\u7406\u72b6\u6001\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (String)"", (String)"");
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "singletrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType());
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String url = GetStore.getBaseUrl() + "/V1/P01506/S01/singletrans";
        EBContext.getContext().setProcessFlag(PROCESS_PACK);
        try {
            String rqstStr = this.pack(request);
            String rspStr = "";
            rspStr = PostUtil.sendMsgForPay(rqstStr, url);
            if (rspStr == null) {
                return null;
            }
            try {
                return this.parse(request, rspStr);
            }
            catch (Exception e) {
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

