/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbb.opa.services.utils.NBBUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class TodayDetaillmpl
extends AbstractDetailImpl
implements IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetaillmpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        try {
            NBBUtil.initSdk(request.getHeader().getCustomerID());
            ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
            String custId = RequestContextUtils.getBankParameterValue((String)"custId");
            this.setLastPage(false);
            this.setCurrentPage(1);
            do {
                this.setLastPage(true);
                JSONObject reqStr = new JSONObject();
                JSONObject data = new JSONObject();
                data.put("custId", (Object)custId);
                JSONArray acnt = new JSONArray();
                acnt.add((Object)request.getAcnt().getAccNo());
                data.put("bankAccList", (Object)acnt);
                data.put("pageSize", (Object)"1000");
                data.put("currentPage", (Object)this.getCurrentPage());
                data.put("queryType", (Object)"0");
                reqStr.put("Data", (Object)data);
                String ret = NBBUtil.send("accInfo", "queryAccDetail", reqStr.toJSONString(), this.getBizDesc());
                JSONObject retJson = JSONObject.parseObject((String)ret);
                JSONObject retData = retJson.getJSONObject("Data");
                String code = retData.getString("retCode");
                String msg = retData.getString("retMsg");
                if (!"0000".equalsIgnoreCase(code)) {
                    logger.error(retJson.toJSONString());
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a", (String)"TodayDetaillmpl_0", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]), msg));
                }
                String totalSize = retData.getString("totalSize");
                if (Integer.parseInt(totalSize) >= 1000) {
                    this.setLastPage(false);
                    int np = Integer.parseInt(this.getCurrentPage()) + 1;
                    this.setCurrentPage(np);
                }
                JSONArray details = retData.getJSONArray("list");
                HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
                for (int i = 0; i < details.size(); ++i) {
                    try {
                        DetailInfo detailInfo = new DetailInfo();
                        JSONObject detail = details.getJSONObject(i);
                        String bankAcc = detail.getString("bankAcc");
                        String accName = detail.getString("accName");
                        String oppAccName = detail.getString("oppAccName");
                        String oppAccNo = detail.getString("oppAccNo");
                        String amt = detail.getString("amt");
                        String bal = detail.getString("bal");
                        String transTime = detail.getString("transTime");
                        String cdSignName = detail.getString("cdSignName");
                        String curCode = detail.getString("curCode");
                        String uses = detail.getString("uses");
                        String voucherNo = detail.getString("voucherNo");
                        String serialId = detail.getString("serialId");
                        detailInfo.setAccNo(bankAcc);
                        detailInfo.setAccName(accName);
                        detailInfo.setOppAccNo(oppAccNo);
                        detailInfo.setOppAccName(oppAccName);
                        try {
                            detailInfo.setBalance(new BigDecimal(bal));
                        }
                        catch (Exception e) {
                            logger.error("\u4f59\u989d\u4e3a\u7a7a");
                        }
                        if (ResManager.loadKDString((String)"\u6536", (String)"TodayDetaillmpl_1", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]).equalsIgnoreCase(cdSignName)) {
                            detailInfo.setCreditAmount(new BigDecimal(amt));
                            detailInfo.setDebitAmount(BigDecimal.ZERO);
                        } else {
                            detailInfo.setDebitAmount(new BigDecimal(amt));
                            detailInfo.setCreditAmount(BigDecimal.ZERO);
                        }
                        detailInfo.setCurrency(curCode);
                        LocalDateTime tTime = LocalDateTime.parse(transTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                        LocalDate tDate = tTime.toLocalDate();
                        detailInfo.setTransDate(tDate);
                        detailInfo.setTransTime(tTime);
                        detailInfo.setReceiptNo(voucherNo);
                        detailInfo.setExplanation(uses);
                        detailInfo.setUseCN(uses);
                        detailInfo.setUniqueSeq(serialId);
                        JSONObject jsonMap = detail;
                        jsonMap.put("serialId", (Object)serialId);
                        String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), LocalDateUtil.formatDate((LocalDate)tDate), jsonMap.toJSONString());
                        if (countMap.containsKey(receiptNo)) {
                            int count = (Integer)countMap.get(receiptNo) + 1;
                            countMap.put(receiptNo, count);
                            receiptNo = receiptNo + "-" + String.format("%04d", count);
                        } else {
                            countMap.put(receiptNo, 0);
                        }
                        detailInfo.setReceiptNo(receiptNo);
                        detailInfo.setJsonMap(jsonMap.toJSONString());
                        result.add(detailInfo);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            } while (!this.isLastPage());
            return new EBBankDetailResponse(result);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "accInfo/queryAccDetail";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u660e\u7ec6", (String)"TodayDetaillmpl_2", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]);
    }
}

