/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.payment.oversea;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.nbb.opa.services.payment.oversea.QryTTPayImpl;
import kd.ebg.aqap.banks.nbb.opa.services.utils.NBBUtil;
import kd.ebg.aqap.banks.nbb.opa.services.utils.UploadResponse;
import kd.ebg.aqap.banks.nbb.opa.services.utils.UploadState;
import kd.ebg.aqap.banks.nbb.opa.services.utils.UploadUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TTPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TTPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryTTPayImpl.class;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String ret;
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        try {
            NBBUtil.initSdk(request.getHeader().getCustomerID());
            CountryISOCode payeeCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
            if (null == payeeCode) {
                payeeCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
            }
            if (StringUtils.isEmpty((String)paymentInfo.getAccCountry())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u4ed8\u6b3e\u65b9\u8d26\u53f7\u6240\u5728\u56fd\u5bb6\u5730\u533a\u3002", (String)"DLOUTSUBPayImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
            }
            logger.info("\u4ed8\u6b3e\u65b9\u8d26\u53f7\u6240\u5728\u56fd\u5bb6\u5730\u533a {}", (Object)paymentInfo.getAccCountry());
            CountryISOCode payerCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
            if (null == payerCode) {
                payerCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
            }
            boolean isOverseaBank = !"CN".equalsIgnoreCase(payeeCode.geteChart2());
            boolean isOversea = isOverseaBank || !"CN".equalsIgnoreCase(payerCode.geteChart2());
            String custId = RequestContextUtils.getBankParameterValue((String)"custId");
            String corpCode = BankBusinessConfig.getCode(request.getAcnt().getAccNo());
            if (StringUtils.isEmpty((String)corpCode)) {
                corpCode = RequestContextUtils.getBankParameterValue((String)"corpCode");
            }
            JSONObject reqStr = new JSONObject();
            JSONObject data = new JSONObject();
            data.put("custId", (Object)custId);
            data.put("serialNo", (Object)paymentInfo.getBankBatchSeqId());
            data.put("remitType", (Object)(isOversea ? "1" : "2"));
            if (isOversea) {
                data.put("transferType", (Object)"1");
            }
            data.put("corpCode", (Object)corpCode);
            data.put("bankType", (Object)"9038");
            String payProperty = paymentInfo.getPayProperty();
            String payMode = "01";
            if ("0".equalsIgnoreCase(payProperty)) {
                payMode = "02";
            } else if ("2".equalsIgnoreCase(payProperty)) {
                payMode = "04";
            } else if ("3".equalsIgnoreCase(payProperty)) {
                payMode = "03";
            }
            data.put("payMode", (Object)payMode);
            if ("01".equalsIgnoreCase(payMode)) {
                UploadResponse uploadResponse = UploadUtil.getInstance().uploadAttachment(paymentInfo);
                if (uploadResponse.getUploadState() == UploadState.NOT_EXIST) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u8d27\u5230\u4ed8\u6b3e\u65f6,\u9700\u4e0a\u4f20\u300a\u4f01\u4e1a\u62a5\u5173\u6838\u9a8c\u4fe1\u606f\u8868\u300b.xsl\u3002", (String)"TTPaymentImpl_0", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]), (String)"", (String)"");
                    return new EBBankPayResponse(paymentInfos);
                }
                if (uploadResponse.getUploadState() == UploadState.FAIL) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (String)"TTPaymentImpl_1", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]), (String)"", (String)"");
                    return new EBBankPayResponse(paymentInfos);
                }
                data.put("fileUploadCodes", uploadResponse.getFileUploadCodes());
            } else if ("02".equalsIgnoreCase(payMode)) {
                data.put("estimateDate", (Object)paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            boolean isoCurrency = CurrencyUtils.isISOCurrency((String)paymentInfo.getPayCurrency());
            data.put("remitCurCode", (Object)(isoCurrency ? paymentInfo.getPayCurrency() : CurrencyUtils.convert2Iso((String)paymentInfo.getPayCurrency())));
            data.put("totalAmt", (Object)paymentInfo.getAmount());
            data.put("transAmt", (Object)paymentInfo.getAmount());
            data.put("subTransCode", (Object)"121100");
            data.put("goods", (Object)"");
            data.put("remitAcc", (Object)paymentInfo.getAccNo());
            data.put("curRemitAmt", (Object)paymentInfo.getAmount().toPlainString());
            data.put("isAgent", (Object)(StringUtils.isEmpty((String)paymentInfo.getProxyAccNo()) ? "0" : "1"));
            data.put("agentAcc", (Object)paymentInfo.getProxyAccNo());
            data.put("agentBankSwiftCode", (Object)paymentInfo.getProxyBankSwiftCode());
            data.put("rcvSettleType", (Object)"SWIFT");
            data.put("rcvBankCode", (Object)paymentInfo.getIncomeSwiftCode());
            data.put("rcvCountryCode", (Object)payeeCode.getNumberCode());
            data.put("rcvName", (Object)paymentInfo.getIncomeAccName());
            data.put("rcvAddress", (Object)paymentInfo.getIncomeAddress());
            data.put("rcvAcc", (Object)paymentInfo.getIncomeAccNo());
            data.put("costPayer", (Object)paymentInfo.getIncomeAccNo());
            if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                data.put("costPayer", (Object)"OUR");
            } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                data.put("costPayer", (Object)"BEN");
            } else {
                data.put("costPayer", (Object)"SHA");
            }
            data.put("costAcc", (Object)paymentInfo.getPayerFeeAccNo());
            data.put("isFullPay", (Object)"1");
            data.put("paymentProp", (Object)this.getPaymentProp(paymentInfo.getPayAttribute()));
            data.put("contacts", (Object)paymentInfo.getApplyName());
            data.put("contactPhone", (Object)paymentInfo.getApplyPhone());
            data.put("payUnderFreeTax", (Object)(paymentInfo.isBondGoodsFlag() ? "1" : "0"));
            JSONArray easyContractDtl = new JSONArray();
            JSONObject easyContractDtlDto = new JSONObject();
            easyContractDtlDto.put("contractNo", (Object)paymentInfo.getContractNo());
            easyContractDtlDto.put("invoiceNo", (Object)paymentInfo.getInvoiceNo());
            easyContractDtl.add((Object)easyContractDtlDto);
            data.put("contractDtlList", (Object)easyContractDtl);
            data.put("postscript", (Object)paymentInfo.getTxPostscript());
            reqStr.put("Data", (Object)data);
            ret = NBBUtil.send("tmsForex", "easyRemitSubmit", reqStr.toJSONString(), this.getBizDesc());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        JSONObject retJson = JSONObject.parseObject((String)ret);
        JSONObject retData = retJson.getJSONObject("Data");
        String code = retData.getString("retCode");
        String msg = retData.getString("retMsg");
        if ("0000".equalsIgnoreCase(code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)msg, (String)"", (String)"");
        } else if (NBBUtil.retCodeMap.containsKey(code)) {
            if ("9999".equalsIgnoreCase(code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)NBBUtil.retCodeMap.get(code), (String)"", (String)msg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)NBBUtil.retCodeMap.get(code), (String)"", (String)msg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)NBBUtil.retCodeMap.get(code), (String)"", (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "tmsForex/easyRemitSubmit";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"T/T \u6c47\u6b3e\u63d0\u4ea4", (String)"", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String getPaymentProp(String fromBiz) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("A", "8");
        map.put("D", "7");
        map.put("E", "6");
        map.put("M", "1");
        map.put("O", "4");
        map.put("S", "3");
        map.put("X", "5");
        return map.getOrDefault(fromBiz, "");
    }
}

