/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.huifu.dc.service.Crypto;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest bankDetailRequest) {
        JSONObject req = new JSONObject();
        req.put("sys_id", (Object)"");
        req.put("product_id", (Object)"");
        JSONObject data = new JSONObject();
        data.put("acct_id", (Object)bankDetailRequest.getAcnt().getAccNo());
        data.put("acct_date", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        data.put("req_seq_id", (Object)Sequence.gen18Sequence());
        data.put("huifu_id", (Object)RequestContextUtils.getBankParameterValue((String)"hfId"));
        data.put("page_size", (Object)"100");
        this.setCurrentPage("0".equalsIgnoreCase(this.getCurrentPage()) ? "1" : this.getCurrentPage());
        data.put("page_num", (Object)this.getCurrentPage());
        String sign = Crypto.sign(data.clone());
        req.put("data", (Object)data);
        req.put("sign", (Object)sign);
        return req.toJSONString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1 + "");
        JSONObject resp = Crypto.verify(s);
        JSONArray acct_log_list = resp.getJSONArray("acct_log_list");
        this.setLastPage(acct_log_list.size() < 100);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        for (int i = 0; i < acct_log_list.size(); ++i) {
            JSONObject detail = acct_log_list.getJSONObject(i);
            DetailInfo detailInfo = new DetailInfo();
            String acct_log_id = detail.getString("acct_log_id");
            String acct_date = detail.getString("acct_date");
            String acct_trans_type = detail.getString("acct_trans_type");
            String debit_type = detail.getString("debit_type");
            BigDecimal trans_amt = detail.getBigDecimal(detail.getString("trans_amt"));
            BigDecimal balance_amt = detail.getBigDecimal("balance_amt");
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setBalance(balance_amt);
            if ("C".equalsIgnoreCase(debit_type)) {
                detailInfo.setCreditAmount(trans_amt);
                detailInfo.setDebitAmount(BigDecimal.ZERO);
            } else {
                detailInfo.setDebitAmount(trans_amt);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
            }
            detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
            LocalDate tDate = LocalDate.parse(acct_date + "00:00:00", DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss"));
            LocalDateTime tTime = tDate.atTime(0, 0, 0);
            detailInfo.setTransDate(tDate);
            detailInfo.setTransTime(tTime);
            detailInfo.setExplanation(acct_trans_type);
            detailInfo.setBankDetailNo(acct_log_id);
            JSONObject jsonMap = new JSONObject();
            jsonMap.put("acct_log_id", (Object)acct_log_id);
            detailInfo.setJsonMap(jsonMap.toJSONString());
            result.add(detailInfo);
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "/v2/trade/acctpayment/acctlog/query";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u52a1\u6d41\u6c34\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/v2/trade/acctpayment/acctlog/query");
    }

    public boolean isSupportPage() {
        return true;
    }
}

