/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.payment.otherbank.OtherBankPaymentImpl;
import kd.ebg.aqap.banks.gsb.dc.services.payment.salary.SalPaymentImpl;
import kd.ebg.aqap.banks.gsb.dc.services.payment.samebank.SamBkPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
implements IPretreat {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("accNo=").append(paymentInfo.getAccNo());
        packageKey.append(";");
        packageKey.append("sameBank=").append(paymentInfo.is2SameBank());
        packageKey.append(";");
        packageKey.append("urgent=").append(paymentInfo.is2Urgent());
        packageKey.append(";");
        String subBizType = paymentInfo.getSubBizType();
        if ("pay".equals(subBizType)) {
            if (paymentInfo.is2SameBank()) {
                busiImplInfo.setImplName(SamBkPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(OtherBankPaymentImpl.class.getName());
            }
        } else if ("pay_for_salary".equals(subBizType)) {
            busiImplInfo.setImplName(SalPaymentImpl.class.getName());
        } else {
            if (!"pay_for_capital_allocation".equals(subBizType)) throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
            if (!UseConvertor.isTransUp((PaymentInfo)paymentInfo) && !UseConvertor.isTransDown((PaymentInfo)paymentInfo)) throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%1$s\uff0c\u7528\u9014\u6709\u8bef%2$s\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), paymentInfo.getSubBizType(), paymentInfo.getUseCn()));
            if (paymentInfo.is2SameBank()) {
                busiImplInfo.setImplName(SamBkPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(OtherBankPaymentImpl.class.getName());
            }
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    public void appendData(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = this.getBusiImplInfo(paymentInfo);
        paymentInfo.setImplClassName(busiImplInfo.getImplName());
        paymentInfo.setQueryImplClassName(busiImplInfo.getQueryImplName());
        paymentInfo.setPackageKey(busiImplInfo.getPackageKey());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

