/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb.service.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opb.service.balance.BalanceImpl;
import kd.ebg.aqap.banks.gdb.opb.util.Packer;
import kd.ebg.aqap.banks.gdb.opb.util.Parser;
import kd.ebg.aqap.banks.gdb.opb.util.SendUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Header", (Object)Packer.createHeader(this.getBizCode()));
        JSONObject body = new JSONObject();
        jsonObject.put("Body", (Object)body);
        body.put("account", (Object)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo());
        body.put("ccyType", (Object)bankBalanceRequest.getBankCurrency());
        body.put("beginDate", (Object)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("endDate", (Object)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return jsonObject.toString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        Parser.parseHeader(jsonObject.getJSONObject("Header"), this.getBizDesc());
        JSONObject body = jsonObject.getJSONObject("Body");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if (!"000000".equals(sysRetCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21%1$s\u4e1a\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u8fd4\u56de\u7801:%2$s,\u5f02\u5e38\u4fe1\u606f\uff1a%3$s", (String)"HisBalanceImpl_4", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), this.getBizDesc(), sysRetCode, sysRetInfo);
            logger.info(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        JSONArray jsonArray = body.getJSONArray("acctHisBalanceList");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            BalanceInfo info = new BalanceInfo();
            balances.add(info);
            String balance = json.getString("balance");
            String ccyType = json.getString("ccyType");
            String balDate = json.getString("balDate");
            info.setCurrentBalance(new BigDecimal(balance));
            info.setAvailableBalance(new BigDecimal(balance));
            info.setBankCurrency(ccyType);
            info.setBankAcnt(bankBalanceRequest.getAcnt());
            info.setBalanceDateTime(LocalDateUtil.date2LocalDateTime((Date)DateUtil.string2Date((String)balDate, (String)"yyyyMMdd")));
        }
        return new EBBankBalanceResponse(balances);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "0028";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]);
    }
}

