/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb.util.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class SM2Util {
    private static final X9ECParameters sm2p256v1 = GMNamedCurves.getByName((String)"sm2p256v1");

    public static byte[] encrypt(byte[] publicKey, byte[] data) throws InvalidCipherTextException, IOException {
        if (publicKey.length == 64) {
            byte[] tmp = new byte[65];
            System.arraycopy(publicKey, 0, tmp, 1, publicKey.length);
            tmp[0] = 4;
            publicKey = tmp;
        }
        ECDomainParameters parameters = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());
        ECPublicKeyParameters pubKeyParameters = new ECPublicKeyParameters(sm2p256v1.getCurve().decodePoint(publicKey), parameters);
        SM2Engine engine = new SM2Engine();
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParameters, new SecureRandom());
        engine.init(true, (CipherParameters)pwr);
        byte[] cipher = engine.processBlock(data, 0, data.length);
        return SM2Util.encodeSM2CipherToDER(cipher);
    }

    public static byte[] encodeSM2CipherToDER(byte[] cipher) throws IOException {
        int startPos = 1;
        int curveLength = (sm2p256v1.getCurve().getFieldSize() + 7) / 8;
        int digestLength = 32;
        byte[] c1x = new byte[curveLength];
        System.arraycopy(cipher, startPos, c1x, 0, c1x.length);
        byte[] c1y = new byte[curveLength];
        System.arraycopy(cipher, startPos += c1x.length, c1y, 0, c1y.length);
        byte[] c2 = new byte[cipher.length - c1x.length - c1y.length - 1 - digestLength];
        System.arraycopy(cipher, startPos += c1y.length, c2, 0, c2.length);
        byte[] c3 = new byte[digestLength];
        System.arraycopy(cipher, startPos += c2.length, c3, 0, c3.length);
        ASN1Encodable[] arr = new ASN1Encodable[4];
        arr[0] = new ASN1Integer(new BigInteger(1, c1x));
        if (new BigInteger(1, c1x).toByteArray().length < 32) {
            System.out.println("");
        }
        arr[1] = new ASN1Integer(new BigInteger(1, c1y));
        arr[2] = new DEROctetString(c3);
        arr[3] = new DEROctetString(c2);
        DERSequence ds = new DERSequence(arr);
        return ds.getEncoded("DER");
    }
}

