/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.area;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.area.CMBArea;
import kd.ebg.aqap.banks.cmb.opa.area.CMBAreaComparator;
import kd.ebg.aqap.banks.cmb.opa.area.CardHandle;
import kd.ebg.aqap.business.account.atomic.ISyncAccount;
import kd.ebg.aqap.common.framework.utils.XlsUtlis;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.bank.info.EBBankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CMBStore
implements ISyncAccount {
    public static final String fileName = "cmbareacode.xls";
    public static final String[] areaRowNameArray = new String[]{"an", "bn", "cn", "dn", "en", "fn", "gn"};
    public static final String[] cardRowNameArray = new String[]{"an", "bn", "cn"};
    private static CMBArea[] areas;
    private static CMBArea[] provincialCapitals;
    private CardHandle[] cardsHandles;
    public static volatile CMBStore instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CMBStore getInstance() {
        if (null != instance) return instance;
        Class<CMBStore> clazz = CMBStore.class;
        synchronized (CMBStore.class) {
            if (null != instance) return instance;
            instance = new CMBStore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public CardHandle[] getCardTypes() {
        return this.cardsHandles;
    }

    public CMBStore() {
        String cn;
        String bn;
        String an;
        Map map;
        int i;
        int n;
        List resultList;
        String sheetName;
        ArrayList<CMBArea> provincialCapitalList = new ArrayList<CMBArea>(16);
        try {
            sheetName = PropertiesConstants.getValue((String)"CMB_AREA_TABLE");
            resultList = XlsUtlis.analysisXlsFile((String)fileName, (String[])areaRowNameArray, (String)sheetName, (boolean)true);
            n = resultList.size();
            areas = new CMBArea[n];
            for (i = 0; i < areas.length; ++i) {
                map = (Map)resultList.get(i);
                an = (String)map.get("an");
                bn = (String)map.get("bn");
                cn = (String)map.get("cn");
                String dn = (String)map.get("dn");
                String en = (String)map.get("en");
                String fn = (String)map.get("fn");
                String gn = (String)map.get("gn");
                String code = StringUtils.trim((String)an);
                String city = StringUtils.trim((String)bn);
                String province = StringUtils.trim((String)cn);
                String cityKeyword = StringUtils.trim((String)dn);
                String provinceKeyword = StringUtils.trim((String)en);
                String keywords = "";
                keywords = !StringUtils.isEmpty((String)provinceKeyword) ? provinceKeyword + "," + cityKeyword : cityKeyword;
                String branchBank = StringUtils.trim((String)fn);
                String branchBankCode = StringUtils.trim((String)gn);
                CMBStore.areas[i] = new CMBArea(code, city, province, cityKeyword, provinceKeyword, keywords, branchBank, branchBankCode);
                if (StringUtils.isEmpty((String)provinceKeyword)) continue;
                provincialCapitalList.add(areas[i]);
            }
        }
        catch (Exception t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
        provincialCapitals = provincialCapitalList.toArray(new CMBArea[0]);
        try {
            sheetName = PropertiesConstants.getValue((String)"CMB_ACC_TABLE");
            resultList = XlsUtlis.analysisXlsFile((String)fileName, (String[])cardRowNameArray, (String)sheetName, (boolean)true);
            n = resultList.size();
            this.cardsHandles = new CardHandle[n];
            for (i = 0; i < this.cardsHandles.length; ++i) {
                map = (Map)resultList.get(i);
                an = (String)map.get("an");
                bn = (String)map.get("bn");
                cn = (String)map.get("cn");
                int accNoLen = Integer.parseInt(an);
                String accNoPrefix = StringUtils.trim((String)bn);
                String address = StringUtils.trim((String)cn);
                this.cardsHandles[i] = new CardHandle(accNoLen, accNoPrefix, address);
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
        Arrays.sort(areas, new CMBAreaComparator());
    }

    public CMBArea matchCity(String address) {
        for (int i = 0; i < areas.length; ++i) {
            if (-1 == areas[i].getCityKeyword().indexOf(address)) continue;
            return areas[i];
        }
        return null;
    }

    public CMBArea matchProvince(String address) {
        for (int i = 0; i < provincialCapitals.length; ++i) {
            if (-1 == provincialCapitals[i].getProvinceKeyword().indexOf(address)) continue;
            return provincialCapitals[i];
        }
        return null;
    }

    public CMBArea matchAll(String address) {
        int i;
        if (address == null || address.length() == 0) {
            return null;
        }
        for (i = 0; i < areas.length; ++i) {
            if (-1 == areas[i].getCityKeyword().indexOf(address) && -1 == address.indexOf(areas[i].getCityKeyword())) continue;
            return areas[i];
        }
        for (i = 0; i < areas.length; ++i) {
            String[] keyWordsArr;
            for (String keyWords : keyWordsArr = areas[i].getKeywords().split(",")) {
                if (null == address || -1 == address.indexOf(keyWords) && -1 == keyWords.indexOf(address)) continue;
                return areas[i];
            }
        }
        String[] keyWordsArr = address.split(",");
        for (int i2 = keyWordsArr.length - 1; i2 >= 0; --i2) {
            for (int j = 0; j < areas.length; ++j) {
                if (!areas[j].getKeywords().contains(keyWordsArr[i2])) continue;
                return areas[j];
            }
        }
        return null;
    }

    public CMBArea match(String address) {
        CMBArea cmbArea = this.matchAll(address);
        if (cmbArea != null && StringUtils.isEmpty((String)cmbArea.getBranchBankCode())) {
            address = cmbArea.getProvince();
            cmbArea = this.matchProvince(address);
        }
        if (cmbArea != null && cmbArea.getBranchBankCode() != null) {
            return cmbArea;
        }
        return null;
    }

    public CMBArea getProvincialCapital(CMBArea area) {
        return this.matchProvince(area.getProvince());
    }

    public CardHandle matchCard(String accNo) {
        for (int i = 0; i < this.cardsHandles.length; ++i) {
            if (!this.cardsHandles[i].match(accNo)) continue;
            return this.cardsHandles[i];
        }
        return null;
    }

    public CMBArea matchBranchBank(String incomeBankName) {
        int index = incomeBankName.indexOf(PropertiesConstants.getValue((String)"BRANCH"));
        if (-1 != index) {
            incomeBankName = incomeBankName.substring(0, index);
        }
        for (int i = 0; i < areas.length; ++i) {
            int keyWordPiont;
            String branchBankName = areas[i].getBranchBank();
            if (StringUtils.isEmpty((String)branchBankName) || -1 == (keyWordPiont = incomeBankName.indexOf(branchBankName))) continue;
            if (incomeBankName.length() > (keyWordPiont += branchBankName.length()) + 1) {
                String nextKeyWord = incomeBankName.substring(keyWordPiont, keyWordPiont + 1);
                if (PropertiesConstants.getValue((String)"ROAD").equalsIgnoreCase(nextKeyWord) || PropertiesConstants.getValue((String)"STREET").equalsIgnoreCase(nextKeyWord)) continue;
                if (incomeBankName.length() > keyWordPiont + 2) {
                    nextKeyWord = incomeBankName.substring(keyWordPiont + 1, keyWordPiont + 2);
                    if (PropertiesConstants.getValue((String)"ROAD").equalsIgnoreCase(nextKeyWord) || PropertiesConstants.getValue((String)"STREET").equalsIgnoreCase(nextKeyWord)) continue;
                }
            }
            return areas[i];
        }
        return null;
    }

    public Map<String, String> getAreaCodeAndCnap(String bankCity) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        CMBArea area = this.match(bankCity);
        if (area != null) {
            result.put("AREACODE", area.getBranchBankCode());
            result.put("CNAP", area.getBranchBankCode());
        } else {
            result.put("AREACODE", "");
            result.put("CNAP", "");
        }
        return result;
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u94f6\u884c\u8d26\u53f7", (String)"CMBStore_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public EBBankResponse doBiz(BankRequest request) {
        return null;
    }

    public boolean match(BankRequest bankRequest) {
        return true;
    }
}

