/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.balancereconciliation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceStatementImpl.class);

    public int getMonthSpan() {
        return 12;
    }

    public EBBankBalanceStatementResponse doBiz(BankBalanceStatementRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceStatementRequest request) {
        JSONObject body = new JSONObject();
        JSONArray ntnstqryx = new JSONArray();
        JSONObject ntnstqryx1 = new JSONObject();
        ntnstqryx1.put("eacnbr", (Object)request.getAccNo());
        ntnstqryx1.put("busmod", (Object)"");
        ntnstqryx1.put("yermth", (Object)request.getStartMonth());
        ntnstqryx1.put("endmth", (Object)request.getEndMonth());
        ntnstqryx1.put("cntflg", (Object)"");
        ntnstqryx.add((Object)ntnstqryx1);
        body.put("ntnstqryx", (Object)ntnstqryx);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest request, String s) {
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(1);
        String res = MsgParser.getReceMsg(s, this.logger);
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"BalanceStatementImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject root = JSONObject.parseObject((String)res);
        JSONObject resp = root.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntnstqryx = body.getJSONArray("ntnstqryx");
        String eacnbr = ntnstqryx.getJSONObject(0).getString("eacnbr");
        if (!request.getAccNo().equals(eacnbr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7\u548c\u94f6\u884c\u54cd\u5e94\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"BalanceStatementImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONArray ntnstqryz = body.getJSONArray("ntnstqryz");
        if (ntnstqryz == null || ntnstqryz.size() == 0) {
            return new EBBankBalanceStatementResponse(detailList);
        }
        for (int i = 0; i < ntnstqryz.size(); ++i) {
            JSONObject obiect = ntnstqryz.getJSONObject(i);
            String bchnbr = obiect.getString("bchnbr");
            String barcod = obiect.getString("barcod");
            String yermth = obiect.getString("yermth");
            String barseq = obiect.getString("barseq");
            String actseq = obiect.getString("actseq");
            String accnbr = obiect.getString("accnbr");
            String ectflg = obiect.getString("ectflg");
            String stscod = obiect.getString("stscod");
            String balflg = obiect.getString("balflg");
            String actbal = obiect.getString("actbal");
            String ccynbr = obiect.getString("ccynbr");
            String eacnbr1 = obiect.getString("eacnbr");
            if (!eacnbr.equals(eacnbr1)) {
                this.logger.info("\u8fd4\u56de\u7684eacnbr-{}\u4e0e\u8d26\u53f7-{}\u4e0d\u4e00\u81f4\uff0c\u4e3a\u5b9a\u4fdd\u6237\u8bb0\u5f55\uff0c\u8fc7\u6ee4\u6389", new Object[]{eacnbr1, eacnbr});
                continue;
            }
            BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
            detail.setAccNo(eacnbr);
            detail.setCurrency(ccynbr);
            detail.setMonth(yermth);
            detail.setBalance(actbal);
            detail.setStatementNo(barcod);
            this.logger.info("\u8d26\u53f7{}\u5728\u6708\u4efd{}\u5e01\u79cd{}\u67e5\u8be2\u5230\u4f59\u989d{}", new Object[]{eacnbr, yermth, ccynbr, actbal});
            detail.setBiz("bchnbr", bchnbr);
            detail.setBiz("barseq", barseq);
            detail.setBiz("actseq", actseq);
            detail.setBiz("accnbr", accnbr);
            detailList.add(detail);
        }
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NTNSTQRY1";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7f51\u94f6\u5bf9\u8d26\u5f85\u7ecf\u529e\u6570\u636e\u67e5\u8be2\u3002", (String)"BalanceStatementImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest request) {
        return true;
    }
}

