/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.detail.TransQueryByBreakPoint_Z2;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TrsQryByBreakPointDetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TrsQryByBreakPointDetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        JSONObject jsonObjectBody = new JSONObject();
        JSONObject jsonObjectX1 = new JSONObject();
        jsonObjectX1.put("cardNbr", (Object)bankDetailRequest.getAcnt().getAccNo());
        jsonObjectX1.put("beginDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        jsonObjectX1.put("endDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        jsonObjectX1.put("currencyCode", (Object)bankDetailRequest.getBankCurrency());
        if (StringUtils.isNotEmpty((String)RequestContextUtils.getRunningParam((String)"queryAcctNbr"))) {
            jsonObjectX1.put("queryAcctNbr", (Object)RequestContextUtils.getRunningParam((String)"queryAcctNbr"));
        }
        JSONArray jsonArrayx1 = new JSONArray();
        jsonArrayx1.add((Object)jsonObjectX1);
        String transQueryByBreakPoint_y1 = RequestContextUtils.getRunningParam((String)"TRANSQUERYBYBREAKPOINT_Y1");
        if (StringUtils.isNotEmpty((String)transQueryByBreakPoint_y1)) {
            JSONArray y1 = JSONArray.parseArray((String)transQueryByBreakPoint_y1);
            jsonObjectBody.put("TRANSQUERYBYBREAKPOINT_Y1", (Object)y1);
        }
        jsonObjectBody.put("TRANSQUERYBYBREAKPOINT_X1", (Object)jsonArrayx1);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, jsonObjectBody);
        return MsgPacker.getSendMsg(req, logger, this.getBizCode());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        String res = MsgParser.getReceMsg(rspStr, logger);
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"TrsQryByBreakPointDetailImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        if (body == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587\u4f53body\u4e3a\u7a7a", (String)"TrsQryByBreakPointDetailImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONArray transQueryByBreakPoint_y1 = (JSONArray)body.get((Object)"TRANSQUERYBYBREAKPOINT_Y1");
        JSONArray transQueryByBreakPoint_z1 = (JSONArray)body.get((Object)"TRANSQUERYBYBREAKPOINT_Z1");
        if (transQueryByBreakPoint_z1 == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587TRANSQUERYBYBREAKPOINT_Z1\u4e3a\u7a7a", (String)"TrsQryByBreakPointDetailImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject z1 = (JSONObject)transQueryByBreakPoint_z1.get(0);
        if ("Y".equals(z1.get((Object)"ctnFlag")) && transQueryByBreakPoint_y1 != null) {
            this.setLastPage(false);
            RequestContextUtils.setRunningParam((String)"queryAcctNbr", (String)((String)z1.get((Object)"queryAcctNbr")));
            RequestContextUtils.setRunningParam((String)"TRANSQUERYBYBREAKPOINT_Y1", (String)transQueryByBreakPoint_y1.toJSONString());
        } else {
            this.setLastPage(true);
        }
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        JSONArray transQueryByBreakPoint_z2 = (JSONArray)body.get((Object)"TRANSQUERYBYBREAKPOINT_Z2");
        if (transQueryByBreakPoint_z2 == null) {
            logger.info("\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u660e\u7ec6\u4fe1\u606f");
            return new EBBankDetailResponse(detailInfos);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < transQueryByBreakPoint_z2.size(); ++i) {
            JSONObject jsonObject = (JSONObject)transQueryByBreakPoint_z2.get(i);
            TransQueryByBreakPoint_Z2 transQueryByBreakPoint_z21 = (TransQueryByBreakPoint_Z2)JSON.toJavaObject((JSON)jsonObject, TransQueryByBreakPoint_Z2.class);
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setBankDetailNo(transQueryByBreakPoint_z21.getTransSequenceIdn());
            String currencyNbr = transQueryByBreakPoint_z21.getCurrencyNbr();
            detailInfo.setCurrency(StringUtils.isNotEmpty((String)currencyNbr) ? currencyNbr : bankDetailRequest.getBankCurrency());
            if (StringUtils.isNotEmpty((String)transQueryByBreakPoint_z21.getAcctOnlineBal())) {
                detailInfo.setBalance(new BigDecimal(transQueryByBreakPoint_z21.getAcctOnlineBal()));
            }
            if (StringUtils.isNotEmpty((String)transQueryByBreakPoint_z21.getTransAmount())) {
                BigDecimal transAmount = new BigDecimal(transQueryByBreakPoint_z21.getTransAmount());
                String loanCode = transQueryByBreakPoint_z21.getLoanCode();
                if ("D".equalsIgnoreCase(loanCode)) {
                    detailInfo.setDebitAmount(transAmount.abs());
                    detailInfo.setCreditAmount(ParserUtils.ZERO);
                } else if ("C".equalsIgnoreCase(loanCode)) {
                    detailInfo.setCreditAmount(transAmount.abs());
                    detailInfo.setDebitAmount(ParserUtils.ZERO);
                } else {
                    logger.info("\u5f53\u524d\u660e\u7ec6\u501f\u8d37\u6807\u8bc6\u94f6\u884c\u8fd4\u56de{}\uff0c\u65e0\u6cd5\u8bc6\u522b", (Object)loanCode);
                    continue;
                }
            }
            String tranDate = transQueryByBreakPoint_z21.getTransDate();
            String transTime = transQueryByBreakPoint_z21.getTransTime();
            detailInfo.setTransDate(LocalDateUtil.parserDate((String)tranDate, (String)"yyyyMMdd"));
            if (StringUtils.isEmpty((String)transTime)) {
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(tranDate + "000000")));
            } else {
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(tranDate + transTime)));
            }
            detailInfo.setOppAccName(transQueryByBreakPoint_z21.getCtpAcctName());
            detailInfo.setOppAccNo(transQueryByBreakPoint_z21.getCtpAcctNbr());
            detailInfo.setOppBankName(transQueryByBreakPoint_z21.getCtpBankName());
            detailInfo.setExplanation(transQueryByBreakPoint_z21.getRemarkTextClt());
            jsonObject.put("etydat", (Object)transQueryByBreakPoint_z21.getTransDate());
            jsonObject.put("refnbr", (Object)transQueryByBreakPoint_z21.getTransSequenceIdn());
            this.parseKDFlagID(detailInfo, transQueryByBreakPoint_z21);
            try {
                String accNo = bankDetailRequest.getHeader().getAcnt().getAccNo();
                String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonObject.toJSONString());
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
            }
            catch (Throwable e) {
                logger.error(e.getMessage());
            }
            detailInfo.setJsonMap(jsonObject.toJSONString());
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public void parseKDFlagID(DetailInfo detailInfo, TransQueryByBreakPoint_Z2 object) {
        int index;
        String yurRef = object.getYurRef();
        if (StringUtils.isNotEmpty((String)yurRef) && (index = yurRef.indexOf("KD_")) > -1) {
            String kdFlagID = yurRef.substring(index + "KD_".length());
            detailInfo.setPayBankDetailSeqID(kdFlagID);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "trsQryByBreakPoint";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"TrsQryByBreakPointDetailImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        try {
            this.setLastPage(true);
            ArrayList detailInfos = new ArrayList(16);
            do {
                String rqstStr = this.pack(rqst);
                String rspStr = PostUtil.sendMsg(rqstStr);
                EBBankDetailResponse parse = this.parse(rqst, rspStr);
                detailInfos.addAll(parse.getDetails());
            } while (!this.isLastPage());
            return new EBBankDetailResponse(detailInfos);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5e38====" + e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public boolean match(BankDetailRequest request) {
        String accNoType = BankPropertyConfig.getAccNoType((String)request.getAcnt().getAccNo());
        return "normal".equalsIgnoreCase(accNoType) && BankBusinessConfig.isChooseTrsQryByBreakPoint();
    }
}

