/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.financing.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractQueryFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryFinancing;
import kd.ebg.aqap.business.financing.bank.BankQueryFinancingDetailRequest;
import kd.ebg.aqap.business.financing.bank.EBBankQueryFinancingDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingBankField;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryFinancingDetailImpl
extends AbstractQueryFinancingImpl
implements IQueryFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryFinancingDetailImpl.class);

    public EBBankQueryFinancingDetailResponse doBiz(BankQueryFinancingDetailRequest rqst) {
        ArrayList result = new ArrayList(1);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            result.addAll(this.parse(rqst, rspStr).getDetails());
        }
        return new EBBankQueryFinancingDetailResponse(result);
    }

    public String pack(BankQueryFinancingDetailRequest request) {
        if (StringUtils.isNotEmpty((String)request.getProductCode())) {
            return this.packFinancingDetail(request.getProductCode());
        }
        return this.packFinancingList();
    }

    public EBBankQueryFinancingDetailResponse parse(BankQueryFinancingDetailRequest request, String rspStr) {
        BankResponse response = MsgParser.getResponse(rspStr = MsgParser.getReceMsg(rspStr, this.logger), this.logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"QueryFinancingDetailImpl_28", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        if (StringUtils.isNotEmpty((String)request.getProductCode())) {
            return this.parseFinancingDetail(request, rspStr);
        }
        return this.parseFinancingList(request, rspStr);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NTQDILST,NTQDIDEF";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7406\u8d22\u5217\u8868\uff0c\u67e5\u8be2\u7406\u8d22\u8be6\u60c5\u3002", (String)"QueryFinancingDetailImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankQueryFinancingDetailRequest bankQueryFinancingDetailRequest) {
        return true;
    }

    private String packFinancingList() {
        JSONObject body = new JSONObject();
        JSONObject ntqdilstx = new JSONObject();
        ntqdilstx.put("accnbr", (Object)"");
        ntqdilstx.put("qryccy", (Object)"");
        ntqdilstx.put("qryrtn", (Object)"");
        ntqdilstx.put("qrytpy", (Object)"");
        String cntkey = RequestContextUtils.getRunningParam((String)"cntkey");
        ntqdilstx.put("cntkey", (Object)(StringUtils.isEmpty((String)cntkey) ? "" : cntkey));
        body.put("ntqdilstx", (Object)ntqdilstx);
        String bizCode = "NTQDILST";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    private EBBankQueryFinancingDetailResponse parseFinancingList(BankQueryFinancingDetailRequest request, String rspStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        JSONObject resp = jsonObject.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqdilstx = body.getJSONArray("ntqdilstx");
        if (ntqdilstx == null || ntqdilstx.size() == 0) {
            this.setLastPage(true);
        } else {
            String cntkey = ntqdilstx.getJSONObject(0).getString("cntkey");
            if (StringUtils.isNotEmpty((String)cntkey)) {
                RequestContextUtils.setRunningParam((String)"cntkey", (String)cntkey);
            } else {
                this.setLastPage(true);
            }
        }
        JSONArray ntqdidefz = body.getJSONArray("ntqdilstz");
        ArrayList<FinancingProductDetail> detailList = new ArrayList<FinancingProductDetail>(1);
        if (ntqdidefz == null || ntqdidefz.size() == 0) {
            return new EBBankQueryFinancingDetailResponse(detailList);
        }
        for (int i = 0; i < ntqdidefz.size(); ++i) {
            FinancingProductDetail detail = new FinancingProductDetail();
            detailList.add(detail);
            JSONObject obiect = ntqdidefz.getJSONObject(i);
            String ripcod = obiect.getString("ripcod");
            String namsnm = obiect.getString("namsnm");
            String ccynbr = obiect.getString("ccynbr");
            String maacod = obiect.getString("maacod");
            String begdat = obiect.getString("begdat");
            String enddat = obiect.getString("enddat");
            String redctl = obiect.getString("redctl");
            String purctl = obiect.getString("purctl");
            String sbsctl = obiect.getString("sbsctl");
            String bnsctl = obiect.getString("bnsctl");
            String rsklvl = obiect.getString("rsklvl");
            String navntv = obiect.getString("navntv");
            String navdat = obiect.getString("navdat");
            String tercod = obiect.getString("tercod");
            String prfrat = obiect.getString("prfrat");
            String terday = obiect.getString("terday");
            String riptyp = obiect.getString("riptyp");
            detail.setBankLoginID(request.getBankLoginID());
            detail.setBankVersionID(request.getBankVersionID());
            detail.setProductCode(ripcod);
            detail.setProductName(namsnm);
            detail.setCurrency(ccynbr);
            detail.setPublishStartDate(StringUtils.isNotEmpty((String)begdat) ? LocalDate.parse(begdat, DateTimeFormatter.ofPattern("yyyyMMdd")) : null);
            detail.setPublishEndDate(StringUtils.isNotEmpty((String)enddat) ? LocalDate.parse(enddat, DateTimeFormatter.ofPattern("yyyyMMdd")) : null);
            detail.setBuyPrice(navntv);
            detail.setRedeemMax(null);
            detail.setRedeemMin(null);
            detail.setRiskLev(rsklvl);
            ArrayList<FinancingBankField> bankFields = new ArrayList<FinancingBankField>(16);
            bankFields.add(new FinancingBankField("maacod", maacod, ResManager.loadKDString((String)"\u4ee3\u7406\u673a\u6784", (String)"QueryFinancingDetailImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("redctl", redctl, ResManager.loadKDString((String)"\u8d4e\u56de\u63a7\u5236", (String)"QueryFinancingDetailImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("purctl", purctl, ResManager.loadKDString((String)"\u7533\u8d2d\u63a7\u5236", (String)"QueryFinancingDetailImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("sbsctl", sbsctl, ResManager.loadKDString((String)"\u8ba4\u8d2d\u63a7\u5236", (String)"QueryFinancingDetailImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("bnsctl", bnsctl, ResManager.loadKDString((String)"\u5206\u7ea2\u63a7\u5236", (String)"QueryFinancingDetailImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("navdat", navdat, ResManager.loadKDString((String)"\u4ef7\u683c\u65e5\u671f", (String)"QueryFinancingDetailImpl_7", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("tercod", tercod, ResManager.loadKDString((String)"\u8ba4\u8d2d\u671f\u6807", (String)"QueryFinancingDetailImpl_8", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("prfrat", prfrat, ResManager.loadKDString((String)"\u9884\u671f\u6536\u76ca", (String)"QueryFinancingDetailImpl_9", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("terday", terday, ResManager.loadKDString((String)"\u4ea7\u54c1\u671f\u9650", (String)"QueryFinancingDetailImpl_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("riptyp", riptyp, ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b", (String)"QueryFinancingDetailImpl_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
            detail.setBankFields(bankFields);
        }
        return new EBBankQueryFinancingDetailResponse(detailList);
    }

    private String packFinancingDetail(String productCode) {
        JSONObject body = new JSONObject();
        JSONObject ntqdidefx = new JSONObject();
        ntqdidefx.put("ripcod", (Object)productCode);
        String bizCode = "NTQDIDEF";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        body.put("ntqdidefx", (Object)ntqdidefx);
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    private EBBankQueryFinancingDetailResponse parseFinancingDetail(BankQueryFinancingDetailRequest request, String rspStr) {
        this.setLastPage(true);
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        JSONObject resp = jsonObject.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqdidefz = body.getJSONArray("ntqdidefz");
        ArrayList<FinancingProductDetail> detailList = new ArrayList<FinancingProductDetail>(1);
        if (ntqdidefz == null || ntqdidefz.size() == 0) {
            return new EBBankQueryFinancingDetailResponse(detailList);
        }
        JSONObject obiect = ntqdidefz.getJSONObject(0);
        String ripcod = obiect.getString("ripcod");
        if (!request.getProductCode().equals(ripcod)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u4ea7\u54c1\u4ee3\u7801%1$s\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u4ea7\u54c1\u4ee3\u7801%2$s\u4e0d\u4e00\u81f4\u3002", (String)"QueryFinancingDetailImpl_29", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), request.getProductCode(), ripcod));
        }
        FinancingProductDetail detail = new FinancingProductDetail();
        detailList.add(detail);
        String namsnm = obiect.getString("namsnm");
        String ccynbr = obiect.getString("ccynbr");
        String maacod = obiect.getString("maacod");
        String begdat = obiect.getString("begdat");
        String enddat = obiect.getString("enddat");
        String redctl = obiect.getString("redctl");
        String purctl = obiect.getString("purctl");
        String sbsctl = obiect.getString("sbsctl");
        String bnsctl = obiect.getString("bnsctl");
        String qtybas = obiect.getString("qtybas");
        String qtyhig = obiect.getString("qtyhig");
        String qtylow = obiect.getString("qtylow");
        String sbsbdt = obiect.getString("sbsbdt");
        String sbsedt = obiect.getString("sbsedt");
        String sbsprc = obiect.getString("sbsprc");
        String navntv = obiect.getString("navntv");
        String navdat = obiect.getString("navdat");
        String purbdt = obiect.getString("purbdt");
        String puredt = obiect.getString("puredt");
        String redbdt = obiect.getString("redbdt");
        String rededt = obiect.getString("rededt");
        String bnscnt = obiect.getString("bnscnt");
        String bnsamt = obiect.getString("bnsamt");
        String bnsqty = obiect.getString("bnsqty");
        String redhig = obiect.getString("redhig");
        String redlow = obiect.getString("redlow");
        detail.setBankVersionID(request.getBankVersionID());
        detail.setBankLoginID(request.getBankLoginID());
        detail.setProductCode(request.getProductCode());
        detail.setProductName(namsnm);
        detail.setCurrency(ccynbr);
        detail.setPublishStartDate(StringUtils.isNotEmpty((String)begdat) ? LocalDate.parse(begdat, DateTimeFormatter.ofPattern("yyyyMMdd")) : null);
        detail.setPublishEndDate(StringUtils.isNotEmpty((String)enddat) ? LocalDate.parse(enddat, DateTimeFormatter.ofPattern("yyyyMMdd")) : null);
        detail.setBuyPrice(navntv);
        detail.setRedeemMax(redhig);
        detail.setRedeemMin(redlow);
        detail.setRiskLev(null);
        ArrayList<FinancingBankField> bankFields = new ArrayList<FinancingBankField>(16);
        bankFields.add(new FinancingBankField("maacod", maacod, ResManager.loadKDString((String)"\u4ee3\u7406\u673a\u6784", (String)"QueryFinancingDetailImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("redctl", redctl, ResManager.loadKDString((String)"\u8d4e\u56de\u63a7\u5236", (String)"QueryFinancingDetailImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("purctl", purctl, ResManager.loadKDString((String)"\u7533\u8d2d\u63a7\u5236", (String)"QueryFinancingDetailImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("sbsctl", sbsctl, ResManager.loadKDString((String)"\u8ba4\u8d2d\u63a7\u5236", (String)"QueryFinancingDetailImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("bnsctl", bnsctl, ResManager.loadKDString((String)"\u5206\u7ea2\u63a7\u5236", (String)"QueryFinancingDetailImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("qtybas", qtybas, ResManager.loadKDString((String)"\u4ea4\u6613\u4efd\u989d\u57fa\u6570", (String)"QueryFinancingDetailImpl_15", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("qtyhig", qtyhig, ResManager.loadKDString((String)"\u7533\u8d2d\u91d1\u989d\u4e0a\u9650", (String)"QueryFinancingDetailImpl_16", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("qtylow", qtylow, ResManager.loadKDString((String)"\u7533\u8d2d\u91d1\u989d\u4e0b\u9650", (String)"QueryFinancingDetailImpl_17", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("sbsbdt", sbsbdt, ResManager.loadKDString((String)"\u8ba4\u8d2d\u5f00\u59cb\u65e5\u671f", (String)"QueryFinancingDetailImpl_18", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("sbsedt", sbsedt, ResManager.loadKDString((String)"\u8ba4\u8d2d\u7ed3\u675f\u65e5\u671f", (String)"QueryFinancingDetailImpl_19", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("sbsprc", sbsprc, ResManager.loadKDString((String)"\u8ba4\u8d2d\u4ef7\u683c", (String)"QueryFinancingDetailImpl_20", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("navdat", navdat, ResManager.loadKDString((String)"\u4ef7\u683c\u65e5\u671f", (String)"QueryFinancingDetailImpl_7", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("purbdt", purbdt, ResManager.loadKDString((String)"\u7533\u8d2d\u5f00\u59cb\u65e5\u671f", (String)"QueryFinancingDetailImpl_21", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("puredt", puredt, ResManager.loadKDString((String)"\u7533\u8d2d\u7ed3\u675f\u65e5\u671f", (String)"QueryFinancingDetailImpl_22", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("redbdt", redbdt, ResManager.loadKDString((String)"\u8d4e\u56de\u5f00\u59cb\u65e5\u671f", (String)"QueryFinancingDetailImpl_23", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("rededt", rededt, ResManager.loadKDString((String)"\u8d4e\u56de\u7ed3\u675f\u65e5\u671f", (String)"QueryFinancingDetailImpl_24", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("bnscnt", bnscnt, ResManager.loadKDString((String)"\u7d2f\u8ba1\u5206\u7ea2\u6b21\u6570", (String)"QueryFinancingDetailImpl_25", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("bnsamt", bnsamt, ResManager.loadKDString((String)"\u7d2f\u8ba1\u5206\u7ea2\u91d1\u989d", (String)"QueryFinancingDetailImpl_26", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        bankFields.add(new FinancingBankField("bnsqty", bnsqty, ResManager.loadKDString((String)"\u7d2f\u8ba1\u5206\u7ea2\u4efd\u989d", (String)"QueryFinancingDetailImpl_27", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0])));
        detail.setBankFields(bankFields);
        return new EBBankQueryFinancingDetailResponse(detailList);
    }
}

