/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.salary.individual;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.salary.individual.BB6BTHHLBody;
import kd.ebg.aqap.banks.cmb.opa.service.payment.salary.individual.QueryIndividualPaymentImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class IndividualPaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(IndividualPaymentImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryIndividualPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BB6BTHHLBody.Busmod busmod = new BB6BTHHLBody.Busmod();
        String buscode = UseConvertor.isSalary((PaymentInfo)((PaymentInfo)paymentInfos.get(0))) ? "N03010" : "N03020";
        String busMod = BankBusinessConfig.getBB6BTHHLBusmod(((PaymentInfo)paymentInfos.get(0)).getAccNo());
        if (StringUtils.isEmpty((String)busMod)) {
            this.logger.info("\u94f6\u4f01\u672a\u7ef4\u62a4\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\uff0c\u4ece\u94f6\u884c\u83b7\u53d6");
            busMod = BusModUtil.getBusMod(buscode);
            String busModName = ResManager.loadKDString((String)"\u4ee3\u53d1\u7ecf\u529eBB6BTHHL\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7", (String)"IndividualPaymentImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)busMod)) {
                throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"%s\u4e3a\u7a7a\uff0c\u8bf7\u767b\u9646\u7f51\u94f6\u6216\u8005\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"IndividualPaymentImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName));
            }
            if (busMod.contains(",")) {
                throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"%1$s\u6709\u591a\u4e2a%2$s\uff0c\u8bf7\u4e8e\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u4e2d\u624b\u52a8\u914d\u7f6e\u552f\u4e00\u7684\u2018%3$s\u2019\u3002", (String)"IndividualPaymentImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), busModName, busMod, busModName));
            }
            ObjectPropertyService objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
            objectPropertyService.saveAcntProperties("cmb_cmp_NTAGCSAL_busmod", busMod, ((PaymentInfo)paymentInfos.get(0)).getAccNo());
        }
        busmod.setBusmod(busMod);
        busmod.setBuscod(buscode);
        ArrayList<BB6BTHHLBody.Busmod> busmodLists = new ArrayList<BB6BTHHLBody.Busmod>(16);
        busmodLists.add(busmod);
        BB6BTHHLBody.Cdcbhx1 cdcbhx1 = new BB6BTHHLBody.Cdcbhx1();
        cdcbhx1.setBegtag("Y");
        cdcbhx1.setEndtag("Y");
        cdcbhx1.setAccnam(((PaymentInfo)paymentInfos.get(0)).getAccName());
        cdcbhx1.setAccnbr(((PaymentInfo)paymentInfos.get(0)).getAccNo());
        cdcbhx1.setTtlamt(((PaymentInfo)paymentInfos.get(0)).getTotalAmount().setScale(2).toString());
        cdcbhx1.setTtlcnt(Integer.toString(paymentInfos.size()));
        cdcbhx1.setTtlnum("1");
        cdcbhx1.setCuramt(((PaymentInfo)paymentInfos.get(0)).getTotalAmount().setScale(2).toString());
        cdcbhx1.setCurcnt(Integer.toString(paymentInfos.size()));
        cdcbhx1.setCcynbr(((PaymentInfo)paymentInfos.get(0)).getCurrency());
        cdcbhx1.setNusage(((PaymentInfo)paymentInfos.get(0)).getExplanation());
        LocalDateTime bookingTime = ((PaymentInfo)paymentInfos.get(0)).getBookingTime();
        if (bookingTime == null) {
            bookingTime = LocalDateTime.now();
        }
        cdcbhx1.setEptdat(bookingTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        cdcbhx1.setYurref(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        String useByKey = UseKeyWordService.getUseByKey((String)"", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation(), (String)"BB6BTHHL", (String)"BYBK", (String)"CMB_OPA");
        cdcbhx1.setChlflg(BankBusinessConfig.getSingleRouteChooseMap());
        cdcbhx1.setTrstyp(useByKey);
        ArrayList<BB6BTHHLBody.Cdcbhx1> cdcbhx1Lists = new ArrayList<BB6BTHHLBody.Cdcbhx1>();
        cdcbhx1Lists.add(cdcbhx1);
        ArrayList<BB6BTHHLBody.Cdcdlx1> cdcdlx1Lists = new ArrayList<BB6BTHHLBody.Cdcdlx1>(16);
        for (int i = 0; i < paymentInfos.size(); ++i) {
            BB6BTHHLBody.Cdcdlx1 cdcdlx1 = new BB6BTHHLBody.Cdcdlx1();
            String trxSeq = String.format("%08d", i + 1);
            cdcdlx1.setTrxseq(trxSeq);
            ((PaymentInfo)paymentInfos.get(i)).setBankRefID(trxSeq);
            cdcdlx1.setAccnam(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            cdcdlx1.setAccnbr(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            cdcdlx1.setTrsamt(((PaymentInfo)paymentInfos.get(i)).getAmount().setScale(2).toString());
            cdcdlx1Lists.add(cdcdlx1);
        }
        BB6BTHHLBody bb6BTHHLBody = new BB6BTHHLBody();
        bb6BTHHLBody.setBb6busmod(busmodLists);
        bb6BTHHLBody.setBb6cdcbhx1(cdcbhx1Lists);
        bb6BTHHLBody.setBb6cdcdlx1(cdcdlx1Lists);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, (JSONObject)JSONObject.toJSON((Object)bb6BTHHLBody));
        return MsgPacker.getSendMsg(request, this.logger, this.getBizCode());
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String rsqt;
        try {
            rsqt = this.pack(request);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u8fde\u63a5\u94f6\u884c\u524d\u5f02\u5e38:%s\u3002", (String)"IndividualPaymentImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
        }
        EBBankPayResponse response = null;
        try {
            String rspStr = PostUtil.sendMsgForPay(rsqt);
            response = this.parse(request, rspStr);
        }
        catch (Throwable t) {
            this.logger.error("\u4ed8\u6b3e\u5f02\u5e38{}", new Object[]{t.getMessage()});
            EBContext.getContext().setThrowableAfterSend(t);
            EBExceiptionUtil.serviceException((Throwable)t);
        }
        return response;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (rspStr.contains("ErrMsg")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)rspStr);
        } else {
            String res = MsgParser.getReceMsg(rspStr, this.logger);
            BankResponse response = MsgParser.getResponse(res, this.logger);
            if ("SUC0000".equalsIgnoreCase(response.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BB6BTHHL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u7ecf\u529e\u63a5\u53e3", (String)"IndividualPaymentImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

