/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        return this.parseBalanceResp(rqst, rspStr);
    }

    public EBBankBalanceResponse parseBalanceResp(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Namespace space;
        BankAcnt acnt = rqst.getAcnt();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", space = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", space);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", space);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"TodayBalanceParser_6", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        Namespace localNamespace = root.getNamespace();
        Element balance = root.getChild("balance", localNamespace);
        Element balanceRespond = balance.getChild("balanceRespond", localNamespace);
        Element balanceRespondBody = balanceRespond.getChild("balanceRespondBody", localNamespace);
        Element balanceRespondRecord = balanceRespondBody.getChild("balanceRespondRecord", localNamespace);
        Namespace namespace = balanceRespondRecord.getNamespace();
        String clientPatchID = balanceRespondRecord.getChildTextTrim("clientPatchID", namespace);
        String accountNo = balanceRespondRecord.getChildTextTrim("accountNo", namespace);
        String returnCode = balanceRespondRecord.getChildTextTrim("returnCode", namespace);
        String returnInfo = balanceRespondRecord.getChildTextTrim("returnInfo", namespace);
        String accountBalance = balanceRespondRecord.getChildTextTrim("accountBalance", namespace);
        String availableBalance = balanceRespondRecord.getChildTextTrim("availableBalance", namespace);
        if (!"0000".equalsIgnoreCase(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceParser_7", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{returnCode, returnInfo})));
        }
        if (!acnt.getAccNo().equalsIgnoreCase(accountNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u9519\u8bef :\u8fd4\u56de\u7684\u8d26\u53f7%1$s\u4e0d\u662f\u67e5\u8be2\u8d26\u53f7%2$s\u3002", (String)"TodayBalanceParser_8", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), accountNo, acnt.getAccNo()));
        }
        Object[] balances = new BalanceInfo[]{new BalanceInfo()};
        balances[0].setBankAcnt(acnt);
        if (StringUtils.isEmpty((String)accountBalance)) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"TodayBalanceParser_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            throw ex;
        }
        balances[0].setCurrentBalance(new BigDecimal(accountBalance));
        balances[0].setBalanceDateTime(LocalDateTime.now());
        balances[0].setBankCurrency(rqst.getBankCurrency());
        if (!StringUtils.isEmpty((String)availableBalance)) {
            balances[0].setAvailableBalance(new BigDecimal(availableBalance));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])balances));
    }
}

