/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayParser {
    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) {
        Namespace namespace;
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", namespace = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            if (StringUtils.isEmpty((String)ReturnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)ReturnMsg);
            }
            return;
        }
        Element TransHead = root.getChild("TransHead", namespace);
        String BatchID = TransHead.getChildTextTrim("BatchID", namespace);
        Element TransContent = root.getChild("TransContent", namespace);
        String ReturnCode = TransContent.getChildTextTrim("ReturnCode", namespace);
        String ReturnMsg = TransContent.getChildTextTrim("ReturnMsg", namespace);
        String parentAccountNo = TransContent.getChildTextTrim("parentAccountNo", namespace);
        String childAccountNo = TransContent.getChildTextTrim("childAccountNo", namespace);
        String ClientPatchID = TransContent.getChildTextTrim("ClientPatchID", namespace);
        PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)ClientPatchID);
        if (null == paymentInfo) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u987a\u5e8f\u53f7:ClientPatchID=%s\u3002", (String)"PayParser_4", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ClientPatchID));
        }
        if ("0000".equals(ReturnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayParser_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)ReturnCode, (String)ReturnMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)ReturnCode, (String)ReturnMsg);
        }
    }
}

