/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.services.payment.allocation.PayPacker;
import kd.ebg.aqap.banks.ceb.dc.services.payment.allocation.PayParser;
import kd.ebg.aqap.banks.ceb.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "b2e006021";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5212\u62e8\u652f\u4ed8", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/").append("b2e006021.do");
        sb.append('?');
        sb.append("usrID=").append(RequestContextUtils.getBankParameterValue((String)"UserID"));
        sb.append("&userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        sb.append("&Sigdata=1");
        factory.setUri(sb.toString());
        return factory;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return new PayPacker().packPay(bankPayRequest.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        new PayParser().parsePay(bankPayRequest.getPaymentInfoAsArray(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equals(paymentInfo.getSubBizType());
    }
}

