/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay;

import java.util.List;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayParser {
    public static EBBankPayResponse parsePay(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        PayParser.parserBatchPayAcceptInfo(paymentInfos, rspStr);
        return new EBBankPayResponse(paymentInfos);
    }

    private static void parserBatchPayAcceptInfo(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        Namespace namespace;
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", namespace = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            if (StringUtils.isEmpty((String)ReturnCode)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)ReturnMsg);
            }
            return;
        }
        Element TransContent = root.getChild("TransContent", namespace);
        String ReturnCode = "";
        String ReturnMsg = "";
        if (null == TransContent) {
            ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
        } else {
            ReturnCode = TransContent.getChildTextTrim("ReturnCode", namespace);
            ReturnMsg = TransContent.getChildTextTrim("ReturnMsg", namespace);
        }
        if ("0000".equalsIgnoreCase(ReturnCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)ReturnCode, (String)ReturnMsg);
        }
    }
}

