/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.individual;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ceb.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class IndividualPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "b2e004001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u652f\u4ed8", (String)"IndividualPaymentImpl_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.is2Individual();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Transaction");
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element SystemHead = JDomUtils.addChild((Element)root, (String)"SystemHead");
        JDomUtils.addChild((Element)SystemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)SystemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"CifNo", (String)BankUtils.getExclusiveCifNo(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)SystemHead, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"OperatorID"));
        JDomUtils.addChild((Element)SystemHead, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)SystemHead, (String)"Note", (String)"");
        Element TransHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)TransHead, (String)"TransCode", (String)"b2e004001");
        JDomUtils.addChild((Element)TransHead, (String)"BatchID", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)TransHead, (String)"JnlDate", (String)DateHelper.currentDate());
        JDomUtils.addChild((Element)TransHead, (String)"JnlTime", (String)DateHelper.currentTime());
        Element TransContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element ReqData = JDomUtils.addChild((Element)TransContent, (String)"ReqData");
        JDomUtils.addChild((Element)ReqData, (String)"ClientPatchID", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)ReqData, (String)"transferType", (String)(paymentInfo.is2SameBank() ? "2122" : "2120"));
        JDomUtils.addChild((Element)ReqData, (String)"accountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqData, (String)"toAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)ReqData, (String)"toAccountNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)ReqData, (String)"toBank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)ReqData, (String)"amount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)ReqData, (String)"toLocation", (String)"");
        JDomUtils.addChild((Element)ReqData, (String)"clientSignature", (String)"");
        JDomUtils.addChild((Element)ReqData, (String)"checkNo", (String)"");
        JDomUtils.addChild((Element)ReqData, (String)"checkPassword", (String)"");
        JDomUtils.addChild((Element)ReqData, (String)"bankNo", (String)"");
        JDomUtils.addChild((Element)ReqData, (String)"isUrgent", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)ReqData, (String)"cellphone", (String)"");
        JDomUtils.addChild((Element)ReqData, (String)"note", (String)BankUtils.convert(paymentInfo));
        JDomUtils.addChild((Element)ReqData, (String)"perOrEnt", (String)"1");
        if (BankBusinessConfig.isAuditPay()) {
            JDomUtils.addChild((Element)ReqData, (String)"IsAudit", (String)"1");
        } else {
            JDomUtils.addChild((Element)ReqData, (String)"IsAudit", (String)"0");
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            JDomUtils.addChild((Element)ReqData, (String)"noteOther", (String)BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)paymentInfo.getExplanation()));
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        } else {
            JDomUtils.addChild((Element)ReqData, (String)"noteOther", (String)paymentInfo.getExplanation());
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        Namespace namespace;
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", namespace = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            if (StringUtils.isEmpty((String)ReturnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)ReturnMsg);
            }
            return new EBBankPayResponse(paymentInfos);
        }
        Element TransHead = root.getChild("TransHead", namespace);
        String BatchID = TransHead.getChildTextTrim("BatchID", namespace);
        Element TransContent = root.getChild("TransContent", namespace);
        String ReturnCode = TransContent.getChildTextTrim("ReturnCode", namespace);
        String ReturnMsg = TransContent.getChildTextTrim("ReturnMsg", namespace);
        Element RespData = TransContent.getChild("RespData", namespace);
        String ClientPatchID = RespData.getChildTextTrim("ClientPatchID", namespace);
        String accountNo = RespData.getChildTextTrim("accountNo", namespace);
        PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)ClientPatchID);
        if (null == paymentInfo) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u987a\u5e8f\u53f7:ClientPatchID=%s\u3002", (String)"IndividualPaymentImpl_3", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ClientPatchID));
        }
        if ("0000".equalsIgnoreCase(ReturnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)ReturnCode, (String)ReturnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder builder = new StringBuilder();
        builder.append("/ent/b2e004001.do").append("?usrID=").append(RequestContextUtils.getBankParameterValue((String)"UserID")).append("&userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword")).append("&Sigdata=").append("1");
        factory.setUri(builder.toString());
        return factory;
    }
}

