/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.ca.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import kd.ebg.aqap.formplugin.ca.bean.CertAndKeyGen;
import kd.ebg.aqap.formplugin.ca.bean.KeyStoreInfo;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import sun.security.x509.X500Name;

public class DigitalCertificateGenerator {
    public static final String KEY_STORE_TYPE_JKS = "jks";
    public static final String KEY_STORE_TYPE_PKCS12 = "pkcs12";
    public static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final String SECURE_RANDOM_PROVIDER = "SUN";
    public static final String SIGN_ALGORITHM_SHA256 = "sha256WithRSA";
    public static final String SIGN_ALGORITHM_MD5 = "MD5WithRSA";
    public static final String KEY_PAIR_ALGORITHM_RSA = "RSA";

    public static void exportJKSPublicKeyCertificate(String keyStorePathAndFileName, String keyStorePass, String alias, String exportPathAndFileName) {
        DigitalCertificateGenerator.exportPublicKeyCertificate(keyStorePathAndFileName, keyStorePass, KEY_STORE_TYPE_JKS, alias, exportPathAndFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportPublicKeyCertificate(String keyStorePathAndFileName, String keyStorePass, String keyStoreType, String alias, String exportPathAndFileName) {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            fis = new FileInputStream(FileCommonUtils.checkPath((String)keyStorePathAndFileName));
            ks.load(fis, keyStorePass.toCharArray());
            Certificate cert = ks.getCertificate(alias);
            fos = new FileOutputStream(FileCommonUtils.checkPath((String)exportPathAndFileName));
            fos.write(cert.getEncoded());
            fos.flush();
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void generateJKS(KeyStoreInfo certInfo) {
        DigitalCertificateGenerator.generateDigitalCert(KEY_STORE_TYPE_JKS, SIGN_ALGORITHM_SHA256, KEY_PAIR_ALGORITHM_RSA, SECURE_RANDOM_ALGORITHM, SECURE_RANDOM_PROVIDER, certInfo.getAlias(), certInfo.getKeyStorePass(), certInfo.getCertPass(), certInfo.getCN(), certInfo.getOU(), certInfo.getO(), certInfo.getL(), certInfo.getST(), certInfo.getC(), certInfo.getStart(), certInfo.getValidityDays(), certInfo.getPathAndFileName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDigitalCert(String keyStoreType, String signAlgorithm, String keyPairAlgorithm, String secureRandomAlgorithm, String secureRandomProvider, String alias, String keyStorePass, String certPass, String CN, String OU, String O, String L, String ST, String C, Date start, long validityDays, String pathAndFileName, boolean createNew) {
        FileOutputStream out = null;
        try {
            SecureRandom sr = SecureRandom.getInstance(secureRandomAlgorithm, secureRandomProvider);
            CertAndKeyGen cakg = new CertAndKeyGen(keyPairAlgorithm, signAlgorithm);
            cakg.setRandom(sr);
            cakg.generate(2048);
            X500Name subject = new X500Name("CN=" + CN + ",OU=" + OU + ",O=" + O + ",L=" + L + ",ST=" + ST + ",C=" + C);
            X509Certificate certificate = cakg.getSelfCertificate(subject, start, validityDays * 24L * 60L * 60L);
            KeyStore outStore = KeyStore.getInstance(keyStoreType);
            outStore.load(null, keyStorePass.toCharArray());
            outStore.setKeyEntry(alias, cakg.getPrivateKey(), certPass.toCharArray(), new Certificate[]{certificate});
            out = new FileOutputStream(FileCommonUtils.checkPath((String)pathAndFileName));
            outStore.store(out, keyStorePass.toCharArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (SignatureException signatureException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException iOException) {}
        }
    }
}

