/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CertBdListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_KEY = "aqap_bd_cert";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (this.getPageCache().get("isFirstInit") == null && !CollectionUtils.isEmpty((Map)paramMap) && paramMap.get("certId") != null) {
            e.getQFilters().clear();
            e.getQFilters().add(new QFilter("id", "=", (Object)Long.parseLong((String)paramMap.get("certId"))));
            this.getPageCache().put("isFirstInit", "false");
        } else {
            List qFilters = e.getQFilters();
            if (!CollectionUtils.isEmpty((Collection)qFilters)) {
                ListIterator qFilterIterator = qFilters.listIterator();
                while (qFilterIterator.hasNext()) {
                    QFilter qFilter = (QFilter)qFilterIterator.next();
                    if (!"cert_status".equalsIgnoreCase(qFilter.getProperty())) continue;
                    QFilter newqFilter = "1".equalsIgnoreCase((String)qFilter.getValue()) ? QFilter.of((String)"expire_time < ?", (Object[])new Object[]{new Date()}) : QFilter.of((String)"expire_time >= ?", (Object[])new Object[]{new Date()});
                    qFilterIterator.remove();
                    qFilters.add(newqFilter);
                    e.setQFilters(qFilters);
                    break;
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!fieldName.equalsIgnoreCase("cert_type") || paramMap.get("cert_type") == null) continue;
                commonFilterColumn.setDefaultValue((String)paramMap.get("cert_type"));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection result = super.getData(start, limit);
                if (!CollectionUtils.isEmpty((Collection)result)) {
                    Date now = new Date();
                    int row = start;
                    for (DynamicObject dy : result) {
                        Date expireTime = dy.getDate("expire_time");
                        if (expireTime == null) {
                            dy.set("cert_status", (Object)"2");
                        } else if (DateUtil.isBefore((Date)expireTime, (Date)now)) {
                            dy.set("cert_status", (Object)"1");
                        } else {
                            dy.set("cert_status", (Object)"2");
                        }
                        dy.set("row_num", (Object)row++);
                        if (!StringUtils.isEmpty((String)dy.getString("mobiles"))) continue;
                        dy.set("is_alert", (Object)false);
                    }
                }
                return result;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        Object obj = evt.getSource();
        DynamicObject rowData = evt.getRowData();
        int status = rowData.getInt("cert_status");
        int seq = rowData.getInt("row_num");
        if (obj instanceof ComboColumnDesc && "cert_status".equals(((ComboColumnDesc)obj).getKey())) {
            if (1 == status) {
                this.setListUnitStyle(seq, "#FB2323");
            } else if (2 == status) {
                this.setListUnitStyle(seq, "#1BA854");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List<Long> ids;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)"cert_setting", (String)operateKey)) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                ArrayList ids2 = new ArrayList(16);
                listSelectedRowCollection.forEach(selectedRow -> ids2.add((Long)selectedRow.getPrimaryKeyValue()));
                HashMap<String, Object> customParams = new HashMap<String, Object>(16);
                customParams.put("ids", ids2);
                ShowPageUtil.showFormPage("aqap_cert_setting", customParams, OperationStatus.ADDNEW, this.getView(), (IFormPlugin)this);
            }
        } else if (StringUtils.equals((String)"add_other_cert", (String)operateKey)) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("type", "add");
            ShowPageUtil.showFormPage("aqap_other_cert_setting", customParams, OperationStatus.ADDNEW, this.getView(), (IFormPlugin)this);
        } else if (StringUtils.equals((String)"delete_other_cert", (String)operateKey)) {
            List<Long> ids3 = this.getSelectIds(args);
            if (!CollectionUtils.isEmpty(ids3)) {
                QFilter qFilter = new QFilter("id", "in", ids3);
                QFilter[] filters = new QFilter[]{QFilter.of((String)"cert_source != '1'", (Object[])new Object[0]), qFilter};
                boolean existsOtherCert = QueryServiceHelper.exists((String)ENTITY_KEY, (QFilter[])filters);
                if (existsOtherCert) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5bfc\u5165\u8bc1\u4e66\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CertBdListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DeleteServiceHelper.delete((String)ENTITY_KEY, (QFilter[])qFilter.toArray());
                args.setCancel(true);
                String message = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CertBdListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(message);
                this.getView().invokeOperation("refresh");
                OperationLogUtil.recordInvoke((String)"aqap", (FormOperate)formOperate, (MultiLangEnumBridge)OperationLogUtil.getMultiLangEnumBridge((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CertBdListPlugin_1", (String)"ebg-aqap-formplugin"));
            }
        } else if (StringUtils.equals((String)"update_other_cert", (String)operateKey) && !CollectionUtils.isEmpty(ids = this.getSelectIds(args))) {
            if (ids.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CertBdListPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            QFilter[] filters = new QFilter[]{QFilter.of((String)"cert_source != '1'", (Object[])new Object[0]), qFilter};
            boolean existsOtherCert = QueryServiceHelper.exists((String)ENTITY_KEY, (QFilter[])filters);
            if (existsOtherCert) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u624b\u5de5\u65b0\u589e\u7684\u8bc1\u4e66\u3002", (String)"CertBdListPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("type", "update");
            customParams.put("id", ids.get(0));
            ShowPageUtil.showFormPage("aqap_other_cert_setting", customParams, OperationStatus.EDIT, this.getView(), (IFormPlugin)this);
        }
    }

    public List<Long> getSelectIds(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> ids.add((Long)selectedRow.getPrimaryKeyValue()));
        }
        return ids;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Boolean re;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && (re = (Boolean)closedCallBackEvent.getReturnData()).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"CertBdListPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void setListUnitStyle(int row, String color) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("cert_status");
        cellStyle.setRow(row);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setCellStyle(cellStyles);
    }
}

