/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.DetailExtraField;
import kd.ebg.aqap.common.model.repository.DetailExtraFieldRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class updateExtraFieldPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private DetailExtraFieldRepository detailExtraFieldRepository = (DetailExtraFieldRepository)SpringContextUtil.getBean(DetailExtraFieldRepository.class);
    private BankVersionRepository bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("btn_save".equals(formOperate.getOperateKey())) {
            this.saveData(args);
        }
    }

    void setDefaultDataWhenUpdate() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String bankVersionIDAndExtraField = paramMap.get("number").toString();
        List tmp = this.detailExtraFieldRepository.findByNumber(bankVersionIDAndExtraField);
        DetailExtraField detailExtraField = (DetailExtraField)tmp.get(0);
        String p = detailExtraField.getDetail_interface();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(p), p));
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        comboEdit.setComboItems(data);
        this.getModel().getDataEntity().set("combofield", (Object)p);
        IDataModel entryOperate = this.getModel();
        entryOperate.deleteEntryData("entryentity");
        int row = entryOperate.createNewEntryRow("entryentity");
        this.getModel().setValue("extra_field", (Object)detailExtraField.getExtra_field(), row);
        this.getModel().setValue("description", (Object)detailExtraField.getDes(), row);
    }

    void saveData(BeforeDoOperationEventArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String bankVersionID = paramMap.get("bankVersionID").toString();
        String bankVersionIdAndExtraField = paramMap.get("number").toString();
        boolean right = this.isRight(bankVersionID, args);
        if (right) {
            this.deleteOne(bankVersionIdAndExtraField);
            this.save(bankVersionID);
            this.getView().showTipNotification(MultiLang.getAddNewSuccessTip());
        }
    }

    void save(String bankVersionID) {
        String customID = RequestContext.get().getTenantId();
        String modifier = RequestContext.get().getUserName();
        String detailInterface = (String)this.getModel().getValue("combofield");
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"detail_extra_field_r");
        IDataModel entryOperate = this.getModel();
        DynamicObjectCollection collection = entryOperate.getEntryEntity("entryentity");
        DynamicObject d = (DynamicObject)collection.get(0);
        String finalField = d.getString("extra_field");
        String des = d.getString("description");
        dataEntity.set("number", (Object)(bankVersionID + "|" + finalField));
        dataEntity.set("group", (Object)this.bankVersionRepository.loadDynamicObjectByBankVersionID(bankVersionID));
        dataEntity.set("detail_interface", (Object)detailInterface);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("extra_field", (Object)finalField);
        dataEntity.set("description", (Object)des);
        dataEntity.set("spare", (Object)"");
        dataEntity.set("updatename", (Object)modifier);
        dataEntity.set("modifytime", (Object)new Date());
        DynamicObject[] dataEntities = new DynamicObject[]{dataEntity};
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private boolean isRight(String bankVersionID, BeforeDoOperationEventArgs args) {
        String combofield = (String)this.getModel().getDataEntity().get("combofield");
        if (StringUtil.isNil(combofield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u5fc5\u9009\u3002", (String)"updateExtraFieldPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (this.isRepeat(bankVersionID).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6269\u5c55\u5b57\u6bb5\u91cd\u590d\u3002", (String)"updateExtraFieldPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    void deleteOne(String bankversionidAndExtraField) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bankversionidAndExtraField)};
        DeleteServiceHelper.delete((String)"detail_extra_field_r", (QFilter[])qFilters);
    }

    private Boolean isRepeat(String bankVersionID) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", 0);
        String number = bankVersionID + "|" + dynamicObject.getString("extra_field");
        if (operationStatus == OperationStatus.ADDNEW) {
            List result = this.detailExtraFieldRepository.findByNumber(number);
            return result.size() > 0;
        }
        String id = this.getPageCache().get("id");
        DynamicObject itemDynamicObject = this.detailExtraFieldRepository.queryOne(number);
        if (itemDynamicObject != null) {
            return !itemDynamicObject.getString("id").equalsIgnoreCase(id);
        }
        return false;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        this.getPageCache().put("id", (String)paramMap.get("id"));
        this.getModel().setValue("bankversion", paramMap.get("bankName"));
        this.getModel().setValue("bankversionid", paramMap.get("bankVersionID"));
        this.getModel().setValue("modifier", paramMap.get("modifier"));
        this.getModel().setValue("modifieddate", (Object)DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.setDefaultDataWhenUpdate();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.getView().returnDataToParent((Object)"create_success");
    }
}

