/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.mock.pay;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.formplugin.plugin.log.PayRouteLogPlugin;
import kd.ebg.aqap.formplugin.plugin.mock.pay.MockPayTestPlugin;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class QueryMockPayPlugin
extends AbstractListPlugin {
    public static String ENTITY_NAME = "aqap_bd_mock_payment";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (StringUtils.equals("searchlog", formOperate.getOperateKey()) || StringUtils.equals("routelog", formOperate.getOperateKey())) {
            if (listSelectedData != null && !listSelectedData.isEmpty()) {
                String selField = "batch_seq, bank_batch_seq, insert_time";
                String selNumber = String.valueOf(listSelectedData.get(0).getPrimaryKeyValue());
                QFilter qFilter = QFilter.of((String)"id = ?", (Object[])new Object[]{Long.parseLong(selNumber)});
                DynamicObject payment = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (String)selField, (QFilter[])qFilter.toArray());
                String batch_seq_id = payment.getString("batch_seq");
                Date insertTime = payment.getDate("insert_time");
                String startDate = DateUtil.transTimeZoneSystemToUser((Date)insertTime);
                String endDate = DateUtil.transTimeZoneSystemToUser((Date)new Date());
                if (StringUtils.equals("searchlog", formOperate.getOperateKey())) {
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId("aqap_new_log");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    HashMap params = Maps.newHashMapWithExpectedSize((int)1);
                    params.put("logger_batch_no", batch_seq_id);
                    params.put("trans_date_start", startDate);
                    params.put("trans_date_end", endDate);
                    showParameter.setCustomParams((Map)params);
                    this.getView().showForm((FormShowParameter)showParameter);
                } else if (StringUtils.equals("routelog", formOperate.getOperateKey())) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setFormId(PayRouteLogPlugin.ENTITY_NAME);
                    HashMap<String, String> params = new HashMap<String, String>(16);
                    params.put("id", selNumber);
                    params.put("entityName", ENTITY_NAME);
                    showParameter.setCustomParams(params);
                    this.getView().showForm(showParameter);
                }
            }
        } else if (StringUtils.equals("mockpay", formOperate.getOperateKey())) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId(MockPayTestPlugin.ENTITY_NAME);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

